/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.ribbon.api.ribbon;

import commvault.cte.component.ribbon.api.ribbon.JRibbon;
import commvault.cte.component.ribbon.api.ribbon.RibbonTask;
import java.awt.Color;
import java.util.ArrayList;

public class RibbonContextualTaskGroup {
    private JRibbon ribbon;
    private ArrayList<RibbonTask> tasks;
    private String title;
    private Color hueColor;
    public static final double HUE_ALPHA = 0.25;

    public RibbonContextualTaskGroup(String string, Color color, RibbonTask ... ribbonTaskArray) {
        this.title = string;
        this.hueColor = color;
        this.tasks = new ArrayList();
        for (RibbonTask ribbonTask : ribbonTaskArray) {
            ribbonTask.setContextualGroup(this);
            this.tasks.add(ribbonTask);
        }
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public RibbonTask getTask(int n) {
        return this.tasks.get(n);
    }

    public String getTitle() {
        return this.title;
    }

    public Color getHueColor() {
        return this.hueColor;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.ribbon != null) {
            this.ribbon.fireStateChanged();
        }
    }

    public String toString() {
        return this.getTitle() + " (" + this.getTaskCount() + " tasks)";
    }

    void setRibbon(JRibbon jRibbon) {
        if (this.ribbon != null) {
            throw new IllegalStateException("The contextual task group already belongs to another ribbon");
        }
        this.ribbon = jRibbon;
    }
}

