/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.print;

import commvault.cte.CteStringBank;
import commvault.cte.component.TogglePanel;
import commvault.cte.component.Utilities;
import commvault.cte.util.ReportUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DataSizeSelectionPanel
extends JPanel
implements ActionListener {
    JPanel optionsPanel = new JPanel(new GridLayout(4, 2, 20, 10));
    GridBagConstraints constraints = new GridBagConstraints();
    JRadioButton defaultButton = new JRadioButton(CteStringBank.Default.getI18n());
    JRadioButton bytesButton = new JRadioButton(CteStringBank.Bytes.getI18n());
    JRadioButton KBButton = new JRadioButton(CteStringBank.KB.getI18n());
    JRadioButton MBButton = new JRadioButton(CteStringBank.MB.getI18n());
    JRadioButton GBButton = new JRadioButton(CteStringBank.GB.getI18n());
    JRadioButton TBButton = new JRadioButton(CteStringBank.TB.getI18n());
    JRadioButton PBButton = new JRadioButton(CteStringBank.PB.getI18n());
    JCheckBox overrideDataSizeUnitCB = new JCheckBox(CteStringBank.Override_default_data_size_option.getI18n());
    private String sizeUnitStr = CteStringBank.Default.getI18n();
    private int sizeUnit = 0;
    private String borderTitle = CteStringBank.Default.getI18n();

    public DataSizeSelectionPanel(boolean bl, boolean bl2) {
        Serializable serializable;
        if (bl2) {
            this.borderTitle = CteStringBank.Override_default_data_size_option.getI18n();
            this.optionsPanel = new TogglePanel(this.overrideDataSizeUnitCB);
        } else {
            serializable = new JLabel();
            ((JComponent)serializable).setFont(ReportUtilities.FONT_LABEL_BOLD_12);
            this.optionsPanel.setBorder(BorderFactory.createTitledBorder(this.optionsPanel.getBorder(), this.borderTitle, 1, 2));
        }
        this.optionsPanel.setOpaque(false);
        this.defaultButton.setMnemonic(68);
        this.bytesButton.setMnemonic(66);
        this.KBButton.setMnemonic(75);
        this.MBButton.setMnemonic(77);
        this.GBButton.setMnemonic(71);
        this.TBButton.setMnemonic(84);
        this.PBButton.setMnemonic(80);
        this.defaultButton.setActionCommand(this.defaultButton.getName());
        this.bytesButton.setActionCommand(this.bytesButton.getName());
        this.KBButton.setActionCommand(this.KBButton.getName());
        this.MBButton.setActionCommand(this.MBButton.getName());
        this.GBButton.setActionCommand(this.GBButton.getName());
        this.TBButton.setActionCommand(this.TBButton.getName());
        this.PBButton.setActionCommand(this.PBButton.getName());
        this.defaultButton.addActionListener(this);
        this.bytesButton.addActionListener(this);
        this.KBButton.addActionListener(this);
        this.MBButton.addActionListener(this);
        this.GBButton.addActionListener(this);
        this.TBButton.addActionListener(this);
        this.PBButton.addActionListener(this);
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.defaultButton);
        ((ButtonGroup)serializable).add(this.bytesButton);
        ((ButtonGroup)serializable).add(this.KBButton);
        ((ButtonGroup)serializable).add(this.MBButton);
        ((ButtonGroup)serializable).add(this.GBButton);
        ((ButtonGroup)serializable).add(this.TBButton);
        ((ButtonGroup)serializable).add(this.PBButton);
        if (bl) {
            this.initGridBagLayout();
        } else {
            this.initGridLayout();
        }
    }

    public void initGridBagLayout() {
        this.optionsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.add((Component)this.bytesButton, Utilities.getConstraints(this.constraints, -1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.optionsPanel.add((Component)this.KBButton, Utilities.getConstraints(this.constraints, -1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.optionsPanel.add((Component)this.MBButton, Utilities.getConstraints(this.constraints, -1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.optionsPanel.add((Component)this.GBButton, Utilities.getConstraints(this.constraints, -1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.optionsPanel.add((Component)this.TBButton, Utilities.getConstraints(this.constraints, -1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.optionsPanel.add((Component)this.PBButton, Utilities.getConstraints(this.constraints, -1, -1, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.optionsPanel.add((Component)this.defaultButton, Utilities.getConstraints(this.constraints, -1, -1, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 10, 0, 12)));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.optionsPanel, Utilities.getConstraints(this.constraints, -1, -1, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0)));
    }

    public void initGridLayout() {
        this.optionsPanel.setLayout(new GridLayout(4, 2, 20, 10));
        this.optionsPanel.add(this.bytesButton);
        this.optionsPanel.add(this.KBButton);
        this.optionsPanel.add(this.MBButton);
        this.optionsPanel.add(this.GBButton);
        this.optionsPanel.add(this.TBButton);
        this.optionsPanel.add(this.PBButton);
        this.optionsPanel.add(this.defaultButton);
        this.add(this.optionsPanel);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.defaultButton)) {
            this.setDataSizeUnit(0);
        } else if (actionEvent.getSource().equals(this.bytesButton)) {
            this.setDataSizeUnit(1);
        } else if (actionEvent.getSource().equals(this.KBButton)) {
            this.setDataSizeUnit(2);
        } else if (actionEvent.getSource().equals(this.MBButton)) {
            this.setDataSizeUnit(3);
        } else if (actionEvent.getSource().equals(this.GBButton)) {
            this.setDataSizeUnit(4);
        } else if (actionEvent.getSource().equals(this.TBButton)) {
            this.setDataSizeUnit(5);
        } else if (actionEvent.getSource().equals(this.PBButton)) {
            this.setDataSizeUnit(6);
        }
    }

    public int getDataSizeUnit() {
        return this.sizeUnit;
    }

    public static String getDataSizeUnitStr(int n) {
        switch (n) {
            case 1: {
                return CteStringBank.Bytes.getI18n();
            }
            case 2: {
                return CteStringBank.KB.getI18n();
            }
            case 3: {
                return CteStringBank.MB.getI18n();
            }
            case 4: {
                return CteStringBank.GB.getI18n();
            }
            case 5: {
                return CteStringBank.TB.getI18n();
            }
            case 6: {
                return CteStringBank.PB.getI18n();
            }
        }
        return CteStringBank.emptyString.getI18n();
    }

    public void setDataSizeUnit(int n) {
        this.sizeUnit = n;
        switch (n) {
            case 0: {
                this.defaultButton.setSelected(true);
                break;
            }
            case 1: {
                this.bytesButton.setSelected(true);
                break;
            }
            case 2: {
                this.KBButton.setSelected(true);
                break;
            }
            case 3: {
                this.MBButton.setSelected(true);
                break;
            }
            case 4: {
                this.GBButton.setSelected(true);
                break;
            }
            case 5: {
                this.TBButton.setSelected(true);
                break;
            }
            case 6: {
                this.PBButton.setSelected(true);
                break;
            }
            default: {
                this.sizeUnit = 0;
                this.defaultButton.setSelected(true);
            }
        }
    }

    public boolean isOverrideDataSizeUnitSelected() {
        return this.overrideDataSizeUnitCB.isSelected();
    }
}

