/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.dialogs;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.text.TextEditPopupManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class TextFinderDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final char[] WORD_SEPARATORS = new char[]{' ', '\t', '\n', '\r', '\f', '.', ',', ':', '-', '(', ')', '[', ']', '{', '}', '<', '>', '/', '|', '\\', '\'', '\"'};
    public static final int FIND = 0;
    public static final int REPLACE = 1;
    protected Frame owner;
    protected JTextComponent monitor;
    protected JTabbedPane tb;
    protected JTextField txtFind1;
    protected JTextField txtFind2;
    protected Document docFind;
    protected Document docReplace;
    protected ButtonModel modelWord;
    protected ButtonModel modelCase;
    protected ButtonModel modelUp;
    protected ButtonModel modelDown;
    private TextEditPopupManager popupManager = TextEditPopupManager.getInstance();
    protected boolean searchUp = false;
    protected String searchData;
    private static final String TITLE = HtmleditorStringBank.findAndReplace.getI18n();

    public TextFinderDialog(Frame frame, JTextComponent jTextComponent, int n) {
        super(frame, TITLE, false);
        this.init(jTextComponent, n);
    }

    public TextFinderDialog(Dialog dialog, JTextComponent jTextComponent, int n) {
        super(dialog, TITLE, false);
        this.init(jTextComponent, n);
    }

    private void init(JTextComponent jTextComponent, int n) {
        this.setJTextComponent(jTextComponent);
        this.tb = new JTabbedPane();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new DialogLayout(20, 5));
        jPanel3.setBorder(new EmptyBorder(8, 5, 8, 0));
        jPanel3.add(new JLabel(HtmleditorStringBank.find_what.getI18n()));
        this.txtFind1 = new JTextField();
        this.docFind = this.txtFind1.getDocument();
        jPanel3.add(this.txtFind1);
        jPanel2.add((Component)jPanel3, "Center");
        this.popupManager.registerJTextComponent(this.txtFind1);
        JPanel jPanel4 = new JPanel(new GridLayout(2, 2, 8, 2));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), HtmleditorStringBank.options.getI18n()));
        JCheckBox jCheckBox = new JCheckBox(HtmleditorStringBank.wholeWordsOnly.getI18n());
        jCheckBox.setMnemonic('w');
        this.modelWord = jCheckBox.getModel();
        jPanel4.add(jCheckBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(HtmleditorStringBank.searchUp.getI18n());
        jRadioButton.setMnemonic('u');
        this.modelUp = jRadioButton.getModel();
        buttonGroup.add(jRadioButton);
        jPanel4.add(jRadioButton);
        JCheckBox jCheckBox2 = new JCheckBox(HtmleditorStringBank.matchCase.getI18n());
        jCheckBox2.setMnemonic('c');
        this.modelCase = jCheckBox2.getModel();
        jPanel4.add(jCheckBox2);
        JRadioButton jRadioButton2 = new JRadioButton(HtmleditorStringBank.searchDown.getI18n(), true);
        jRadioButton2.setMnemonic('d');
        this.modelDown = jRadioButton2.getModel();
        buttonGroup.add(jRadioButton2);
        jPanel4.add(jRadioButton2);
        jPanel2.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel(new FlowLayout());
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1, 2, 8));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextFinderDialog.this.findNext(false, true);
            }
        };
        JButton jButton = new JButton(HtmleditorStringBank.findNext.getI18n());
        jButton.addActionListener(actionListener);
        jButton.setMnemonic('f');
        jPanel6.add(jButton);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextFinderDialog.this.setVisible(false);
            }
        };
        JButton jButton2 = new JButton(HtmleditorStringBank.close.getI18n());
        jButton2.addActionListener(actionListener2);
        jButton2.setDefaultCapable(true);
        jPanel6.add(jButton2);
        jPanel5.add(jPanel6);
        jPanel.add((Component)jPanel5, "East");
        this.tb.addTab(HtmleditorStringBank.find.getI18n(), jPanel);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JPanel jPanel8 = new JPanel(new BorderLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new DialogLayout(20, 5));
        jPanel9.setBorder(new EmptyBorder(8, 5, 8, 0));
        jPanel9.add(new JLabel(HtmleditorStringBank.find_what.getI18n()));
        this.txtFind2 = new JTextField();
        this.txtFind2.setDocument(this.docFind);
        jPanel9.add(this.txtFind2);
        this.popupManager.registerJTextComponent(this.txtFind2);
        jPanel9.add(new JLabel(HtmleditorStringBank.replace.getI18n()));
        JTextField jTextField = new JTextField();
        this.docReplace = jTextField.getDocument();
        jPanel9.add(jTextField);
        jPanel8.add((Component)jPanel9, "Center");
        this.popupManager.registerJTextComponent(jTextField);
        jPanel4 = new JPanel(new GridLayout(2, 2, 8, 2));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), HtmleditorStringBank.options.getI18n()));
        jCheckBox = new JCheckBox(HtmleditorStringBank.wholeWordsOnly.getI18n());
        jCheckBox.setMnemonic('w');
        jCheckBox.setModel(this.modelWord);
        jPanel4.add(jCheckBox);
        buttonGroup = new ButtonGroup();
        jRadioButton = new JRadioButton(HtmleditorStringBank.searchUp.getI18n());
        jRadioButton.setMnemonic('u');
        jRadioButton.setModel(this.modelUp);
        buttonGroup.add(jRadioButton);
        jPanel4.add(jRadioButton);
        jCheckBox2 = new JCheckBox(HtmleditorStringBank.matchCase.getI18n());
        jCheckBox2.setMnemonic('c');
        jCheckBox2.setModel(this.modelCase);
        jPanel4.add(jCheckBox2);
        jRadioButton2 = new JRadioButton(HtmleditorStringBank.searchDown.getI18n(), true);
        jRadioButton2.setMnemonic('d');
        jRadioButton2.setModel(this.modelDown);
        buttonGroup.add(jRadioButton2);
        jPanel4.add(jRadioButton2);
        jPanel8.add((Component)jPanel4, "South");
        jPanel7.add((Component)jPanel8, "Center");
        JPanel jPanel10 = new JPanel(new FlowLayout());
        jPanel6 = new JPanel(new GridLayout(3, 1, 2, 8));
        ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextFinderDialog.this.findNext(true, true);
            }
        };
        JButton jButton3 = new JButton(HtmleditorStringBank.replace.getI18n());
        jButton3.addActionListener(actionListener3);
        jButton3.setMnemonic('r');
        jPanel6.add(jButton3);
        ActionListener actionListener4 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (true) {
                    int n2;
                    if ((n2 = TextFinderDialog.this.findNext(true, false)) < 0) {
                        return;
                    }
                    if (n2 == 0) break;
                    ++n;
                }
                JOptionPane.showMessageDialog(TextFinderDialog.this.owner, n + " " + HtmleditorStringBank.replacements_prompt.getI18n(), "Info", 1);
            }
        };
        JButton jButton4 = new JButton(HtmleditorStringBank.replaceAll.getI18n());
        jButton4.addActionListener(actionListener4);
        jButton4.setMnemonic('a');
        jPanel6.add(jButton4);
        jButton2 = new JButton(HtmleditorStringBank.close.getI18n());
        jButton2.addActionListener(actionListener2);
        jButton2.setDefaultCapable(true);
        jPanel6.add(jButton2);
        jPanel10.add(jPanel6);
        jPanel7.add((Component)jPanel10, "East");
        jPanel5.setPreferredSize(jPanel10.getPreferredSize());
        this.tb.addTab(HtmleditorStringBank.replace.getI18n(), jPanel7);
        this.tb.setSelectedIndex(n);
        this.getContentPane().add((Component)this.tb, "Center");
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (TextFinderDialog.this.tb.getSelectedIndex() == 0) {
                    if (!TextFinderDialog.this.txtFind1.hasFocus()) {
                        TextFinderDialog.this.txtFind1.requestFocusInWindow();
                    } else if (!TextFinderDialog.this.txtFind2.hasFocus()) {
                        TextFinderDialog.this.txtFind2.requestFocusInWindow();
                    }
                }
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                TextFinderDialog.this.searchData = null;
            }
        };
        this.addWindowListener(windowAdapter);
        this.pack();
        this.setResizable(false);
    }

    public void setJTextComponent(JTextComponent jTextComponent) {
        this.monitor = jTextComponent;
        if (!this.monitor.hasFocus()) {
            this.monitor.requestFocusInWindow();
        }
    }

    public JTextComponent getJTextComponent() {
        return this.monitor;
    }

    public void setSelectedIndex(int n) {
        this.tb.setSelectedIndex(n);
    }

    public int getSelectedIndex() {
        return this.tb.getSelectedIndex();
    }

    public void show(int n) {
        this.setSelectedIndex(n);
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        if (!this.monitor.hasFocus()) {
            this.monitor.requestFocusInWindow();
        }
    }

    public int findNext(boolean bl, boolean bl2) {
        int n;
        String string;
        String string2;
        block19: {
            int n2 = this.monitor.getCaretPosition();
            string2 = "";
            try {
                string2 = this.docFind.getText(0, this.docFind.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string2.length() == 0) {
                this.warning(HtmleditorStringBank.no_target_prompt.getI18n());
                return -1;
            }
            if (this.modelWord.isSelected()) {
                for (int i = 0; i < WORD_SEPARATORS.length; ++i) {
                    if (string2.indexOf(WORD_SEPARATORS[i]) < 0) continue;
                    this.warning(HtmleditorStringBank.illegal_character_prompt.getI18n() + " '" + WORD_SEPARATORS[i] + "'");
                    return -1;
                }
            }
            string = "";
            if (bl) {
                try {
                    string = this.docReplace.getText(0, this.docReplace.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (this.modelUp.isSelected() != this.searchUp) {
                this.searchUp = this.modelUp.isSelected();
            }
            String string3 = "";
            try {
                string3 = this.monitor.getDocument().getText(0, this.monitor.getDocument().getLength());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
            if (!this.modelCase.isSelected()) {
                string3 = string3.toLowerCase();
                string2 = string2.toLowerCase();
            }
            while (true) {
                boolean bl3;
                if ((n = !this.searchUp ? string3.indexOf(string2, n2) : string3.lastIndexOf(string2, n2 - 1)) < 0 || n >= string3.length()) {
                    if (bl2) {
                        this.warning(HtmleditorStringBank.textNotFound.getI18n());
                    }
                    return 0;
                }
                if (!this.modelWord.isSelected()) break block19;
                boolean bl4 = n > 0;
                boolean bl5 = bl4 && !this.isSeparator(string3.charAt(n - 1));
                boolean bl6 = n + string2.length() < string3.length();
                boolean bl7 = bl3 = bl6 && !this.isSeparator(string3.charAt(n + string2.length()));
                if (!bl5 && !bl3) break block19;
                if (!this.searchUp && bl6) {
                    n2 = n + string2.length();
                    continue;
                }
                if (!this.searchUp || !bl4) break;
                n2 = n;
            }
            if (bl2) {
                this.warning(HtmleditorStringBank.textNotFound.getI18n());
            }
            return 0;
        }
        if (bl) {
            this.setSelection(n, n + string2.length(), this.searchUp);
            this.monitor.replaceSelection(string);
            this.setSelection(n, n + string.length(), this.searchUp);
        } else {
            this.setSelection(n, n + string2.length(), this.searchUp);
        }
        return 1;
    }

    public void setSelection(int n, int n2, boolean bl) {
        if (bl) {
            this.monitor.setCaretPosition(n2);
            this.monitor.moveCaretPosition(n);
        } else {
            this.monitor.setCaretPosition(n);
            this.monitor.moveCaretPosition(n2);
        }
    }

    protected boolean isSeparator(char c) {
        for (int i = 0; i < WORD_SEPARATORS.length; ++i) {
            if (c != WORD_SEPARATORS[i]) continue;
            return true;
        }
        return false;
    }

    protected void warning(String string) {
        JOptionPane.showMessageDialog(this.owner, string, TITLE, 1);
    }

    private class DialogLayout
    implements LayoutManager {
        protected static final int COMP_TWO_COL = 0;
        protected static final int COMP_BIG = 1;
        protected static final int COMP_BUTTON = 2;
        protected int m_divider = -1;
        protected int m_hGap = 10;
        protected int m_vGap = 5;
        protected Vector m_v = new Vector();

        public DialogLayout() {
        }

        public DialogLayout(int n, int n2) {
            this.m_hGap = n;
            this.m_vGap = n2;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Serializable serializable;
            this.m_v.removeAllElements();
            int n = 0;
            int n2 = 0;
            int n3 = -1;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                serializable = container.getComponent(i);
                int n4 = this.getLayoutType((Component)serializable);
                if (i == 0) {
                    n3 = n4;
                }
                if (n3 != n4) {
                    Dimension dimension = this.preferredLayoutSize(this.m_v, n3);
                    n = Math.max(n, dimension.width);
                    n2 += dimension.height + this.m_vGap;
                    this.m_v.removeAllElements();
                    n3 = n4;
                }
                this.m_v.addElement(serializable);
            }
            Dimension dimension = this.preferredLayoutSize(this.m_v, n3);
            n = Math.max(n, dimension.width);
            n2 += dimension.height + this.m_vGap;
            serializable = container.getInsets();
            return new Dimension(n + ((Insets)serializable).left + ((Insets)serializable).right, (n2 -= this.m_vGap) + ((Insets)serializable).top + ((Insets)serializable).bottom);
        }

        protected Dimension preferredLayoutSize(Vector vector, int n) {
            int n2 = 0;
            int n3 = 0;
            switch (n) {
                case 0: {
                    int n4 = this.getDivider(vector);
                    for (int i = 1; i < vector.size(); i += 2) {
                        Component component = (Component)vector.elementAt(i);
                        Dimension dimension = component.getPreferredSize();
                        n2 = Math.max(n2, dimension.width);
                        n3 += dimension.height + this.m_vGap;
                    }
                    return new Dimension(n4 + n2, n3 -= this.m_vGap);
                }
                case 1: {
                    for (int i = 0; i < vector.size(); ++i) {
                        Component component = (Component)vector.elementAt(i);
                        Dimension dimension = component.getPreferredSize();
                        n2 = Math.max(n2, dimension.width);
                        n3 += dimension.height + this.m_vGap;
                    }
                    return new Dimension(n2, n3 -= this.m_vGap);
                }
                case 2: {
                    Dimension dimension = this.getMaxDimension(vector);
                    n2 = dimension.width + this.m_hGap;
                    n3 = dimension.height;
                    return new Dimension(n2 * vector.size() - this.m_hGap, n3);
                }
            }
            throw new IllegalArgumentException("Illegal type " + n);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            this.m_v.removeAllElements();
            int n = -1;
            Insets insets = container.getInsets();
            int n2 = container.getWidth() - insets.left - insets.right;
            int n3 = insets.left;
            int n4 = insets.top;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                int n5 = this.getLayoutType(component);
                if (i == 0) {
                    n = n5;
                }
                if (n != n5) {
                    n4 = this.layoutComponents(this.m_v, n, n3, n4, n2);
                    this.m_v.removeAllElements();
                    n = n5;
                }
                this.m_v.addElement(component);
            }
            n4 = this.layoutComponents(this.m_v, n, n3, n4, n2);
            this.m_v.removeAllElements();
        }

        protected int layoutComponents(Vector vector, int n, int n2, int n3, int n4) {
            switch (n) {
                case 0: {
                    int n5 = this.getDivider(vector);
                    for (int i = 1; i < vector.size(); i += 2) {
                        Component component = (Component)vector.elementAt(i - 1);
                        Component component2 = (Component)vector.elementAt(i);
                        Dimension dimension = component2.getPreferredSize();
                        component.setBounds(n2, n3, n5, dimension.height);
                        component2.setBounds(n2 + n5, n3, n4 - n5, dimension.height);
                        n3 += dimension.height + this.m_vGap;
                    }
                    return n3;
                }
                case 1: {
                    for (int i = 0; i < vector.size(); ++i) {
                        Component component = (Component)vector.elementAt(i);
                        Dimension dimension = component.getPreferredSize();
                        component.setBounds(n2, n3, n4, dimension.height);
                        n3 += dimension.height + this.m_vGap;
                    }
                    return n3;
                }
                case 2: {
                    Dimension dimension = this.getMaxDimension(vector);
                    int n6 = dimension.width * vector.size() + this.m_hGap * (vector.size() - 1);
                    int n7 = n2 + Math.max(0, (n4 - n6) / 2);
                    for (int i = 0; i < vector.size(); ++i) {
                        Component component = (Component)vector.elementAt(i);
                        component.setBounds(n7, n3, dimension.width, dimension.height);
                        n7 += dimension.width + this.m_hGap;
                    }
                    return n3 + dimension.height;
                }
            }
            throw new IllegalArgumentException("Illegal type " + n);
        }

        public int getHGap() {
            return this.m_hGap;
        }

        public int getVGap() {
            return this.m_vGap;
        }

        public void setDivider(int n) {
            if (n > 0) {
                this.m_divider = n;
            }
        }

        public int getDivider() {
            return this.m_divider;
        }

        protected int getDivider(Vector vector) {
            if (this.m_divider > 0) {
                return this.m_divider;
            }
            int n = 0;
            for (int i = 0; i < vector.size(); i += 2) {
                Component component = (Component)vector.elementAt(i);
                Dimension dimension = component.getPreferredSize();
                n = Math.max(n, dimension.width);
            }
            return n += this.m_hGap;
        }

        protected Dimension getMaxDimension(Vector vector) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                Component component = (Component)vector.elementAt(i);
                Dimension dimension = component.getPreferredSize();
                n = Math.max(n, dimension.width);
                n2 = Math.max(n2, dimension.height);
            }
            return new Dimension(n, n2);
        }

        protected int getLayoutType(Component component) {
            if (component instanceof AbstractButton) {
                return 2;
            }
            if (component instanceof JPanel || component instanceof JScrollPane || component instanceof JTabbedPane) {
                return 1;
            }
            return 0;
        }
    }
}

