/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.ui.text.actions;

import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.CompoundUndoManager;
import commvault.cte.component.htmleditor.ui.text.HTMLUtils;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTextEditAction;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class HTMLAlignAction
extends HTMLTextEditAction {
    private static final long serialVersionUID = 1L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int JUSTIFY = 3;
    public static final String[] ALIGNMENT_NAMES = new String[]{HtmleditorStringBank.left.getI18n(), HtmleditorStringBank.center.getI18n(), HtmleditorStringBank.right.getI18n(), HtmleditorStringBank.justify.getI18n()};
    private static final int[] MNEMS = new int[]{76, 67, 82, 74};
    public static final String[] ALIGNMENTS = new String[]{"left", "center", "right", "justify"};
    private static final String[] IMGS = new String[]{"al_left.png", "al_center.png", "al_right.png", "al_just.png"};
    private int align;

    public HTMLAlignAction(int n) throws IllegalArgumentException {
        super("");
        if (n < 0 || n >= ALIGNMENTS.length) {
            throw new IllegalArgumentException("Illegal Argument");
        }
        this.putValue("Name", ALIGNMENT_NAMES[n]);
        this.putValue("MnemonicKey", new Integer(MNEMS[n]));
        this.putValue("SmallIcon", UIUtils.getIcon("images/x16/", IMGS[n]));
        this.putValue("BUTTON_TYPE", "radio");
        this.align = n;
    }

    @Override
    protected void updateWysiwygContextState(JEditorPane jEditorPane) {
        this.setSelected(this.shouldBeSelected(jEditorPane));
    }

    private boolean shouldBeSelected(JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getCaretPosition());
        if (HTMLUtils.isImplied(element)) {
            element = element.getParentElement();
        }
        AttributeSet attributeSet = element.getAttributes();
        return attributeSet.containsAttribute(HTML.Attribute.ALIGN, ALIGNMENTS[this.align]);
    }

    @Override
    protected void updateSourceContextState(JEditorPane jEditorPane) {
        this.setSelected(false);
    }

    @Override
    protected void wysiwygEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        Element element = hTMLDocument.getParagraphElement(jEditorPane.getSelectionStart());
        Element element2 = hTMLDocument.getParagraphElement(jEditorPane.getSelectionEnd());
        CompoundUndoManager.beginCompoundEdit(hTMLDocument);
        while (true) {
            this.alignElement(element);
            if (element.getEndOffset() >= element2.getEndOffset() || element.getEndOffset() >= hTMLDocument.getLength()) break;
            element = hTMLDocument.getParagraphElement(element.getEndOffset() + 1);
        }
        CompoundUndoManager.endCompoundEdit(hTMLDocument);
    }

    private void alignElement(Element element) {
        HTMLDocument hTMLDocument = (HTMLDocument)element.getDocument();
        if (HTMLUtils.isImplied(element)) {
            HTML.Tag tag = HTML.getTag(element.getParentElement().getName());
            if (!(tag == null || tag.equals(HTML.Tag.BODY) || tag.isPreformatted() || tag.equals(HTML.Tag.DD))) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
                simpleAttributeSet.removeAttribute("align");
                simpleAttributeSet.addAttribute("align", ALIGNMENTS[this.align]);
                Element element2 = element.getParentElement();
                String string = HTMLUtils.getElementHTML(element, false);
                string = HTMLUtils.createTag(tag, simpleAttributeSet, string);
                String string2 = "";
                for (int i = 0; i < element2.getElementCount(); ++i) {
                    Element element3 = element2.getElement(i);
                    string2 = element3 == element ? string2 + string : string2 + HTMLUtils.getElementHTML(element3, true);
                }
                try {
                    hTMLDocument.setOuterHTML(element2, string2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(element.getAttributes());
            simpleAttributeSet.removeAttribute(HTML.Attribute.ALIGN);
            simpleAttributeSet.addAttribute(HTML.Attribute.ALIGN, ALIGNMENTS[this.align]);
            int n = element.getStartOffset();
            int n2 = element.getEndOffset() - element.getStartOffset();
            hTMLDocument.setParagraphAttributes(n, n2 - 1, simpleAttributeSet, true);
        }
    }

    @Override
    protected void sourceEditPerformed(ActionEvent actionEvent, JEditorPane jEditorPane) {
        String string = "<p align=\"" + ALIGNMENTS[this.align] + "\">";
        String string2 = "</p>";
        String string3 = jEditorPane.getSelectedText();
        if (string3 == null) {
            jEditorPane.replaceSelection(string + string2);
            int n = jEditorPane.getCaretPosition() - string2.length();
            if (n >= 0) {
                jEditorPane.setCaretPosition(n);
            }
        } else {
            string3 = string + string3 + string2;
            jEditorPane.replaceSelection(string3);
        }
    }
}

