/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.htmleditor.shef;

import commvault.cte.component.Utilities;
import commvault.cte.component.htmleditor.HtmleditorStringBank;
import commvault.cte.component.htmleditor.ui.DefaultAction;
import commvault.cte.component.htmleditor.ui.UIUtils;
import commvault.cte.component.htmleditor.ui.text.CompoundUndoManager;
import commvault.cte.component.htmleditor.ui.text.Entities;
import commvault.cte.component.htmleditor.ui.text.HTMLUtils;
import commvault.cte.component.htmleditor.ui.text.IndentationFilter;
import commvault.cte.component.htmleditor.ui.text.SourceCodeEditor;
import commvault.cte.component.htmleditor.ui.text.WysiwygHTMLEditorKit;
import commvault.cte.component.htmleditor.ui.text.actions.ClearStylesAction;
import commvault.cte.component.htmleditor.ui.text.actions.FindReplaceAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLEditorActionFactory;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLElementPropertiesAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLFontAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLFontColorAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLHorizontalRuleAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLImageAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLInlineAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLLineBreakAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLLinkAction;
import commvault.cte.component.htmleditor.ui.text.actions.HTMLTableAction;
import commvault.cte.component.htmleditor.ui.text.actions.SpecialCharAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ToolBarUI;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.undo.UndoManager;
import novaworx.syntax.SyntaxFactory;
import novaworx.textpane.SyntaxDocument;
import novaworx.textpane.SyntaxGutter;
import novaworx.textpane.SyntaxGutterBase;
import novaworx.textpane.SyntaxTextPane;
import org.bushe.swing.action.ActionList;
import org.bushe.swing.action.ActionUIFactory;

public class HTMLEditorPane
extends JPanel {
    public static final String DOCUMENT_CHANGE_EVENT = "documentChanged";
    private static final String[] INVALID_TAGS = new String[]{"html", "head", "body", "title"};
    private JEditorPane wysEditor;
    private SourceCodeEditor srcEditor;
    private JEditorPane focusedEditor;
    private JComboBox fontFamilyCombo;
    private JComboBox paragraphCombo;
    private JTabbedPane tabs;
    private JToolBar formatToolBar;
    private JMenu editMenu;
    private JMenu formatMenu;
    private JMenu insertMenu;
    private JPopupMenu wysPopupMenu;
    private JPopupMenu srcPopupMenu;
    private ActionList actionList;
    private FocusListener focusHandler = new FocusHandler();
    private DocumentListener textChangedHandler = new TextChangedHandler();
    private ActionListener fontChangeHandler = new FontChangeHandler();
    private ActionListener paragraphComboHandler = new ParagraphComboHandler();
    private CaretListener caretHandler = new CaretHandler();
    private MouseListener popupHandler = new PopupHandler();
    private boolean isWysTextChanged;
    private int selectionStart;
    private int selectionEnd;

    public HTMLEditorPane() {
        this.initUI();
    }

    public void replaceSelection(String string) {
        if (this.tabs.getSelectedIndex() == 0) {
            this.wysEditor.replaceSelection(string);
        }
    }

    public int getCaretPosition() {
        if (this.tabs.getSelectedIndex() == 0) {
            return this.wysEditor.getCaretPosition();
        }
        return this.srcEditor.getCaretPosition();
    }

    public void setCaretPosition(int n) {
        if (this.tabs.getSelectedIndex() == 0) {
            this.wysEditor.setCaretPosition(n);
            this.wysEditor.requestFocusInWindow();
        } else if (this.tabs.getSelectedIndex() == 1) {
            this.srcEditor.setCaretPosition(n);
            this.srcEditor.requestFocusInWindow();
        }
    }

    public void setSelectedTab(int n) {
        this.tabs.setSelectedIndex(n);
    }

    private void initUI() {
        this.createEditorTabs();
        this.createEditorActions();
        this.setLayout(new BorderLayout());
        this.addMenuBar();
        this.add((Component)this.tabs, "Center");
    }

    private void addMenuBar() {
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        JMenuBar jMenuBar = Utilities.getMenuBar();
        jMenuBar.add(this.getEditMenu());
        jMenuBar.add(this.getFormatMenu());
        jMenuBar.add(this.getInsertMenu());
        jPanel.add((Component)jMenuBar, "North");
        this.formatToolBar.setOpaque(true);
        jPanel.add((Component)this.formatToolBar, "Center");
        this.add((Component)jPanel, "North");
        ToolBarUI toolBarUI = this.formatToolBar.getUI();
        JInternalFrame jInternalFrame = new JInternalFrame("Test", true, true, true, true);
    }

    public JMenu getEditMenu() {
        return this.editMenu;
    }

    public JMenu getFormatMenu() {
        return this.formatMenu;
    }

    public JMenu getInsertMenu() {
        return this.insertMenu;
    }

    private void createEditorActions() {
        this.actionList = new ActionList((Object)"editor-actions");
        ActionList actionList = new ActionList((Object)"paraActions");
        ActionList actionList2 = new ActionList((Object)"fontSizeActions");
        ActionList actionList3 = HTMLEditorActionFactory.createEditActionList();
        HTMLElementPropertiesAction hTMLElementPropertiesAction = new HTMLElementPropertiesAction();
        this.wysPopupMenu = ActionUIFactory.getInstance().createPopupMenu(actionList3);
        this.wysPopupMenu.addSeparator();
        this.wysPopupMenu.add((Action)((Object)hTMLElementPropertiesAction));
        this.srcPopupMenu = ActionUIFactory.getInstance().createPopupMenu(actionList3);
        JMenu jMenu = new JMenu(HtmleditorStringBank.file.getI18n());
        ActionList actionList4 = new ActionList((Object)HtmleditorStringBank.edit.getI18n());
        DefaultAction defaultAction = new ChangeTabAction(0);
        actionList4.add((Object)defaultAction);
        defaultAction = new ChangeTabAction(1);
        actionList4.add((Object)defaultAction);
        actionList4.add(null);
        actionList4.addAll((Collection)actionList3);
        actionList4.add(null);
        actionList4.add((Object)new FindReplaceAction(false));
        this.actionList.addAll((Collection)actionList4);
        this.editMenu = ActionUIFactory.getInstance().createMenu(actionList4);
        this.editMenu.setText(HtmleditorStringBank.edit.getI18n());
        this.formatMenu = new JMenu(HtmleditorStringBank.format.getI18n());
        actionList4 = HTMLEditorActionFactory.createFontSizeActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, HtmleditorStringBank.size.getI18n()));
        actionList2.addAll((Collection)actionList4);
        actionList4 = HTMLEditorActionFactory.createInlineActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, HtmleditorStringBank.style.getI18n()));
        defaultAction = new HTMLFontColorAction();
        this.actionList.add((Object)defaultAction);
        this.formatMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLFontAction();
        this.actionList.add((Object)defaultAction);
        this.formatMenu.add((Action)((Object)defaultAction));
        defaultAction = new ClearStylesAction();
        this.actionList.add((Object)defaultAction);
        this.formatMenu.add((Action)((Object)defaultAction));
        this.formatMenu.addSeparator();
        actionList4 = HTMLEditorActionFactory.createBlockElementActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, HtmleditorStringBank.paragraph.getI18n()));
        actionList.addAll((Collection)actionList4);
        actionList4 = HTMLEditorActionFactory.createListElementActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, HtmleditorStringBank.list.getI18n()));
        this.formatMenu.addSeparator();
        actionList.addAll((Collection)actionList4);
        actionList4 = HTMLEditorActionFactory.createAlignActionList();
        this.actionList.addAll((Collection)actionList4);
        this.formatMenu.add(this.createMenu(actionList4, HtmleditorStringBank.align.getI18n()));
        JMenu jMenu2 = new JMenu(HtmleditorStringBank.table.getI18n());
        actionList4 = HTMLEditorActionFactory.createInsertTableElementActionList();
        this.actionList.addAll((Collection)actionList4);
        jMenu2.add(this.createMenu(actionList4, HtmleditorStringBank.insert.getI18n()));
        actionList4 = HTMLEditorActionFactory.createDeleteTableElementActionList();
        this.actionList.addAll((Collection)actionList4);
        jMenu2.add(this.createMenu(actionList4, HtmleditorStringBank.delete.getI18n()));
        this.formatMenu.add(jMenu2);
        this.formatMenu.addSeparator();
        this.actionList.add((Object)hTMLElementPropertiesAction);
        this.formatMenu.add((Action)((Object)hTMLElementPropertiesAction));
        this.insertMenu = new JMenu(HtmleditorStringBank.insert.getI18n());
        defaultAction = new HTMLLinkAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLImageAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLTableAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        this.insertMenu.addSeparator();
        defaultAction = new HTMLLineBreakAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new HTMLHorizontalRuleAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        defaultAction = new SpecialCharAction();
        this.actionList.add((Object)defaultAction);
        this.insertMenu.add((Action)((Object)defaultAction));
        this.createFormatToolBar(actionList, actionList2);
    }

    public JPopupMenu getwysPopupMenu() {
        return this.wysPopupMenu;
    }

    private void createFormatToolBar(ActionList actionList, ActionList actionList2) {
        Object object2;
        this.formatToolBar = new JToolBar();
        this.formatToolBar.setRollover(true);
        this.formatToolBar.setFloatable(true);
        Font font = new Font("Dialog", 0, 12);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selected") && propertyChangeEvent.getNewValue().equals(Boolean.TRUE)) {
                    HTMLEditorPane.this.paragraphCombo.removeActionListener(HTMLEditorPane.this.paragraphComboHandler);
                    HTMLEditorPane.this.paragraphCombo.setSelectedItem(propertyChangeEvent.getSource());
                    HTMLEditorPane.this.paragraphCombo.addActionListener(HTMLEditorPane.this.paragraphComboHandler);
                }
            }
        };
        for (Object object2 : actionList) {
            if (!(object2 instanceof DefaultAction)) continue;
            ((DefaultAction)((Object)object2)).addPropertyChangeListener(propertyChangeListener);
        }
        this.paragraphCombo = new JComboBox<Action>(this.toArray(actionList));
        this.paragraphCombo.setPreferredSize(new Dimension(100, 22));
        this.paragraphCombo.setMinimumSize(new Dimension(100, 22));
        this.paragraphCombo.setMaximumSize(new Dimension(100, 22));
        this.paragraphCombo.setFont(font);
        this.paragraphCombo.addActionListener(this.paragraphComboHandler);
        this.paragraphCombo.setRenderer(new ParagraphComboRenderer());
        this.formatToolBar.add(this.paragraphCombo);
        this.formatToolBar.addSeparator();
        this.paragraphCombo.setSelectedIndex(1);
        Vector vector = new Vector();
        vector.add("Default");
        vector.add("serif");
        vector.add("sans-serif");
        vector.add("monospaced");
        object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
        vector.addAll(Arrays.asList(((GraphicsEnvironment)object2).getAvailableFontFamilyNames()));
        this.fontFamilyCombo = new JComboBox(vector);
        this.fontFamilyCombo.setPreferredSize(new Dimension(130, 22));
        this.fontFamilyCombo.setMinimumSize(new Dimension(130, 22));
        this.fontFamilyCombo.setMaximumSize(new Dimension(130, 22));
        this.fontFamilyCombo.setFont(font);
        this.fontFamilyCombo.addActionListener(this.fontChangeHandler);
        this.formatToolBar.add(this.fontFamilyCombo);
        final JButton jButton = new JButton(UIUtils.getIcon("images/x16/", "fontsize.png"));
        final JPopupMenu jPopupMenu = ActionUIFactory.getInstance().createPopupMenu(actionList2);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jPopupMenu.show(jButton, 0, jButton.getHeight());
            }
        };
        jButton.addActionListener(actionListener);
        this.configToolbarButton(jButton);
        this.formatToolBar.add(jButton);
        Object object32 = new HTMLFontColorAction();
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
        this.formatToolBar.addSeparator();
        object32 = new HTMLInlineAction(6);
        object32.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
        object32 = new HTMLInlineAction(7);
        object32.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
        object32 = new HTMLInlineAction(8);
        object32.putValue("BUTTON_TYPE", "toggle");
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
        this.formatToolBar.addSeparator();
        ActionList actionList3 = HTMLEditorActionFactory.createListElementActionList();
        for (Object object32 : actionList3) {
            object32.putValue("BUTTON_TYPE", "toggle");
            this.actionList.add(object32);
            this.addToToolBar(this.formatToolBar, (Action)object32);
        }
        this.formatToolBar.addSeparator();
        actionList3 = HTMLEditorActionFactory.createAlignActionList();
        for (Object object32 : actionList3) {
            object32.putValue("BUTTON_TYPE", "toggle");
            this.actionList.add(object32);
            this.addToToolBar(this.formatToolBar, (Action)object32);
        }
        this.formatToolBar.addSeparator();
        object32 = new HTMLLinkAction();
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
        object32 = new HTMLImageAction();
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
        object32 = new HTMLTableAction();
        this.actionList.add(object32);
        this.addToToolBar(this.formatToolBar, (Action)object32);
    }

    private void addToToolBar(JToolBar jToolBar, Action action) {
        AbstractButton abstractButton = ActionUIFactory.getInstance().createButton(action);
        this.configToolbarButton(abstractButton);
        jToolBar.add(abstractButton);
    }

    private Action[] toArray(ActionList actionList) {
        ArrayList arrayList = new ArrayList();
        for (Object e : actionList) {
            if (e == null || !(e instanceof Action)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void configToolbarButton(AbstractButton abstractButton) {
        abstractButton.setText(null);
        abstractButton.setMnemonic(0);
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        abstractButton.setMaximumSize(new Dimension(22, 22));
        abstractButton.setMinimumSize(new Dimension(22, 22));
        abstractButton.setPreferredSize(new Dimension(22, 22));
        abstractButton.setFocusable(false);
        abstractButton.setFocusPainted(false);
        Action action = abstractButton.getAction();
        if (action != null) {
            abstractButton.setToolTipText(action.getValue("Name").toString());
        }
    }

    private JMenu createMenu(ActionList actionList, String string) {
        JMenu jMenu = ActionUIFactory.getInstance().createMenu(actionList);
        jMenu.setText(string);
        return jMenu;
    }

    public void addHTMLEditorFocusListener(FocusListener focusListener) {
        this.wysEditor.addFocusListener(focusListener);
    }

    private void createEditorTabs() {
        this.tabs = new JTabbedPane(3);
        this.wysEditor = this.createWysiwygEditor();
        this.srcEditor = this.createSourceEditor();
        this.tabs.addTab("Edit", new JScrollPane(this.wysEditor));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.srcEditor));
        SyntaxGutter syntaxGutter = new SyntaxGutter((SyntaxTextPane)this.srcEditor);
        SyntaxGutterBase syntaxGutterBase = new SyntaxGutterBase(syntaxGutter);
        jScrollPane.setRowHeaderView((Component)syntaxGutter);
        jScrollPane.setCorner("LOWER_LEFT_CORNER", (Component)syntaxGutterBase);
        this.tabs.addTab("HTML", jScrollPane);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                HTMLEditorPane.this.updateEditView();
                HTMLEditorPane.this.setCaretPosition(0);
            }
        });
    }

    private SourceCodeEditor createSourceEditor() {
        SourceCodeEditor sourceCodeEditor = new SourceCodeEditor();
        SyntaxDocument syntaxDocument = new SyntaxDocument();
        syntaxDocument.setSyntax(SyntaxFactory.getSyntax((String)"html"));
        CompoundUndoManager compoundUndoManager = new CompoundUndoManager((Document)syntaxDocument, new UndoManager());
        syntaxDocument.addUndoableEditListener((UndoableEditListener)compoundUndoManager);
        syntaxDocument.setDocumentFilter((DocumentFilter)new IndentationFilter());
        syntaxDocument.addDocumentListener(this.textChangedHandler);
        sourceCodeEditor.setDocument((Document)syntaxDocument);
        sourceCodeEditor.addFocusListener(this.focusHandler);
        sourceCodeEditor.addCaretListener(this.caretHandler);
        sourceCodeEditor.addMouseListener(this.popupHandler);
        return sourceCodeEditor;
    }

    private JEditorPane createWysiwygEditor() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKitForContentType("text/html", new WysiwygHTMLEditorKit());
        jEditorPane.setContentType("text/html");
        this.insertHTML(jEditorPane, "<p></p>", 0);
        jEditorPane.addCaretListener(this.caretHandler);
        jEditorPane.addFocusListener(this.focusHandler);
        jEditorPane.addMouseListener(this.popupHandler);
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        CompoundUndoManager compoundUndoManager = new CompoundUndoManager(hTMLDocument, new UndoManager());
        hTMLDocument.addUndoableEditListener(compoundUndoManager);
        hTMLDocument.addDocumentListener(this.textChangedHandler);
        return jEditorPane;
    }

    private void insertHTML(JEditorPane jEditorPane, String string, int n) {
        try {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKit();
            Document document = jEditorPane.getDocument();
            StringReader stringReader = new StringReader(HTMLUtils.jEditorPaneizeHTML(string));
            hTMLEditorKit.read(stringReader, document, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateEditView() {
        if (this.tabs.getSelectedIndex() == 0) {
            String string = this.removeInvalidTags(this.srcEditor.getText());
            this.wysEditor.setText("");
            this.insertHTML(this.wysEditor, string, 0);
            CompoundUndoManager.discardAllEdits(this.wysEditor.getDocument());
        } else {
            String string = this.removeInvalidTags(this.wysEditor.getText());
            if (this.isWysTextChanged || this.srcEditor.getText().equals("")) {
                String string2 = this.deIndent(this.removeInvalidTags(string));
                string2 = Entities.HTML40.unescapeUnknownEntities(string2);
                this.srcEditor.setText(string2);
            }
            CompoundUndoManager.discardAllEdits(this.srcEditor.getDocument());
        }
        this.isWysTextChanged = false;
        this.paragraphCombo.setEnabled(this.tabs.getSelectedIndex() == 0);
        this.fontFamilyCombo.setEnabled(this.tabs.getSelectedIndex() == 0);
        this.updateState();
    }

    public void insertHTML(String string, int n) {
        this.insertHTML(this.wysEditor, string, n);
    }

    public void setText(String string) {
        String string2 = this.removeInvalidTags(string);
        if (this.tabs.getSelectedIndex() == 0) {
            this.wysEditor.setText("");
            this.insertHTML(this.wysEditor, string2, 0);
            CompoundUndoManager.discardAllEdits(this.wysEditor.getDocument());
        } else {
            String string3 = this.deIndent(this.removeInvalidTags(string2));
            string3 = Entities.HTML40.unescapeUnknownEntities(string3);
            this.srcEditor.setText(string3);
            CompoundUndoManager.discardAllEdits(this.srcEditor.getDocument());
        }
        this.setCaretPosition(0);
    }

    public String getText() {
        String string;
        if (this.tabs.getSelectedIndex() == 0) {
            string = this.removeInvalidTags(this.wysEditor.getText());
        } else {
            string = this.removeInvalidTags(this.srcEditor.getText());
            string = this.deIndent(this.removeInvalidTags(string));
            string = Entities.HTML40.unescapeUnknownEntities(string);
        }
        if (string != null && string.length() > 1) {
            string = this.unescape(string);
        }
        return string;
    }

    public String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length() - 1; ++i) {
            char c = string.charAt(i);
            char c2 = string.charAt(i + 1);
            if (c == '&' && c2 == '#') {
                int n = string.indexOf(59, i + 1);
                String string2 = string.substring(i + 1, n);
                int n2 = Integer.parseInt(string2.substring(1));
                stringBuffer.append((char)n2);
                i = n;
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append(string.charAt(string.length() - 1));
        return stringBuffer.toString();
    }

    private String deIndent(String string) {
        String string2 = "\n    ";
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.indexOf(string2) != -1) {
            int n = stringBuffer.indexOf(string2);
            int n2 = n + string2.length();
            stringBuffer.delete(n, n2);
            stringBuffer.insert(n, "\n");
        }
        return stringBuffer.toString();
    }

    private String removeInvalidTags(String string) {
        for (int i = 0; i < INVALID_TAGS.length; ++i) {
            string = this.deleteOccurance(string, '<' + INVALID_TAGS[i] + '>');
            string = this.deleteOccurance(string, "</" + INVALID_TAGS[i] + '>');
        }
        return string.trim();
    }

    private String deleteOccurance(String string, String string2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        while ((n = stringBuffer.toString().toLowerCase().indexOf(string2.toLowerCase())) != -1) {
            stringBuffer.delete(n, n + string2.length());
        }
        return stringBuffer.toString();
    }

    private void updateState() {
        if (this.focusedEditor == this.wysEditor) {
            this.fontFamilyCombo.removeActionListener(this.fontChangeHandler);
            String string = HTMLUtils.getFontFamily(this.wysEditor);
            if (string == null) {
                this.fontFamilyCombo.setSelectedIndex(0);
            } else {
                this.fontFamilyCombo.setSelectedItem(string);
            }
            this.fontFamilyCombo.addActionListener(this.fontChangeHandler);
        }
        this.actionList.putContextValueForAll((Object)"editor", (Object)this.focusedEditor);
        this.actionList.updateEnabledForAll();
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public JToolBar getFormatToolbar() {
        return this.formatToolBar;
    }

    public JEditorPane getSourceEditor() {
        return this.srcEditor;
    }

    public JEditorPane getEditor() {
        return this.wysEditor;
    }

    public JEditorPane getFocusedEditor() {
        return this.focusedEditor;
    }

    private class FontChangeHandler
    implements ActionListener {
        private FontChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HTMLEditorPane.this.fontFamilyCombo && HTMLEditorPane.this.focusedEditor == HTMLEditorPane.this.wysEditor) {
                HTMLDocument hTMLDocument = (HTMLDocument)HTMLEditorPane.this.focusedEditor.getDocument();
                CompoundUndoManager.beginCompoundEdit(hTMLDocument);
                if (HTMLEditorPane.this.fontFamilyCombo.getSelectedIndex() != 0) {
                    HTMLUtils.setFontFamily(HTMLEditorPane.this.wysEditor, HTMLEditorPane.this.fontFamilyCombo.getSelectedItem().toString());
                } else {
                    HTMLUtils.setFontFamily(HTMLEditorPane.this.wysEditor, null);
                }
                CompoundUndoManager.endCompoundEdit(hTMLDocument);
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }
    }

    private class ParagraphComboRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private ParagraphComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Action) {
                object = ((Action)object).getValue("Name");
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private class ParagraphComboHandler
    implements ActionListener {
        private ParagraphComboHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == HTMLEditorPane.this.paragraphCombo) {
                Action action = (Action)HTMLEditorPane.this.paragraphCombo.getSelectedItem();
                action.actionPerformed(actionEvent);
            }
        }
    }

    private class ChangeTabAction
    extends DefaultAction {
        private static final long serialVersionUID = 1L;
        int tab;

        public ChangeTabAction(int n) {
            super(n == 0 ? HtmleditorStringBank.richText.getI18n() : HtmleditorStringBank.source.getI18n());
            this.tab = n;
            this.putValue("BUTTON_TYPE", "radio");
        }

        protected void execute(ActionEvent actionEvent) {
            HTMLEditorPane.this.tabs.setSelectedIndex(this.tab);
            this.setSelected(true);
        }

        protected void contextChanged() {
            this.setSelected(HTMLEditorPane.this.tabs.getSelectedIndex() == this.tab);
        }
    }

    private class TextChangedHandler
    implements DocumentListener {
        private TextChangedHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        private void textChanged() {
            if (HTMLEditorPane.this.tabs.getSelectedIndex() == 0) {
                HTMLEditorPane.this.isWysTextChanged = true;
            }
            try {
                HTMLEditorPane.this.firePropertyChange(HTMLEditorPane.DOCUMENT_CHANGE_EVENT, null, HTMLEditorPane.this.getText());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getComponent() instanceof JEditorPane) {
                JEditorPane jEditorPane = (JEditorPane)focusEvent.getComponent();
                CompoundUndoManager.updateUndo(jEditorPane.getDocument());
                HTMLEditorPane.this.focusedEditor = jEditorPane;
                HTMLEditorPane.this.updateState();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getComponent() instanceof JEditorPane) {
                // empty if block
            }
        }
    }

    private class PopupHandler
    extends MouseAdapter {
        private PopupHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkForPopupTrigger(mouseEvent);
        }

        private void checkForPopupTrigger(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = null;
                if (mouseEvent.getSource() == HTMLEditorPane.this.wysEditor) {
                    jPopupMenu = HTMLEditorPane.this.wysPopupMenu;
                } else if (mouseEvent.getSource() == HTMLEditorPane.this.srcEditor) {
                    jPopupMenu = HTMLEditorPane.this.srcPopupMenu;
                } else {
                    return;
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            HTMLEditorPane.this.updateState();
            if (HTMLEditorPane.this.wysEditor.getSelectedText() != null && !HTMLEditorPane.this.wysEditor.getSelectedText().isEmpty()) {
                HTMLEditorPane.this.selectionStart = HTMLEditorPane.this.wysEditor.getSelectionStart();
                HTMLEditorPane.this.selectionEnd = HTMLEditorPane.this.wysEditor.getSelectionEnd();
            }
        }
    }
}

