/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dock;

import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.FeatureDocument;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.dock.FeatureContext;
import commvault.cte.component.dock.FeatureLoader;
import commvault.cte.component.dock.LoaderContext;
import commvault.cte.util.Application;
import javax.swing.JLabel;

public class DummyFeatureDocument
extends FeatureDocument
implements LoaderContext {
    private LoaderContext.FrameInfo frameInfo;
    private FeatureLoader loader;
    private boolean loaded = true;
    Feature f = null;

    public DummyFeatureDocument(LoaderContext.FrameInfo frameInfo, FeatureLoader featureLoader) {
        super(frameInfo.getKey());
        this.frameInfo = frameInfo;
        this.loader = featureLoader;
        if (frameInfo.getContext().getIconName() != null) {
            this.setIcon(Application.instance().getIconSource().getIcon(frameInfo.getContext().getIconName()));
        }
        if (frameInfo.getContext().getTitle() != null) {
            this.setTitle(frameInfo.getContext().getTitle());
        }
    }

    public void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    @Override
    public void documentComponentActivated() {
        super.documentComponentActivated();
        if (!this.loaded) {
            this.loadFeature();
        }
        if (this.frameInfo.getContext().getType() == Feature.FeatureType.COMMCELL_SUMMARY) {
            CVFrame.getInstance().getWorkspace().setLastActiveSummaryWindow(this.frameInfo.getKey());
        }
    }

    public void loadFeature() {
        try {
            this.loader.loadFeature(this);
            this.loaded = true;
        }
        catch (Exception exception) {
            CVFrame.instance().getWorkspace().closeSingleDocument(this.frameInfo.getKey());
            exception.printStackTrace();
        }
    }

    @Override
    public LoaderContext.FrameInfo getFrameInfo() {
        return this.frameInfo;
    }

    @Override
    public void setFeature(Feature feature) {
        super.setFeature(feature);
        this.loaded = true;
    }

    @Override
    public boolean isFeatureLoaded() {
        return this.loaded;
    }

    @Override
    public Feature loadFeature(Feature feature) {
        if (!this.isFeatureLoaded()) {
            this.setFeature(feature);
            return feature;
        }
        return null;
    }

    @Override
    public void unloadFeature() {
        FeatureContext featureContext = this.getFeature().getFeatureContext();
        this.frameInfo.setContext(featureContext);
        this.setComponent(new JLabel(CteStringBank.LOADING_DOTS.getI18n(), 0));
        this.getFeature().featureClosed();
        this.loaded = false;
    }

    @Override
    public void setLoading(String string) {
        if (this.getComponent() instanceof JLabel) {
            ((JLabel)this.getComponent()).setText(string);
        }
    }
}

