/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dock;

import com.jidesoft.pane.CollapsiblePanes;
import commvault.cte.CteStringBank;
import commvault.cte.binder.builder.UIFactory;
import commvault.cte.component.VerticalFlowLayout;
import commvault.cte.component.dock.AbstractFeature;
import commvault.cte.component.dock.CVCollapsiblePane;
import commvault.cte.component.dock.CVDockableFrameManager;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.dock.FeatureFrame;
import commvault.cte.util.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class CNTasks
extends AbstractFeature {
    private static CNTasks instance;
    private CollapsiblePanes pane = null;
    private static HashMap<Integer, CNTasks> cnTasksMap;

    public static synchronized CNTasks instance() {
        if (instance == null) {
            instance = new CNTasks();
        }
        return instance;
    }

    private CNTasks() {
        super(Feature.FeatureType.TASK, CteStringBank.Tasks.getI18n(), Application.instance().getIconSource().getIcon("commNetBrowserIcon12"));
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.pane = new CollapsiblePanes();
        JScrollPane jScrollPane = new JScrollPane((Component)this.pane);
        this.add(jScrollPane);
        jScrollPane.setPreferredSize(new Dimension(200, 400));
    }

    public void setContextMenu(final Feature feature) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CNTasks.this.setContextMenu1(feature);
            }
        });
    }

    private void setContextMenu1(Feature feature) {
        FeatureFrame featureFrame;
        if (this == feature || Feature.FeatureType.COMMCELL_BROWSER == feature.getFeatureContext().getType()) {
            return;
        }
        String string = (String)feature.getValue("Title");
        if (string == null) {
            string = (String)feature.getValue("Name");
        }
        if ((featureFrame = (FeatureFrame)((Object)SwingUtilities.getAncestorOfClass(FeatureFrame.class, this))) == null) {
            return;
        }
        featureFrame.setTitle(string);
        featureFrame.setFrameIcon((Icon)feature.getValue("Icon"));
        featureFrame.setTitleLabelComponent(new JLabel(string, featureFrame.getFrameIcon(), 2));
        CVDockableFrameManager.getInstance().refreshFrame(featureFrame);
        Map<String, Action[]> map = feature.getActionGroups();
        this.pane.removeAll();
        if (map == null || map.size() == 0) {
            return;
        }
        for (String string2 : map.keySet()) {
            Action[] actionArray = map.get(string2);
            if (actionArray == null || actionArray.length == 0) continue;
            JPanel jPanel = new JPanel(new VerticalFlowLayout());
            jPanel.setOpaque(false);
            CVCollapsiblePane cVCollapsiblePane = new CVCollapsiblePane("More");
            if (!string2.equals("More")) {
                cVCollapsiblePane.setTitle(!string2.equals("") ? string2 : "More");
                cVCollapsiblePane.setShowTitleBar(true);
            } else {
                cVCollapsiblePane.setShowTitleBar(false);
            }
            cVCollapsiblePane.setContentPane(jPanel);
            for (Action action : actionArray) {
                jPanel.add(UIFactory.createLinkButton(action));
            }
            this.pane.add((Component)((Object)cVCollapsiblePane));
        }
        this.pane.addExpansion();
    }

    @Override
    public Map<String, Action[]> getActionGroups() {
        return null;
    }

    @Override
    public void featureClosed() {
        super.featureClosed();
        instance = null;
    }

    static {
        cnTasksMap = new HashMap();
    }
}

