/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.dock;

import commvault.cte.common.IMutable;
import commvault.cte.common.IMutableListener;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.dock.FeatureContext;
import commvault.cte.component.dock.FeatureEvent;
import commvault.cte.component.dock.FeatureListener;
import commvault.cte.component.table.NTable;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public abstract class AbstractFeature
extends JPanel
implements Feature,
IMutableListener,
IMutable {
    private Feature.FeatureType type;
    private boolean dirty;
    protected Set<IMutableListener> mutableListeners = new HashSet<IMutableListener>();
    private JComponent titleBarLink = null;
    private HashMap<String, Object> properties = new HashMap();
    protected EventListenerList listenerList = new EventListenerList();
    private FeatureContext context;

    public AbstractFeature(Feature.FeatureType featureType, String string) {
        this(featureType, string, null, null);
    }

    public AbstractFeature(Feature.FeatureType featureType, String string, Icon icon) {
        this(featureType, string, icon, null);
    }

    public AbstractFeature(Feature.FeatureType featureType, String string, Icon icon, String string2) {
        this.type = featureType;
        this.putValue("Name", string);
        this.putValue("Icon", icon);
        this.putValue("Title", string2);
    }

    public void setTabTitle(String string) {
        this.putValue("Tab Title", string);
    }

    @Override
    public void addFeatureListener(FeatureListener featureListener) {
        this.listenerList.add(FeatureListener.class, featureListener);
    }

    @Override
    public void removeFeatureListenr(FeatureListener featureListener) {
        this.listenerList.remove(FeatureListener.class, featureListener);
    }

    @Override
    public Component createFeatureUI() {
        return this;
    }

    @Override
    public Object getValue(String string) {
        return this.properties.get(string);
    }

    @Override
    public void putValue(String string, Object object) {
        this.properties.put(string, object);
    }

    @Override
    public void refresh() {
        this.load();
        this.notifyEvent(new FeatureEvent(this, FeatureEvent.Type.REFRESH));
    }

    public void refreshReLogin() {
    }

    @Override
    public void load() {
    }

    @Override
    public void featureClosed() {
        this.findNTable((JComponent)this.createFeatureUI());
        FeatureEvent featureEvent = new FeatureEvent(this, FeatureEvent.Type.CLOSED);
        this.notifyEvent(featureEvent);
    }

    private void findNTable(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (component instanceof NTable) {
                ((NTable)component).saveTablePreference();
                continue;
            }
            if (!(component instanceof JComponent)) continue;
            this.findNTable((JComponent)component);
        }
    }

    protected void notifyEvent(FeatureEvent featureEvent) {
        FeatureListener[] featureListenerArray;
        for (FeatureListener featureListener : featureListenerArray = (FeatureListener[])this.listenerList.getListeners(FeatureListener.class)) {
            featureListener.applyFeatureChange(featureEvent);
        }
    }

    @Override
    public void featureActivated() {
        this.notifyEvent(new FeatureEvent(this, FeatureEvent.Type.ACTIVATED));
    }

    @Override
    public void featureAdded() {
        this.notifyEvent(new FeatureEvent(this, FeatureEvent.Type.OPENED));
    }

    @Override
    public boolean featureClosing() {
        return true;
    }

    @Override
    public JComponent createTitleBarUI() {
        return null;
    }

    @Override
    public FeatureContext getFeatureContext() {
        if (this.context == null) {
            this.context = new FeatureContext(this, this.type, null);
        }
        return this.context;
    }

    @Override
    public boolean supportsAutoRefresh() {
        return false;
    }

    @Override
    public void afterRefresh() {
        this.notifyEvent(new FeatureEvent(this, FeatureEvent.Type.AFTER_REFRESH));
    }

    @Override
    public void applyContext(FeatureContext featureContext) {
    }

    @Override
    public void mutated(IMutable iMutable) {
        this.setDirty(iMutable.isDirty());
    }

    @Override
    public void setDirty(boolean bl) {
        if (this.dirty == bl) {
            return;
        }
        this.dirty = bl;
        this.fireMutated();
    }

    private void fireMutated() {
        for (IMutableListener iMutableListener : this.mutableListeners) {
            iMutableListener.mutated(this);
        }
    }

    @Override
    public void addMutableListener(IMutableListener iMutableListener) {
        this.mutableListeners.add(iMutableListener);
    }

    @Override
    public void removeMutableListener(IMutableListener iMutableListener) {
        this.mutableListeners.remove(iMutableListener);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void save() {
    }

    public JComponent getTitleBarLink() {
        return this.titleBarLink;
    }

    public void setTitleBarLink(JComponent jComponent) {
        this.titleBarLink = jComponent;
    }
}

