/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.chart;

import commvault.cte.component.ByteDataSizeEnum;
import commvault.cte.component.chart.PieChartCounter;
import commvault.cte.util.ChartUnitConverter;
import commvault.cte.util.ReportUtilities;
import java.awt.Color;

public class PieChartSeriesData {
    private String seriesName = "";
    private int id = 0;
    private Color seriesColor = Color.BLACK;
    private PieChartCounter counter = null;
    private boolean isDataSizeChart = false;
    private ChartUnitConverter dataSizeUnit = ByteDataSizeEnum.GB;
    private boolean isAutomaticSizeConversion = false;
    private double total = 0.0;

    public PieChartSeriesData(int n, String string) {
        this.seriesName = string;
        this.id = n;
    }

    public void addValue(Double d) {
        this.total += d.doubleValue();
    }

    public void createCounter() {
        double d = this.getSeriesTotal();
        this.counter = this.isDataSizeChart ? new PieChartCounter(d, ReportUtilities.getCapacityFormatter((ByteDataSizeEnum)this.getDataSizeUnit())) : new PieChartCounter(d);
    }

    public ChartUnitConverter getDataSizeUnit() {
        return this.dataSizeUnit;
    }

    public void setDataSizeUnit(ChartUnitConverter chartUnitConverter) {
        this.dataSizeUnit = chartUnitConverter;
    }

    public void setAutomaticSizeConversion(boolean bl) {
        this.isAutomaticSizeConversion = bl;
    }

    public boolean isAutomaticSizeConversion() {
        return this.isAutomaticSizeConversion;
    }

    public double getSeriesTotal() {
        return this.total;
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public int getSeriesId() {
        return this.id;
    }

    public void setSeriesColor(Color color) {
        this.seriesColor = color;
    }

    public Color getSeriesColor() {
        return this.seriesColor;
    }

    public PieChartCounter getPieChartCounter() {
        return this.counter;
    }

    public boolean isDataSizeChart() {
        return this.isDataSizeChart;
    }

    public void setDataSizeChart(boolean bl) {
        this.isDataSizeChart = bl;
    }
}

