/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.chart;

import commvault.cte.component.chart.CVChart;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GraphPopupMenu
extends JPopupMenu
implements PopupMenuListener,
ActionListener {
    JMenuItem defaultItem = new JMenuItem();
    private LinkedHashMap userMenuItem = new LinkedHashMap();
    CVChart chart = null;
    private Point desiredOnScreenLocation = new Point();
    private boolean isEmpty = false;
    private boolean isInitialized = false;

    public GraphPopupMenu() {
        this.addPopupMenuListener(this);
    }

    public void clearup() {
        this.defaultItem = null;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void setDefaultItem(JMenuItem jMenuItem) {
        this.defaultItem = jMenuItem;
    }

    public void defaultAction() {
        if (this.defaultItem != null) {
            this.defaultItem.doClick();
        }
    }

    @Override
    public void setLocation(int n, int n2) {
        this.desiredOnScreenLocation.x = n;
        this.desiredOnScreenLocation.y = n2;
        this.makeMenuVisible(this.desiredOnScreenLocation);
        super.setLocation(this.desiredOnScreenLocation.x, this.desiredOnScreenLocation.y);
    }

    @Override
    public void show(Component component, int n, int n2) {
        if (!this.isEmpty) {
            super.show(component, n, n2);
        }
    }

    protected void makeMenuVisible(Point point) {
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = super.getPreferredSize().height;
        int n2 = super.getPreferredSize().width;
        if (point.y + n > dimension.height) {
            point.y -= n;
        }
        if (point.x + n2 > dimension.width) {
            point.x -= n2;
        }
    }

    public Point getDesiredLocationOnScreen() {
        return this.desiredOnScreenLocation;
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    public void addUserMenuItem(String string, ActionListener actionListener) {
        this.userMenuItem.put(string, actionListener);
    }

    public void setChart(CVChart cVChart) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.chart = cVChart;
        this.removeAll();
        JComponent jComponent = null;
        JMenuItem jMenuItem = new JMenuItem("Copy Chart");
        new JMenuItem("Copy Chart");
        if (jComponent != null) {
            jComponent.add(jMenuItem);
            this.addUserMenuItems(jComponent);
        } else {
            this.add(jMenuItem);
            this.addUserMenuItems(this);
        }
        jMenuItem.addActionListener(this);
        this.setDefaultItem(jMenuItem);
    }

    private void addUserMenuItems(JComponent jComponent) {
        Set set = this.userMenuItem.keySet();
        String string = null;
        JMenuItem jMenuItem = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener((ActionListener)this.userMenuItem.get(string));
            jComponent.add(jMenuItem);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.menuAction(actionEvent.getActionCommand());
    }

    protected void menuAction(String string) {
    }
}

