/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Legend;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.CategoryAxis;
import com.jidesoft.chart.axis.NumericAxis;
import com.jidesoft.chart.axis.SimpleNumericTickCalculator;
import com.jidesoft.chart.axis.TickCalculator;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.render.Axis3DRenderer;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.CylinderBarRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.StripePaint;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import commvault.cte.CteStringBank;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.MessagePanel;
import commvault.cte.component.Utilities;
import commvault.cte.component.chart.CVChart;
import commvault.cte.component.chart.CVDefaultChartModel;
import commvault.cte.component.chart.ChartPointEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public abstract class ChartMainPanel
extends JPanel
implements ActionListener,
Serializable {
    public static final int DEFAULT_NUM_BARPOINTS = 10;
    protected CVChart chart;
    protected Legend legend = null;
    private JPanel chartPanel = new JPanel(new BorderLayout());
    ChartMouseMotionAdapter motionAdapter;
    GridLineItemListener lineListener;
    MouseAdapter tableMouseAdapter;
    protected JComboBox chartTypeComboBox;
    protected JCheckBox showGridLineCheckBox;
    JLabel showGridLineLabel;
    protected JPanel optionPanel = null;
    protected boolean isFromDashboard = false;
    public static Color[] SERIES_COLORS = new Color[]{new Color(0, 140, 210), Color.YELLOW, new Color(204, 153, 255), Color.CYAN, Color.PINK, Color.GREEN.darker(), Color.magenta, Color.GRAY, new Color(255, 102, 0), new Color(192, 80, 77), Color.BLUE.darker()};
    public static Color[] SERIES_COLORS_LINE = new Color[]{new Color(0, 140, 210).darker(), Color.ORANGE.darker(), new Color(51, 153, 102).darker(), Color.magenta.darker(), new Color(255, 102, 0).darker(), Color.CYAN.darker(), Color.GREEN.darker(), new Color(192, 80, 77).darker(), Color.GRAY.darker(), Color.BLUE.darker()};
    public static Color[] SERIES_COLORS_LINE2 = new Color[]{new Color(0, 140, 210).darker(), Color.ORANGE.darker(), Color.magenta.darker(), Color.GREEN.darker(), new Color(192, 80, 77).darker(), new Color(51, 153, 102).darker(), new Color(255, 102, 0).darker(), Color.CYAN.darker(), Color.GRAY.darker(), Color.BLUE.darker()};
    protected ChartType chartType = ChartType.BAR;
    private String[][] rawChartLabels = null;
    private ChartOrientation orientation = ChartOrientation.Vertical;
    protected final int MAX_LEGEND_PER_ROW = 2;
    private boolean showChartTypes = true;
    private boolean showToolTip = false;
    private boolean isClickable = false;
    private int numberOfBarPoints = 10;
    private boolean includeAllBarPoints = false;
    private MessagePanel messagePanel = new MessagePanel(CteStringBank.Not_Applicable.getI18n(), UIManager.getIcon("OptionPane.informationIcon"));

    public ChartMainPanel(ChartType chartType) {
        this.chartType = chartType;
    }

    protected void init() {
        this.motionAdapter = new ChartMouseMotionAdapter();
        if (this.chart == null) {
            this.chart = new CVChart();
        }
        this.chart.setOpaque(false);
        String[] stringArray = new String[]{ChartType.BAR.toString(), ChartType.LINE.toString()};
        this.chartTypeComboBox = new JComboBox<String>(stringArray);
        this.chartTypeComboBox.setSelectedIndex(0);
        this.showGridLineCheckBox = new JCheckBox(CteStringBank.Show_Gridlines.getI18n());
        this.showGridLineCheckBox.setContentAreaFilled(false);
        this.showGridLineCheckBox.setOpaque(false);
        this.chartTypeComboBox.addActionListener(this);
        this.lineListener = new GridLineItemListener();
        this.showGridLineCheckBox.addItemListener(this.lineListener);
        this.chart.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChartPointEx chartPointEx;
                if (propertyChangeEvent.getPropertyName().equals("ChartFocusPoint") && (chartPointEx = (ChartPointEx)ChartMainPanel.this.chart.getCurrentChartPoint()) != null && ChartMainPanel.this.rawChartLabels != null) {
                    ChartMainPanel.this.chart.setToolTipText(ChartMainPanel.this.rawChartLabels[chartPointEx.getSeriesIndex()][chartPointEx.getPointIndex()]);
                }
            }
        });
        this.legend = new Legend((Chart)this.chart, 1);
        JPanel jPanel = new JPanel();
        jPanel.add((Component)this.legend);
        this.chartPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.chartPanel.setOpaque(false);
        this.chartPanel.add((Component)jPanel, "North");
        this.chartPanel.add((Component)((Object)this.chart), "Center");
    }

    public ChartPointEx getCurrentChartPointData() {
        return (ChartPointEx)this.chart.getCurrentChartPoint();
    }

    public void setShowToolTip(boolean bl) {
        this.showToolTip = bl;
    }

    public void setSupportedChartTypes(ChartType[] chartTypeArray) {
        if (chartTypeArray == null) {
            this.showChartOptions(false);
        } else {
            if (this.chartTypeComboBox == null) {
                this.chartTypeComboBox = new JComboBox();
            } else {
                this.chartTypeComboBox.removeAllItems();
            }
            for (int i = 0; i < chartTypeArray.length; ++i) {
                this.chartTypeComboBox.addItem(chartTypeArray[i].toString());
            }
        }
    }

    public boolean isShowChartTypes() {
        return this.showChartTypes;
    }

    protected boolean isBarChart() {
        return this.chartType.equals((Object)ChartType.BAR);
    }

    protected abstract void drawChart();

    protected void layoutComponents() {
        this.optionPanel = new JPanel(new GridBagLayout());
        this.optionPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(CteStringBank.Chart_Type.getI18n());
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        this.optionPanel.add((Component)jLabel, Utilities.getConstraints(gridBagConstraints, -1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0)));
        this.optionPanel.add((Component)this.chartTypeComboBox, Utilities.getConstraints(gridBagConstraints, -1, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 15, 0, 0)));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.messagePanel.setVisible(false);
        jPanel.add((Component)this.optionPanel, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 0.0, 1.0, 18, 0, new Insets(5, 10, 0, 10)));
        jPanel.add((Component)this.messagePanel, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 0.0, 1.0, 18, 0, new Insets(5, 10, 0, 10)));
        jPanel.add((Component)((Object)this.chart), Utilities.getConstraints(new GridBagConstraints(), -1, -1, 0, 0, 1.0, 1.0, 17, 0));
        this.add((Component)jPanel, Utilities.getConstraints(new GridBagConstraints(), -1, -1, 0, 0, 1.0, 1.0, 10, 0));
        this.revalidate();
    }

    public void clearChartPanel() {
        this.chartPanel.removeAll();
        this.chart.removeModels();
    }

    public JPanel getChartPanel() {
        return this.chartPanel;
    }

    public void setShowInfoMessage(boolean bl) {
        this.messagePanel.setVisible(bl);
        this.chart.setVisible(!bl);
    }

    public boolean isChartVisible() {
        return this.chart.isVisible();
    }

    public void showChartOptions(boolean bl) {
        this.showChartTypes = bl;
        if (this.optionPanel != null) {
            this.optionPanel.setVisible(bl);
        }
    }

    public void drawChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, String string, double d, ChartType chartType, ChartOrientation chartOrientation, int n) {
        this.drawChart(fArray, stringArray, stringArray2, stringArray3, colorArray, new Color[0], string, d, chartType, chartOrientation, n);
    }

    public void drawChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, Color[] colorArray2, String string, double d, ChartType chartType, ChartOrientation chartOrientation, int n) {
        if (this.legend != null) {
            this.legend.removeChart((Chart)this.chart);
        }
        this.chart.removeModels();
        this.chartType = chartType;
        this.rawChartLabels = stringArray2;
        if (chartType == ChartType.BAR || chartType == ChartType.STACK || chartType == ChartType.BAR_GROUPED) {
            if (chartOrientation == ChartOrientation.Vertical) {
                this.drawVerticalChart(fArray, stringArray, stringArray2, stringArray3, colorArray, string, d, n);
            } else {
                this.drawHorizontalChart(fArray, stringArray, stringArray2, stringArray3, colorArray, colorArray2, string, d, n);
            }
        }
        if (this.legend != null) {
            this.legend.addChart((Chart)this.chart);
        }
    }

    public void drawVerticalChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, String string, double d, int n) {
        ChartStyle chartStyle;
        CVDefaultChartModel cVDefaultChartModel;
        CategoryRange categoryRange = new CategoryRange();
        for (int i = 0; i < fArray.length; ++i) {
            cVDefaultChartModel = new CVDefaultChartModel(stringArray3[i]);
            ChartCategory chartCategory = new ChartCategory((Object)stringArray[i]);
            categoryRange.add((Category)chartCategory);
            chartStyle = new ChartStyle(colorArray[i], false, false, true);
            for (int j = 0; j < fArray[0].length; ++j) {
                ChartPoint chartPoint = new ChartPoint((Positionable)chartCategory, (double)fArray[i][j]);
                cVDefaultChartModel.addPoint((Chartable)chartPoint);
            }
            chartStyle.setBarsVisible(true);
            chartStyle.setBarColor(colorArray[i]);
            chartStyle.setBarOrientation(Orientation.vertical);
            this.chart.addModelToView((ChartModel)cVDefaultChartModel, chartStyle);
        }
        CategoryAxis categoryAxis = new CategoryAxis(categoryRange);
        this.chart.setXAxis((Axis)categoryAxis);
        cVDefaultChartModel = new NumericAxis((Range)new NumericRange(0.0, d), string);
        int n2 = n / 2;
        if (n2 < 1) {
            n2 = 1;
        }
        cVDefaultChartModel.setTickCalculator((TickCalculator)new SimpleNumericTickCalculator(0.0, (double)n, (double)n2));
        this.chart.setYAxis((Axis)cVDefaultChartModel);
        chartStyle = new CylinderBarRenderer();
        chartStyle.setLabelsVisible(false);
        chartStyle.setAlwaysShowOutlines(false);
        this.chart.setBarRenderer((BarRenderer)chartStyle);
        this.chart.setBarGap(5);
    }

    public void drawHorizontalChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, Color[] colorArray2, String string, double d, int n) {
        if (this.chartType == ChartType.BAR) {
            this.drawHorizontalBarChart(fArray, stringArray, stringArray2, stringArray3, colorArray, string, d, n);
        } else if (this.chartType == ChartType.STACK || this.chartType == ChartType.BAR_GROUPED) {
            this.drawHorizontalStackChart(fArray, stringArray, stringArray2, stringArray3, colorArray, colorArray2, string, d, n);
        }
        this.chart.setChartType(com.jidesoft.chart.ChartType.XY);
    }

    public void drawHorizontalBarChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, String string, double d, int n) {
        ChartCategory chartCategory;
        CVDefaultChartModel cVDefaultChartModel;
        CategoryRange categoryRange = new CategoryRange();
        for (int i = 0; i < fArray.length; ++i) {
            cVDefaultChartModel = new CVDefaultChartModel(stringArray3[i]);
            chartCategory = new ChartCategory((Object)stringArray[i]);
            categoryRange.add((Category)chartCategory);
            ChartStyle chartStyle = new ChartStyle(colorArray[i], false, false, true);
            for (int j = 0; j < fArray[0].length; ++j) {
                ChartPointEx chartPointEx = new ChartPointEx(fArray[i][j], (Positionable)chartCategory, i, j);
                cVDefaultChartModel.addPoint((Chartable)chartPointEx);
            }
            chartStyle.setBarsVisible(true);
            chartStyle.setBarColor(colorArray[i]);
            chartStyle.setBarOrientation(Orientation.horizontal);
            this.chart.addModelToView((ChartModel)cVDefaultChartModel, chartStyle);
        }
        Axis3DRenderer axis3DRenderer = new Axis3DRenderer();
        axis3DRenderer.setFrontHeight(Integer.valueOf(2));
        cVDefaultChartModel = new CategoryAxis(categoryRange);
        this.chart.setYAxis((Axis)cVDefaultChartModel);
        cVDefaultChartModel.setAxisRenderer((AxisRenderer)axis3DRenderer);
        chartCategory = new NumericAxis((Range)new NumericRange(0.0, d), string);
        int n2 = n / 2;
        if (n2 < 1) {
            n2 = 1;
        }
        chartCategory.setTickCalculator((TickCalculator)new SimpleNumericTickCalculator(0.0, (double)n, (double)n2));
        chartCategory.setAxisRenderer((AxisRenderer)axis3DRenderer);
        this.chart.setXAxis((Axis)chartCategory);
        CylinderBarRenderer cylinderBarRenderer = new CylinderBarRenderer();
        cylinderBarRenderer.setDepthRatio(0.4);
        this.chart.setBarRenderer((BarRenderer)cylinderBarRenderer);
        this.chart.setBarGap(2);
    }

    public void drawHorizontalStackChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, Highlight[] highlightArray, String string, double d, int n) {
        ChartCategory chartCategory;
        int n2;
        ChartStyle chartStyle;
        Object object;
        int n3;
        ArrayList<ChartStyle> arrayList = new ArrayList<ChartStyle>();
        CategoryRange categoryRange = new CategoryRange();
        ArrayList<ChartCategory> arrayList2 = new ArrayList<ChartCategory>();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            object = new ChartCategory(stringArray[n3], (Object)n3);
            categoryRange.add((Category)object);
            arrayList2.add((ChartCategory)object);
            chartStyle = new Highlight(stringArray[n3]);
            arrayList.add(chartStyle);
        }
        for (n3 = 0; n3 < fArray.length; ++n3) {
            object = new CVDefaultChartModel(stringArray3[n3]);
            chartStyle = new ChartStyle(colorArray[n3], false, false, true);
            for (n2 = 0; n2 < fArray[0].length; ++n2) {
                chartCategory = (ChartCategory)arrayList2.get(n2);
                ChartPointEx chartPointEx = new ChartPointEx(fArray[n3][n2], (Positionable)chartCategory, n3, n2);
                object.addPoint((Chartable)chartPointEx);
            }
            chartStyle.setBarsVisible(true);
            chartStyle.setBarColor(colorArray[n3]);
            chartStyle.setBarOrientation(Orientation.horizontal);
            this.chart.addModelToView((ChartModel)object, chartStyle);
        }
        Axis3DRenderer axis3DRenderer = new Axis3DRenderer();
        axis3DRenderer.setFrontHeight(Integer.valueOf(2));
        object = new CategoryAxis(categoryRange);
        this.chart.setYAxis((Axis)object);
        object.setAxisRenderer((AxisRenderer)axis3DRenderer);
        chartStyle = new NumericAxis((Range)new NumericRange(0.0, d), string);
        n2 = n / 2;
        if (n2 < 1) {
            n2 = 1;
        }
        chartStyle.setTickCalculator((TickCalculator)new SimpleNumericTickCalculator(0.0, (double)n));
        chartStyle.setAxisRenderer((AxisRenderer)axis3DRenderer);
        this.chart.setXAxis((Axis)chartStyle);
        chartCategory = new CylinderBarRenderer();
        chartCategory.setDepthRatio(0.4);
        this.chart.setBarRenderer((BarRenderer)chartCategory);
        this.chart.setBarGap(2);
        if (this.chartType == ChartType.BAR_GROUPED) {
            this.chart.setBarsGrouped(true);
            this.chart.setBarGap(1);
            this.chart.setBarGroupGap(3);
        }
    }

    public void drawHorizontalStackChart(float[][] fArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, Color[] colorArray2, String string, double d, int n) {
        ChartCategory chartCategory;
        int n2;
        ChartStyle chartStyle;
        Object object;
        int n3;
        CategoryRange categoryRange = new CategoryRange();
        ArrayList<ChartCategory> arrayList = new ArrayList<ChartCategory>();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            object = new ChartCategory(stringArray[n3], (Object)n3);
            categoryRange.add((Category)object);
            arrayList.add((ChartCategory)object);
        }
        for (n3 = 0; n3 < fArray.length; ++n3) {
            object = new CVDefaultChartModel(stringArray3[n3]);
            chartStyle = new ChartStyle(colorArray[n3], false, false, true);
            for (n2 = 0; n2 < fArray[0].length; ++n2) {
                chartCategory = (ChartCategory)arrayList.get(n2);
                ChartPointEx chartPointEx = new ChartPointEx(fArray[n3][n2], (Positionable)chartCategory, n3, n2);
                object.addPoint((Chartable)chartPointEx);
            }
            chartStyle.setBarsVisible(true);
            chartStyle.setBarColor(colorArray[n3]);
            chartStyle.setBarOrientation(Orientation.horizontal);
            if (colorArray2 != null && colorArray2.length > n3 && colorArray2[n3] != null) {
                StripePaint stripePaint = new StripePaint(45, 10, 1.0f);
                stripePaint.setBackground((Paint)colorArray[n3]);
                stripePaint.setForeground(Color.white);
                chartStyle.setBarPaint((Paint)stripePaint);
            }
            this.chart.addModelToView((ChartModel)object, chartStyle);
        }
        Axis3DRenderer axis3DRenderer = new Axis3DRenderer();
        axis3DRenderer.setFrontHeight(Integer.valueOf(2));
        object = new CategoryAxis(categoryRange);
        this.chart.setYAxis((Axis)object);
        object.setAxisRenderer((AxisRenderer)axis3DRenderer);
        chartStyle = new NumericAxis((Range)new NumericRange(0.0, d), string);
        n2 = n / 2;
        if (n2 < 1) {
            n2 = 1;
        }
        chartStyle.setTickCalculator((TickCalculator)new SimpleNumericTickCalculator(0.0, (double)n));
        chartStyle.setAxisRenderer((AxisRenderer)axis3DRenderer);
        this.chart.setXAxis((Axis)chartStyle);
        chartCategory = new CylinderBarRenderer();
        chartCategory.setDepthRatio(0.4);
        this.chart.setBarRenderer((BarRenderer)chartCategory);
        this.chart.setBarGap(2);
        if (this.chartType == ChartType.BAR_GROUPED) {
            this.chart.setBarsGrouped(true);
            this.chart.setBarGap(1);
            this.chart.setBarGroupGap(3);
        }
    }

    public Legend createLegend(int n) {
        Legend legend = new Legend((Chart)this.chart, n);
        legend.setBorder(BorderFactory.createEmptyBorder());
        return legend;
    }

    public void createLegend(int n, LegendPosition legendPosition) {
        this.chartPanel.removeAll();
        this.chartPanel.setOpaque(false);
        Legend legend = new Legend((Chart)this.chart, n);
        legend.setOpaque(false);
        legend.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        if (legendPosition == LegendPosition.RIGHT || legendPosition == LegendPosition.LEFT) {
            jPanel.setLayout(new GridBagLayout());
            LayoutUtils.addRow((Container)jPanel, (JComponent)legend, true);
        } else {
            jPanel.add((Component)legend);
        }
        switch (legendPosition) {
            case TOP: {
                this.chartPanel.add((Component)jPanel, "North");
                break;
            }
            case RIGHT: {
                this.chartPanel.add((Component)jPanel, "East");
                break;
            }
            case BOTTOM: {
                this.chartPanel.add((Component)jPanel, "South");
                break;
            }
            case LEFT: {
                this.chartPanel.add((Component)jPanel, "West");
            }
        }
        this.chartPanel.add((Component)((Object)this.chart), "Center");
        this.setOpaque(false);
    }

    public void setXAxisPointLabelVisible(boolean bl) {
        if (!bl) {
            this.chart.getXAxis().setTicksVisible(false);
        }
    }

    public void setYAxisPointLabelVisible(boolean bl) {
        if (!bl) {
            this.chart.getYAxis().setTicksVisible(false);
        }
    }

    public void updateChartDataView(int n, long[][] lArray, String[] stringArray, String[][] stringArray2, String[] stringArray3, Color[] colorArray, ChartType chartType) {
    }

    public boolean showGridLine() {
        return this.showGridLineCheckBox != null && this.showGridLineCheckBox.isSelected();
    }

    public void setShowGridLine(boolean bl) {
        this.showGridLineCheckBox.setSelected(bl);
        this.chart.setHorizontalGridLinesVisible(bl);
        this.chart.setVerticalGridLinesVisible(bl);
    }

    public void removeChartMouseMotionAdapter() {
        this.chart.removeMouseListener(this.motionAdapter);
        this.chart.removeMouseMotionListener(this.motionAdapter);
        this.chart.setCursor(new Cursor(0));
    }

    public void addChartMouseMotionAdapter() {
        this.addChartMouseMotionAdapter(true);
    }

    public void addChartMouseMotionAdapter(boolean bl) {
        this.chart.addMouseListener(this.motionAdapter);
        this.chart.addMouseMotionListener(this.motionAdapter);
        this.isClickable = bl;
    }

    public CVChart getChart() {
        return this.chart;
    }

    public void initChartLegend() {
        this.createLegend(2, LegendPosition.TOP);
    }

    public void initChartLegend(int n, int n2) {
    }

    public void initChartLegend(int n, int n2, int n3) {
    }

    public void setChartInverted(boolean bl) {
    }

    public void setNumberOfBarPoints(int n) {
        this.numberOfBarPoints = n;
    }

    public int getNumberOfBarPoints() {
        return this.numberOfBarPoints;
    }

    public void setIncludeAllBarPoints(boolean bl) {
        this.includeAllBarPoints = bl;
    }

    public boolean isIncludeAllBarPoints() {
        return this.includeAllBarPoints;
    }

    public void setChartSize(int n, int n2) {
        this.chart.doLayout();
    }

    public void setChartLayoutHints(int n) {
        this.chart.doLayout();
    }

    public JComboBox getChartTypeComboBox() {
        return this.chartTypeComboBox;
    }

    public JCheckBox getshowGridLineCheckBox() {
        return this.showGridLineCheckBox;
    }

    public void setChartTitle(String string) {
        this.chart.setTitle(string);
    }

    public void setChartType(String string) {
        this.chartTypeComboBox.setSelectedItem(string);
    }

    public void setChartType(int n) {
        if (n < 0 || n >= this.chartTypeComboBox.getModel().getSize()) {
            return;
        }
        this.chartTypeComboBox.setSelectedIndex(n);
    }

    public void setToolTipLabels(String[][] stringArray) {
        this.rawChartLabels = stringArray;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public static String stripHTMLFromColumnName(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll("<html>", "");
        string = string.replaceAll("</html>", "");
        string = string.replaceAll("<center>", "");
        string = string.replaceAll("</center>", "");
        string = string.replaceAll("<b>", "");
        string = string.replaceAll("</b>", "");
        string = string.replaceAll("</p><p>", "\n");
        string = string.replaceAll("</p> <p>", "\n");
        string = string.replaceAll("<p>", "");
        string = string.replaceAll("</p>", "");
        return string;
    }

    public void dispose() {
        if (this.chart != null) {
            this.chart = null;
        }
        this.motionAdapter = null;
        if (this.chartTypeComboBox != null) {
            this.chartTypeComboBox.removeActionListener(this);
            this.chartTypeComboBox.removeAllItems();
            this.chartTypeComboBox = null;
        }
        if (this.showGridLineCheckBox != null) {
            this.showGridLineCheckBox.removeItemListener(this.lineListener);
            this.showGridLineCheckBox = null;
            this.lineListener = null;
        }
        SERIES_COLORS = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() != this.chartTypeComboBox || this.getChartType() != null) {
            // empty if block
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    class ChartMouseMotionAdapter
    extends MouseAdapter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Cursor saveCursor = null;
        Cursor handCursor = new Cursor(12);

        ChartMouseMotionAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (ChartMainPanel.this.isClickable && ChartMainPanel.this.chart.getCursor().getType() != 12) {
                this.saveCursor = ChartMainPanel.this.chart.getCursor();
                ChartMainPanel.this.chart.setCursor(this.handCursor);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.saveCursor != null) {
                ChartMainPanel.this.chart.setCursor(this.saveCursor);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ChartMainPanel.this.isClickable && ChartMainPanel.this.chart.getCursor().getType() != 12) {
                this.saveCursor = ChartMainPanel.this.chart.getCursor();
                ChartMainPanel.this.chart.setCursor(this.handCursor);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class GridLineItemListener
    implements ItemListener,
    Serializable {
        GridLineItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == ChartMainPanel.this.showGridLineCheckBox) {
                // empty if block
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        }
    }

    public static enum ChartOrientation {
        Horizontal(1),
        Vertical(2);

        private int value;

        private ChartOrientation(int n2) {
            this.value = n2;
        }

        public int getEnumValue() {
            return this.value;
        }
    }

    public static enum LegendPosition {
        TOP(0),
        RIGHT(1),
        BOTTOM(2),
        LEFT(3);

        private int enumVal = 0;

        private LegendPosition(int n2) {
            this.enumVal = n2;
        }

        public int getEnumVal() {
            return this.enumVal;
        }
    }

    public static enum ChartDataType {
        COUNT(0),
        DATA_SIZE(1),
        PERCENT(2),
        NETWORK_USAGE(3),
        COST(4),
        DURATION(5),
        SECONDS_DURATION(6),
        MICRO_SECONDS_DURATION(7);

        private int enumVal = 0;
        private String enumName = "";

        private ChartDataType(int n2) {
            this.enumVal = n2;
        }

        public int getEnumVal() {
            return this.enumVal;
        }
    }

    public static enum ChartAxis {
        XAxis(CteStringBank.XAxis.getI18n()),
        YAxis(CteStringBank.YAxis.getI18n());

        private String axisName = "";

        private ChartAxis(String string2) {
            this.axisName = string2;
        }

        public String getAxisName() {
            return this.axisName;
        }
    }

    public static enum ChartType {
        UNKNOWN(0, CteStringBank.Unknown.getI18n()),
        BAR(1, CteStringBank.Bar.getI18n()),
        PIE(2, CteStringBank.Pie.getI18n()),
        STACK(4, CteStringBank.Stack.getI18n()),
        LINE(8, CteStringBank.Line.getI18n()),
        GAUGE(16, CteStringBank.Gauge.getI18n()),
        BAR_GROUPED(16, CteStringBank.Bar.getI18n());

        private int enumVal = 0;
        private String enumName = "";

        private ChartType(int n2, String string2) {
            this.enumVal = n2;
            this.enumName = string2;
        }

        public int getEnumVal() {
            return this.enumVal;
        }

        public String getEnumName() {
            return this.enumName;
        }
    }
}

