/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.CteStringBank;
import commvault.cte.util.DateUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXDatePickerFormatter;
import org.jdesktop.swingx.calendar.JXMonthView;
import org.jdesktop.swingx.plaf.DatePickerUI;
import org.jdesktop.swingx.plaf.basic.BasicDatePickerUI;

public class JDateChooser
extends JXDatePicker {
    static Calendar CALENDAR = Calendar.getInstance();
    static int _WIDTH = 40;
    JButton btnPopup;

    public JDateChooser(Date date) {
        this(date, true);
    }

    public JDateChooser(Date date, final boolean bl) {
        this.setUI((DatePickerUI)new BasicDatePickerUI(){

            protected JButton createPopupButton() {
                JDateChooser.this.btnPopup = super.createPopupButton();
                if (!bl) {
                    JDateChooser.this.btnPopup.setText(CteStringBank.Date.getI18n());
                    JDateChooser.this.btnPopup.setIcon(null);
                }
                JDateChooser.this.btnPopup.setModel(new DefaultButtonModel(){

                    @Override
                    public void setEnabled(boolean bl) {
                        if (this.isEnabled() == bl) {
                            return;
                        }
                        if (bl) {
                            this.stateMask |= 8;
                        } else {
                            this.stateMask &= 0xFFFFFFF7;
                            this.stateMask &= 0xFFFFFFFE;
                            this.stateMask &= 0xFFFFFFFB;
                        }
                    }
                });
                return JDateChooser.this.btnPopup;
            }
        });
        this.setMonthView(new MonthView());
        DateFormat[] dateFormatArray = DateUtilities.useUserDateFormat ? new DateFormat[]{new SimpleDateFormat(DateUtilities.instance().getUserSpecificLongDateFormat())} : new JXDatePickerFormatter().getFormats();
        this.setFormats(dateFormatArray);
        this.setEditor(new JFormattedTextField((JFormattedTextField.AbstractFormatter)new JXDatePickerFormatter(dateFormatArray)));
        String string = CteStringBank.Today_is.getI18n();
        string = string + " {0,date}";
        this.setLinkDate(date.getTime(), string);
        this.setDate(date);
    }

    public void setPreferredPopupButtonWidth(int n) {
        this.btnPopup.setPreferredSize(new Dimension(n, (int)this.btnPopup.getPreferredSize().getHeight()));
    }

    public JDateChooser() {
        this(new Date());
    }

    public void addActionListener(ActionListener actionListener) {
        super.addActionListener(actionListener);
    }

    public Date getDate() {
        return super.getDate();
    }

    public void setDate(Date date) {
        Date date2 = this.getDate();
        super.setDate(date);
        super.firePropertyChange("date", (Object)date2, (Object)date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long incrementYear(long l, int n) {
        Calendar calendar;
        Calendar calendar2 = calendar = CALENDAR;
        synchronized (calendar2) {
            calendar.setTimeInMillis(l);
            calendar.add(1, n);
            return calendar.getTimeInMillis();
        }
    }

    public void setNewTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return;
        }
        JXMonthView jXMonthView = super.getMonthView();
        long l = jXMonthView.getFirstDisplayedDate();
        jXMonthView.setTimeZone(timeZone);
        this.setTimeZone(timeZone);
        jXMonthView.setFirstDisplayedDate(l);
    }

    class MonthView
    extends JXMonthView {
        ImageIcon _monthUpImage = null;
        ImageIcon _monthDownImage = null;

        public MonthView() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, _WIDTH));
            this.setTraversable(true);
            String string = UIManager.getString("JXMonthView.monthDownFileName");
            if (string == null) {
                string = "resources/month-down.png";
            }
            this._monthDownImage = new ImageIcon(JXMonthView.class.getResource(string));
            string = UIManager.getString("JXMonthView.monthUpFileName");
            if (string == null) {
                string = "resources/month-up.png";
            }
            this._monthUpImage = new ImageIcon(JXMonthView.class.getResource(string));
        }

        protected void paintMonthStringBackground(Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintMonthStringBackground(graphics, n - _WIDTH / 2, n2, n3 + _WIDTH, n4);
            int n5 = this._monthUpImage.getIconWidth();
            int n6 = this._monthUpImage.getIconHeight();
            graphics.drawImage(this._monthDownImage.getImage(), n - n5 + 3, n2 + n4 / 2 - n6 / 2, null);
            graphics.drawImage(this._monthUpImage.getImage(), n + n3 - 3, n2 + n4 / 2 - n6 / 2, null);
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (mouseEvent.getID() == 501) {
                int n3 = this.getTraversableButtonAt(n + this._monthUpImage.getIconWidth() + 3, n2);
                if (n3 == 1) {
                    this.setFirstDisplayedDate(JDateChooser.incrementYear(this.getFirstDisplayedDate(), -1));
                    return;
                }
                n3 = this.getTraversableButtonAt(n - this._monthUpImage.getIconWidth() - 3, n2);
                if (n3 == 2) {
                    this.setFirstDisplayedDate(JDateChooser.incrementYear(this.getFirstDisplayedDate(), 1));
                    return;
                }
            }
            super.processMouseEvent(mouseEvent);
        }
    }
}

