/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component.calender;

import commvault.cte.component.NumericDocument;
import commvault.cte.component.NumericTextField;
import commvault.cte.component.calender.CalendarUtilities;
import commvault.cte.component.calender.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicArrowButton;

public class AbsoluteHourChooser
extends JPanel
implements KeyListener,
FocusListener,
ActionListener {
    protected NumericTextField hourField;
    protected NumericTextField minField;
    protected NumericTextField secondField;
    public final String AM = CalendarUtilities.getAMString();
    public final String PM = CalendarUtilities.getPMString();
    private JTextField ampmField;
    protected BasicArrowButton incrButton;
    protected BasicArrowButton decrButton;
    protected JComponent lastFocusedComp = null;

    public AbsoluteHourChooser(int n) {
        this.preInit();
        this.init();
        this.setComponentValues(n);
        this.lastFocusedComponent();
    }

    public void setComponentValues(int n) {
        if (n < 60) {
            this.hourField.setText("12");
            this.minField.setText("00");
            this.ampmField.setText(this.AM);
        } else {
            TimeUtil timeUtil = new TimeUtil(n);
            timeUtil.calculateTime();
            int n2 = timeUtil.getHrs();
            int n3 = timeUtil.getMin();
            if (n2 == 0) {
                this.hourField.setText(Integer.toString(12));
                this.minField.setText(n3 < 10 ? "0" + Integer.toString(n3) : Integer.toString(n3));
                this.ampmField.setText(this.AM);
            }
            if (n2 > 0 && n2 < 12) {
                this.hourField.setText(Integer.toString(n2));
                this.minField.setText(n3 < 10 ? "0" + Integer.toString(n3) : Integer.toString(n3));
                this.ampmField.setText(this.AM);
            } else if (n2 >= 12 && n2 < 24) {
                if ((n2 -= 12) == 0) {
                    n2 = 12;
                }
                this.hourField.setText(Integer.toString(n2));
                this.minField.setText(n3 < 10 ? "0" + Integer.toString(n3) : Integer.toString(n3));
                this.ampmField.setText(this.PM);
            }
        }
    }

    protected void preInit() {
        this.hourField = new NumericTextField("1", new NumericDocument(1L, 12L));
        this.minField = new NumericTextField("00", new NumericDocument(0L, 59L));
        this.secondField = new NumericTextField("00", new NumericDocument(0L, 59L));
        this.ampmField = new JTextField(3);
        this.incrButton = new BasicArrowButton(1);
        this.decrButton = new BasicArrowButton(5);
    }

    protected void init() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel.setBorder(this.hourField.getBorder());
        jPanel.setBackground(this.hourField.getBackground());
        this.hourField.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.minField.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.secondField.setBorder(new EmptyBorder(1, 0, 0, 0));
        this.ampmField.setBorder(new EmptyBorder(1, 6, 1, 0));
        this.hourField.addFocusListener(this);
        this.minField.addFocusListener(this);
        this.ampmField.addFocusListener(this);
        this.hourField.addKeyListener(this);
        this.minField.addKeyListener(this);
        this.ampmField.addKeyListener(this);
        this.ampmField.setEditable(false);
        JLabel jLabel = new JLabel(" :", 4);
        jLabel.setBackground(this.hourField.getBackground());
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel jLabel2 = new JLabel(" :", 4);
        jLabel2.setBackground(this.hourField.getBackground());
        jLabel2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add(this.hourField);
        jPanel.add(jLabel);
        jPanel.add(this.minField);
        jPanel.add(this.ampmField);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
        jPanel2.add(this.incrButton);
        jPanel2.add(this.decrButton);
        jPanel2.setPreferredSize(new Dimension(18, this.hourField.getPreferredSize().height));
        this.add((Component)jPanel, "Center");
        jPanel2.setBorder(new EmptyBorder(0, 2, 0, 0));
        this.add((Component)jPanel2, "East");
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        new Dimension(this.hourField.getPreferredSize().width + this.minField.getPreferredSize().width + this.secondField.getPreferredSize().width + this.ampmField.getPreferredSize().width + 44, this.hourField.getPreferredSize().height);
        this.incrButton.addActionListener(this);
        this.decrButton.addActionListener(this);
        this.hourField.setMaxChars(2);
        this.minField.setMaxChars(2);
        this.secondField.setMaxChars(2);
    }

    protected void lastFocusedComponent() {
        this.lastFocusedComp = this.ampmField;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.hourField || keyEvent.getSource() == this.minField || keyEvent.getSource() == this.secondField || keyEvent.getSource() == this.ampmField) {
            if (keyEvent.getKeyCode() == 38) {
                this.incrButton.doClick();
            } else if (keyEvent.getKeyCode() == 40) {
                this.decrButton.doClick();
            } else if (keyEvent.getKeyCode() == 65 && keyEvent.getSource() == this.ampmField) {
                this.ampmField.setText(this.AM);
                this.ampmField.setSelectionStart(0);
                this.ampmField.setSelectionEnd(2);
                this.ampmField.requestFocus();
            } else if (keyEvent.getKeyCode() == 80 && keyEvent.getSource() == this.ampmField) {
                this.ampmField.setText(this.PM);
                this.ampmField.setSelectionStart(0);
                this.ampmField.setSelectionEnd(2);
                this.ampmField.requestFocus();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() != this) {
            this.lastFocusedComp = (JComponent)focusEvent.getSource();
            if (this.lastFocusedComp instanceof JTextField) {
                ((JTextField)this.lastFocusedComp).selectAll();
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() != this) {
            this.lastFocusedComp = (JComponent)focusEvent.getSource();
        }
        if (focusEvent.getSource() == this.hourField) {
            int n = 0;
            try {
                n = Integer.parseInt(this.hourField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n == 0) {
                n = 12;
            }
            this.hourField.setText((n < 10 ? "0" : "") + Integer.toString(n));
        } else if (focusEvent.getSource() == this.minField) {
            int n = 0;
            try {
                n = Integer.parseInt(this.minField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.minField.setText((n < 10 ? "0" : "") + Integer.toString(n));
        } else if (focusEvent.getSource() == this.secondField) {
            int n = 0;
            try {
                n = Integer.parseInt(this.secondField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.secondField.setText((n < 10 ? "0" : "") + Integer.toString(n));
        } else if (focusEvent.getSource() == this.ampmField) {
            this.ampmField.setSelectionStart(0);
            this.ampmField.setSelectionEnd(0);
        }
    }

    protected void move(JComponent jComponent, int n) {
        if (jComponent == this.hourField) {
            int n2 = 1;
            String string = this.hourField.getText().trim();
            if (string.length() != 0) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 1) {
                ++n2;
            } else if (n == 3) {
                --n2;
            }
            if (n2 > 12) {
                n2 = 1;
            } else if (n2 < 1) {
                n2 = 12;
            }
            this.hourField.setText((n2 < 10 ? "0" : "") + Integer.toString(n2));
            this.hourField.requestFocus();
        } else if (jComponent == this.minField) {
            int n3 = 0;
            String string = this.minField.getText().trim();
            if (string.length() != 0) {
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 1) {
                ++n3;
            } else if (n == 3) {
                --n3;
            }
            if (n3 > 59) {
                n3 = 0;
            } else if (n3 < 0) {
                n3 = 59;
            }
            this.minField.setText((n3 < 10 ? "0" : "") + Integer.toString(n3));
            this.minField.requestFocus();
        } else if (jComponent == this.secondField) {
            int n4 = 0;
            String string = this.secondField.getText().trim();
            if (string.length() != 0) {
                try {
                    n4 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (n == 1) {
                ++n4;
            } else if (n == 3) {
                --n4;
            }
            if (n4 > 59) {
                n4 = 0;
            } else if (n4 < 0) {
                n4 = 59;
            }
            this.secondField.setText((n4 < 10 ? "0" : "") + Integer.toString(n4));
            this.secondField.requestFocus();
        } else if (jComponent == this.ampmField) {
            if (this.ampmField.getText().equals(this.AM)) {
                this.ampmField.setText(this.PM);
            } else {
                this.ampmField.setText(this.AM);
            }
            this.ampmField.setSelectionStart(0);
            this.ampmField.setSelectionEnd(2);
            this.ampmField.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.incrButton) {
            if (this.lastFocusedComp != null && (this.lastFocusedComp instanceof NumericTextField || this.lastFocusedComp instanceof JTextField)) {
                this.move(this.lastFocusedComp, 1);
            }
        } else if (actionEvent.getSource() == this.decrButton && this.lastFocusedComp != null && (this.lastFocusedComp instanceof NumericTextField || this.lastFocusedComp instanceof JTextField)) {
            this.move(this.lastFocusedComp, 3);
        }
    }

    public int getTimeInSeconds() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(this.hourField.getText());
            n2 = Integer.parseInt(this.minField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.ampmField.getText().equalsIgnoreCase(this.AM)) {
            if (n == 12) {
                n = 0;
            }
            n3 = n * 3600 + n2 * 60;
        } else {
            if (n < 12) {
                n += 12;
            }
            n3 = n * 3600 + n2 * 60;
        }
        return n3;
    }
}

