/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.SList;
import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;

public class ToolTipListBox
extends SList {
    private int defaultLength = 10;

    public ToolTipListBox() {
        this.setToolTipRenderer();
    }

    public ToolTipListBox(ListModel listModel) {
        super(listModel);
        this.setToolTipRenderer();
    }

    public ToolTipListBox(Object[] objectArray) {
        super(objectArray);
        this.setToolTipRenderer();
    }

    public ToolTipListBox(Vector vector) {
        super(vector);
        this.setToolTipRenderer();
    }

    private void setToolTipRenderer() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.setDismissDelay(10000);
        this.setCellRenderer(new ToolTipListRenderer());
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public void setDefaultLength(int n) {
        this.defaultLength = n;
    }

    private class ToolTipListRenderer
    extends DefaultListCellRenderer {
        private ToolTipListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (component != null && component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (object != null && object.toString().length() > ToolTipListBox.this.defaultLength) {
                    jComponent.setToolTipText(object.toString());
                }
            }
            return component;
        }
    }
}

