/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicArrowButton;

public class StickyButton
extends BasicArrowButton
implements MouseListener,
ActionListener {
    private Timer timer = null;
    private boolean buttonPressed = false;
    private boolean timerDisable;

    public StickyButton(int n) {
        super(n);
        super.removeMouseListener(this);
        super.addMouseListener(this);
        this.enableEvents(1005L);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (StickyButton.this.buttonPressed) {
                    StickyButton.this.stopTimer();
                }
            }
        });
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.stopTimer();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.height * 2 / 3, dimension.width);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!super.isEnabled()) {
            return;
        }
        super.fireActionPerformed(new ActionEvent(this, -1, this.getActionCommand()));
        this.stopTimer();
        this.buttonPressed = true;
        if (!this.timerDisable) {
            this.timer = new Timer(600, this);
            this.timer.setInitialDelay(600);
            this.timer.setDelay(100);
            this.timer.start();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.stopTimer();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.stopTimer();
        this.getModel().setPressed(this.buttonPressed);
    }

    @Override
    protected void fireActionPerformed(ActionEvent actionEvent) {
    }

    protected synchronized void stopTimer() {
        this.buttonPressed = false;
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = null;
    }

    protected synchronized void tick() {
        if (this.buttonPressed) {
            super.fireActionPerformed(new ActionEvent(this, -1, this.getActionCommand()));
        } else {
            this.stopTimer();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.timer) {
            this.tick();
        }
    }

    @Override
    public void doClick() {
        super.doClick();
        super.fireActionPerformed(new ActionEvent(this, -1, this.getActionCommand()));
    }

    public void disbleTimer() {
        this.timerDisable = true;
    }
}

