/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class SimplePrintableJTextArea
extends JTextArea
implements Printable {
    private String jobName = CteStringBank.Print_Job_for_.getI18n() + System.getProperty(CteStringBank.user6name.getI18n());
    int left_margin = this.inchesToPage(0.5);
    int right_margin = this.inchesToPage(0.5);
    int top_margin = this.inchesToPage(0.5);
    int bottom_margin = this.inchesToPage(0.5);

    public SimplePrintableJTextArea() {
    }

    public SimplePrintableJTextArea(String string) {
        super(string);
    }

    int inchesToPage(double d) {
        return (int)(d * 72.0);
    }

    public void submitPrintJob() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        printerJob.setJobName(this.jobName);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(OrientationRequested.PORTRAIT);
        hashPrintRequestAttributeSet.add(Chromaticity.COLOR);
        hashPrintRequestAttributeSet.add(Chromaticity.MONOCHROME);
        hashPrintRequestAttributeSet.add(PrintQuality.NORMAL);
        hashPrintRequestAttributeSet.add(PrintQuality.DRAFT);
        hashPrintRequestAttributeSet.add(PrintQuality.HIGH);
        hashPrintRequestAttributeSet.add(new MediaPrintableArea(0.25f, 0.25f, 8.0f, 10.5f, 25400));
        if (printerJob.printDialog()) {
            try {
                printerJob.print(hashPrintRequestAttributeSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.getFont().deriveFont(9.0f));
        int n2 = (int)pageFormat.getImageableHeight();
        pageFormat.getImageableWidth();
        int n3 = graphics2D.getFontMetrics().getHeight() - graphics2D.getFontMetrics().getLeading() / 2;
        int n4 = (n2 - this.top_margin - this.bottom_margin) / n3;
        int n5 = n4 * n;
        if (n5 > this.getLineCount()) {
            return 1;
        }
        int n6 = n5 + n4;
        int n7 = this.top_margin;
        this.getLineCount();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        for (int i = n5; i < n6; ++i) {
            try {
                String string = this.getText(this.getLineStartOffset(i), this.getLineEndOffset(i) - this.getLineStartOffset(i));
                graphics2D.drawString(string, this.left_margin, n7);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if ((n7 += n3) > n2 - this.bottom_margin) break;
        }
        return 0;
    }
}

