/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.NumericDocument;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.text.Document;

public final class NumericTextField
extends JTextField
implements FocusListener {
    NumericDocument nDoc;
    int behavior = 0;
    boolean bAllowEmptyField = false;
    boolean addZeroBeforeSingleDigitNumber = false;
    Vector focusLostListeners = new Vector();

    public NumericTextField(String string, NumericDocument numericDocument) {
        super(numericDocument, null, 2);
        this.nDoc = numericDocument;
        this.setText(string);
        this.setHorizontalAlignment(4);
        super.removeFocusListener(this);
        super.addFocusListener(this);
    }

    public NumericTextField() {
        this("", new NumericDocument(1L, Integer.MAX_VALUE));
    }

    public void setNonNumericText(String string) {
        super.setText(string);
    }

    @Override
    public void setText(String string) {
        try {
            int n = Integer.parseInt(string);
            if ((long)n < this.getMinValue() || (long)n > this.getMaxValue()) {
                return;
            }
            if (string.length() == 1 && this.addZeroBeforeSingleDigitNumber) {
                super.setText("0" + string);
            } else {
                super.setText(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Document createDefaultModel() {
        return this.nDoc;
    }

    public long getMaxValue() {
        return this.nDoc.getMaxValue();
    }

    public long getMinValue() {
        return this.nDoc.getMinValue();
    }

    public void setBehavior(int n) {
        this.behavior = n;
    }

    public void setMaxValue(int n) {
        this.nDoc.setMaxValue(n);
    }

    public void setMinValue(int n) {
        this.nDoc.setMinValue(n);
    }

    public boolean isMaxValueReached() {
        return this.nDoc.isMaxValueReached();
    }

    public boolean isMinValueReached() {
        return this.nDoc.isMinValueReached();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        try {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInvalidValue() {
        String string = super.getText();
        if (string == null || string.trim().length() == 0) {
            return !this.bAllowEmptyField;
        }
        return !this.nDoc.isValidValue();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.isInvalidValue() && this.behavior == 0) {
            this.nDoc.resetToValidValue();
        }
        for (int i = 0; i < this.focusLostListeners.size(); ++i) {
            ((FocusLostListener)this.focusLostListeners.elementAt(i)).lostFocus();
        }
    }

    public void addFocusLostListener(FocusLostListener focusLostListener) {
        if (focusLostListener != null) {
            this.focusLostListeners.addElement(focusLostListener);
        }
    }

    public void setIntValue(int n) {
        this.setText(String.valueOf(n));
    }

    public int getIntValue() {
        return this.nDoc.getIntValue();
    }

    public void setMaxChars(int n) {
        this.nDoc.setMaxChars(n);
    }

    public void setAllowAllowEmptyField(boolean bl) {
        this.bAllowEmptyField = bl;
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.nDoc.setAllowNonNumericValue(bl);
    }

    public boolean isAllowNonNumericValue() {
        return this.nDoc.isAllowNonNumericValue();
    }

    public long getLongValue() {
        return this.nDoc.getLongValue();
    }

    public void addZerotoSingleDisgitNumber(boolean bl) {
        this.addZeroBeforeSingleDigitNumber = bl;
    }

    public static interface FocusLostListener {
        public void lostFocus();
    }
}

