/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.JNumericTextField;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.NumericDocument;
import commvault.cte.component.TitledComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class NamedSizeRangeCombo
extends JPanel
implements ActionListener {
    public static final String ANY = CteStringBank.Any.getI18n();
    public static final String SMALL = CteStringBank.Small3_less_than_100_KB_4.getI18n();
    public static final String MEDIUM = CteStringBank.Medium_3_between_100_KB_and_1_MB_4.getI18n();
    public static final String LARGE = CteStringBank.Large_3_more_than_1_MB_4.getI18n();
    public static final String SPECIFY = CteStringBank.Specify_Size_3_in_KB_4.getI18n();
    public static final String ATMOST = CteStringBank.At_most.getI18n();
    public static final String ATLEAST = CteStringBank.At_least.getI18n();
    public static final String BETWEEN = CteStringBank.Between.getI18n();
    private JComboBox options = new JComboBox<String>(new String[]{ANY, SMALL, MEDIUM, LARGE, SPECIFY});
    private JComboBox specifyOptions = new JComboBox<String>(new String[]{ATLEAST, ATMOST, BETWEEN});
    private JNumericTextField min = new JNumericTextField(0, new NumericDocument(), 0);
    private JNumericTextField max = new JNumericTextField(0, new NumericDocument(), 0);

    public NamedSizeRangeCombo() {
        super(new BorderLayout(0, 5));
        this.setOpaque(false);
        this.min.setIncrementalValue(10);
        this.max.setIncrementalValue(10);
        this.initUI();
    }

    private void initUI() {
        this.add(this.options);
        this.options.addActionListener(this);
        this.specifyOptions.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.removeAll();
        this.add(this.options);
        if (this.options.getSelectedItem() == SPECIFY) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            this.add((Component)jPanel, "South");
            LayoutUtils.addRow((Container)jPanel, (JComponent)this.specifyOptions, true);
            if (this.specifyOptions.getSelectedIndex() == 0) {
                LayoutUtils.addRow(jPanel, this.min);
            }
            if (this.specifyOptions.getSelectedIndex() == 1) {
                LayoutUtils.addRow(jPanel, this.max);
            }
            if (this.specifyOptions.getSelectedIndex() == 2) {
                JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
                jPanel2.setOpaque(false);
                LayoutUtils.addRow(jPanel2, (JComponent)new TitledComponent(CteStringBank.Minimum.getI18n(), (JComponent)this.min), (JComponent)new TitledComponent(CteStringBank.Maximum.getI18n(), (JComponent)this.max));
                LayoutUtils.addRow((Container)jPanel, (JComponent)jPanel2, true);
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        }
        SwingUtilities.updateComponentTreeUI(this);
        this.doLayout();
    }

    public int getMinSize() {
        Object object = this.options.getSelectedItem();
        if (object == ANY || object == SMALL) {
            return 0;
        }
        if (object == MEDIUM) {
            return 100;
        }
        if (object == LARGE) {
            return 1024;
        }
        if (object == SPECIFY && this.specifyOptions.getSelectedIndex() != 1) {
            return this.min.getInt();
        }
        return 0;
    }

    public int getMaxSize() {
        Object object = this.options.getSelectedItem();
        if (object == ANY) {
            return 0;
        }
        if (object == SMALL) {
            return 100;
        }
        if (object == MEDIUM) {
            return 1024;
        }
        if (object == SPECIFY && this.specifyOptions.getSelectedIndex() != 0) {
            return this.max.getInt();
        }
        return 0x1FFFFF;
    }

    public void setValue(int n, int n2) {
        if (n == 0 && n2 == 0) {
            this.options.setSelectedIndex(0);
            return;
        }
        this.options.setSelectedItem(SPECIFY);
        this.specifyOptions.setSelectedIndex(n != 0 && n2 != Integer.MAX_VALUE ? 2 : (n == 0 ? 1 : 0));
        this.min.setInt(n);
        this.max.setInt(n2);
    }

    public Object getDisplayString() {
        if (this.options.getSelectedItem() != SPECIFY) {
            return this.options.getSelectedItem();
        }
        if (this.specifyOptions.getSelectedIndex() == 0) {
            return this.specifyOptions.getSelectedItem() + " " + this.min.getText();
        }
        if (this.specifyOptions.getSelectedIndex() == 1) {
            return this.specifyOptions.getSelectedItem() + " " + this.max.getText();
        }
        return MessageFormat.format(CteStringBank.Between_10012_and_10112.getI18n(), this.min.getInt(), this.max.getInt());
    }
}

