/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.NumericDocument;
import commvault.cte.component.NumericTextField;
import commvault.cte.component.StickyButton;
import commvault.cte.component.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class JNumericTextField
extends JPanel
implements ActionListener,
KeyListener,
NumericTextField.FocusLostListener {
    private int incrementalValue = 1;
    NumericTextField nField;
    StickyButton incrButton = new StickyButton(1);
    StickyButton decrButton = new StickyButton(5);
    private static final String incr = "INCR";
    private static final String decr = "DECR";
    public static final int AUTO_RESET_TO_LAST_VALID = 0;
    public static final int AUTO_POPUP_ERROR = 1;
    public static final int RETURN_ERROR = 2;
    private int incrementalMode = 0;
    public static final int LINEAR = 0;
    public static final int MULTIPLY = 1;
    public static final int DIVISIBLE = 2;
    int behavior = 0;
    private final JLabel unitLabel = new JLabel();
    private String errorStr;
    private final Vector listeners = new Vector();

    public JNumericTextField(String string, NumericDocument numericDocument, int n) {
        this(string, numericDocument, null);
        this.behavior = n;
        this.nField.setBehavior(n);
    }

    public JNumericTextField(String string, NumericDocument numericDocument) {
        this(string, numericDocument, null);
    }

    public JNumericTextField(String string, int n, NumericDocument numericDocument) {
        this(string, numericDocument);
        this.nField.setColumns(n);
    }

    public JNumericTextField(String string, NumericDocument numericDocument, String string2) {
        this.setLayout(new BorderLayout(1, 1));
        this.nField = new NumericTextField(string, numericDocument);
        this.add((Component)this.nField, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.incrButton);
        jPanel.add(this.decrButton);
        this.setOpaque(false);
        jPanel.setOpaque(false);
        if (string2 == null) {
            this.add((Component)jPanel, "East");
        } else {
            JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
            jPanel2.add((Component)jPanel, "West");
            this.unitLabel.setOpaque(false);
            jPanel2.add((Component)this.unitLabel, "East");
            this.setUnit(string2);
            this.add((Component)jPanel2, "East");
            jPanel2.setOpaque(false);
        }
        this.incrButton.setActionCommand(incr);
        this.decrButton.setActionCommand(decr);
        this.incrButton.addActionListener(this);
        this.decrButton.addActionListener(this);
        this.nField.addKeyListener(this);
        this.nField.addFocusLostListener(this);
        this.nField.setColumns(String.valueOf(numericDocument.getMaxValue()).length());
        jPanel.setPreferredSize(new Dimension(jPanel.getPreferredSize().width, this.nField.getPreferredSize().height));
        jPanel.setMinimumSize(new Dimension(30, 18));
    }

    public JNumericTextField(int n, NumericDocument numericDocument, int n2) {
        this(String.valueOf(n), numericDocument, null);
        this.behavior = n2;
        this.nField.setBehavior(n2);
    }

    public void setEditable(boolean bl) {
        this.nField.setEditable(bl);
    }

    @Override
    public void lostFocus() {
        if (this.nField != null && this.nField.getText() != null && this.nField.getText().trim().length() > 0) {
            int n = Integer.parseInt(this.nField.getText());
            this.firePropertyChange("intValue", 0, n);
            this.triggerActionEvent();
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (incr.equals(actionEvent.getActionCommand())) {
            long l = 0L;
            if (this.nField.getText().trim().equals("") || this.nField.getMinValue() > (long)this.nField.getIntValue()) {
                l = this.nField.getMinValue();
            } else {
                l = Integer.parseInt(this.nField.getText());
                l = this.getNextIncrementedValue();
                if (l > this.nField.getMaxValue()) {
                    l = this.nField.getMaxValue();
                }
            }
            this.setIntValue((int)l);
            this.checkList();
        } else if (decr.equals(actionEvent.getActionCommand())) {
            long l = 0L;
            if (this.nField.getText().trim().equals("")) {
                l = this.nField.getMinValue();
            } else {
                l = Integer.parseInt(this.nField.getText());
                l = this.getNextDecrementedValue();
                if (l < this.nField.getMinValue()) {
                    l = this.nField.getMinValue();
                }
            }
            this.setIntValue((int)l);
            this.checkList();
        }
        this.triggerActionEvent();
    }

    public JNumericTextField() {
        this("", new NumericDocument(1L, Integer.MAX_VALUE));
    }

    public void disableTimer() {
        this.incrButton.disbleTimer();
        this.decrButton.disbleTimer();
    }

    public void setErrorPopupString(String string) {
        this.errorStr = string;
    }

    public boolean isInvalidValue() {
        boolean bl = this.nField.isInvalidValue();
        if (bl && this.behavior == 1) {
            if (this.errorStr != null) {
                Utilities.showErrorMessage(this.errorStr);
            } else {
                Utilities.showErrorMessage(CteStringBank.Please_enter_valid_value6.getI18n());
            }
            this.requestFocus();
        }
        return bl;
    }

    public int getNextIncrementedValue() {
        if (this.incrementalMode == 1) {
            return this.getInt() * this.incrementalValue;
        }
        if (this.incrementalMode == 2) {
            int n = this.getInt();
            do {
                if (this.getMaxValue() % (long)(++n) != 0L) continue;
                return n;
            } while ((long)n < this.getMaxValue());
            return this.getInt();
        }
        return this.getInt() + this.incrementalValue;
    }

    public int getNextDecrementedValue() {
        if (this.incrementalMode == 1) {
            return this.getInt() / this.incrementalValue;
        }
        if (this.incrementalMode == 2) {
            int n = this.getInt();
            do {
                if (this.getMaxValue() % (long)(--n) != 0L) continue;
                return n;
            } while ((long)n > this.getMinValue());
            return this.getInt();
        }
        return this.getInt() - this.incrementalValue;
    }

    public void setInt(int n) {
        this.setText(Integer.toString(n));
    }

    public long getLong() {
        return new Long(this.nField.getText());
    }

    public void setLong(long l) {
        this.setText(Integer.toString((int)l));
    }

    public void setText(String string) {
        this.nField.setText(string);
    }

    public void setNonNumericText(String string) {
        this.nField.setNonNumericText(string);
    }

    public String getText() {
        return this.nField.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.nField.setEnabled(bl);
        this.incrButton.setEnabled(bl);
        this.decrButton.setEnabled(bl);
    }

    public NumericTextField getTextField() {
        return this.nField;
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.remove(actionListener);
        }
    }

    public void triggerActionEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(new ActionEvent(this, 1, "Command"));
        }
    }

    public long getMaxValue() {
        return this.nField.getMaxValue();
    }

    public long getMinValue() {
        return this.nField.getMinValue();
    }

    public void setMaxValue(int n) {
        this.nField.setMaxValue(n);
    }

    public void setMinValue(int n) {
        this.nField.setMinValue(n);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.nField) {
            if (keyEvent.getKeyCode() == 38) {
                this.incrButton.doClick();
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 40) {
                this.decrButton.doClick();
                keyEvent.consume();
            }
        }
    }

    public void checkList() {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.nField != null && this.nField.getText() != null && this.nField.getText().trim().length() > 0) {
            int n = Integer.parseInt(this.nField.getText());
            this.firePropertyChange("intValue", 0, n);
            this.triggerActionEvent();
        }
    }

    public int getIntValue() {
        return this.nField.getIntValue();
    }

    public void setIntValue(long l) {
        int n = this.getIntValue();
        this.nField.setText("" + l);
        this.firePropertyChange("intValue", n, (int)l);
    }

    @Override
    public void requestFocus() {
        this.nField.requestFocus();
    }

    public void setIncrementalValue(int n) {
        this.incrementalValue = n;
    }

    public int getIncrementalValue() {
        return this.incrementalValue;
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.nField.setAllowNonNumericValue(bl);
    }

    public boolean isAllowNonNumericValue() {
        return this.nField.isAllowNonNumericValue();
    }

    public NumericTextField getNumericField() {
        return this.nField;
    }

    public void setColumns(int n) {
        this.nField.setColumns(n);
    }

    public int getInt() {
        try {
            return new Integer(this.nField.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setUnit(String string) {
        this.unitLabel.setText(string);
    }

    public void setIncrementalMode(int n) {
        this.incrementalMode = n;
    }

    public long getLongValue() {
        return this.nField.getLongValue();
    }
}

