/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.FloatNumericDocument;
import commvault.cte.component.FloatNumericTextField;
import commvault.cte.component.StickyButton;
import commvault.cte.component.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JPanel;

public class JFloatNumericTextField
extends JPanel
implements ActionListener,
KeyListener,
FloatNumericTextField.FocusLostListener {
    private int incrementalValue = 1;
    FloatNumericTextField nField;
    StickyButton incrButton = new StickyButton(1);
    StickyButton decrButton = new StickyButton(5);
    private static final String incr = "INCR";
    private static final String decr = "DECR";
    public static final int AUTO_RESET_TO_LAST_VALID = 0;
    public static final int AUTO_POPUP_ERROR = 1;
    public static final int RETURN_ERROR = 2;
    int behavior = 0;
    private Vector listeners = new Vector();

    public JFloatNumericTextField(String string, int n, int n2, FloatNumericDocument floatNumericDocument, int n3) {
        this(string, n2, floatNumericDocument);
        this.behavior = n3;
        this.nField.setBehavior(n3);
        this.nField.setColumns(n);
    }

    public JFloatNumericTextField(String string, int n, int n2, FloatNumericDocument floatNumericDocument) {
        this(string, n, n2, floatNumericDocument, 0);
    }

    public JFloatNumericTextField(String string, int n, FloatNumericDocument floatNumericDocument) {
        this.setLayout(new BorderLayout(1, 1));
        this.nField = new FloatNumericTextField(string, n, floatNumericDocument);
        this.add((Component)this.nField, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(this.incrButton);
        jPanel.add(this.decrButton);
        this.add((Component)jPanel, "East");
        this.incrButton.setActionCommand(incr);
        this.decrButton.setActionCommand(decr);
        this.incrButton.addActionListener(this);
        this.decrButton.addActionListener(this);
    }

    public void setEditable(boolean bl) {
        this.nField.setEditable(bl);
    }

    @Override
    public void lostFocus() {
        this.triggerActionEvent();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        if (incr.equals(actionEvent.getActionCommand())) {
            Object object;
            double d = 0.0;
            if (this.nField.getText().trim().equals("") || this.nField.getFloatValue() < this.nField.getMinValue()) {
                d = this.nField.getMinValue();
            } else {
                d = Double.parseDouble(this.nField.getText());
                object = new BigDecimal(d += (double)this.incrementalValue / (this.nField.getMaximumFractionDigits() > 0 ? Math.pow(10.0, this.nField.getMaximumFractionDigits()) : 1.0));
                d = ((BigDecimal)(object = ((BigDecimal)object).setScale(this.nField.getMaximumFractionDigits(), RoundingMode.HALF_UP))).doubleValue();
                if (d > this.nField.getMaxValue()) {
                    d = this.nField.getMaxValue();
                }
            }
            object = String.valueOf(d);
            if (d < 0.001) {
                DecimalFormat decimalFormat = new DecimalFormat("###.#####");
                object = decimalFormat.format(d);
            }
            this.nField.setText((String)object);
            this.checkList();
        } else if (decr.equals(actionEvent.getActionCommand())) {
            Object object;
            double d = 0.0;
            if (this.nField.getText().trim().equals("")) {
                d = this.nField.getMinValue();
            } else {
                d = Double.parseDouble(this.nField.getText());
                object = new BigDecimal(d -= (double)this.incrementalValue / (this.nField.getMaximumFractionDigits() > 0 ? Math.pow(10.0, this.nField.getMaximumFractionDigits()) : 1.0));
                d = ((BigDecimal)(object = ((BigDecimal)object).setScale(this.nField.getMaximumFractionDigits(), RoundingMode.HALF_UP))).doubleValue();
                if (d < this.nField.getMinValue()) {
                    d = this.nField.getMinValue();
                }
            }
            object = String.valueOf(d);
            if (d < 0.001) {
                DecimalFormat decimalFormat = new DecimalFormat("###.#####");
                object = decimalFormat.format(d);
            }
            this.nField.setText(String.valueOf(object));
            this.checkList();
        }
        this.triggerActionEvent();
    }

    public JFloatNumericTextField(int n) {
        this.nField = new FloatNumericTextField(n);
    }

    public long getLong() {
        return new Long(this.nField.getText());
    }

    public void setLong(long l) {
        this.setText(Long.toString(l));
    }

    public void setText(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.nField.setText(string);
    }

    public void setNonNumericText(String string) {
        this.nField.setNonNumericText(string);
    }

    public String getText() {
        return this.nField.getText();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.nField.setEnabled(bl);
        this.incrButton.setEnabled(bl);
        this.decrButton.setEnabled(bl);
    }

    public FloatNumericTextField getTextField() {
        return this.nField;
    }

    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.listeners.add(actionListener);
        }
    }

    public void triggerActionEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(new ActionEvent(this, 1, "Command"));
        }
    }

    public double getMaxValue() {
        return this.nField.getMaxValue();
    }

    public double getMinValue() {
        return this.nField.getMinValue();
    }

    public void setMaxValue(long l) {
        this.nField.setMaxValue(l);
    }

    public void setMinValue(long l) {
        this.nField.setMinValue(l);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.nField) {
            if (keyEvent.getKeyCode() == 38) {
                this.incrButton.doClick();
            } else if (keyEvent.getKeyCode() == 40) {
                this.decrButton.doClick();
            }
        }
    }

    public void checkList() {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public double getFloatValue() {
        return this.nField.getFloatValue();
    }

    @Override
    public void requestFocus() {
        this.nField.requestFocus();
    }

    public boolean isInvalidValue() {
        boolean bl = this.nField.isInvalidValue();
        if (bl) {
            if (this.behavior == 1) {
                Utilities.showErrorMessage(CteStringBank.Please_enter_a_valid_value.getI18n());
            }
            this.requestFocus();
        }
        return bl;
    }

    public void setIncrementalValue(int n) {
        this.incrementalValue = n;
    }

    public float getIncrementalValue() {
        return this.incrementalValue;
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.nField.setAllowNonNumericValue(bl);
    }

    public boolean isAllowNonNumericValue() {
        return this.nField.isAllowNonNumericValue();
    }

    public void setColumns(int n) {
        this.nField.setColumns(n);
    }
}

