/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.events.ListClickListener;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;

class IList
extends JList
implements MouseListener {
    protected EventListenerList clickListenerList = new EventListenerList();

    public IList() {
        this.init();
    }

    public IList(ListModel listModel) {
        super(listModel);
        this.init();
    }

    public IList(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public IList(Vector vector) {
        super(vector);
        this.init();
    }

    private void init() {
        super.addMouseListener(this);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Rectangle rectangle;
        int n = this.locationToIndex(mouseEvent.getPoint());
        if (n < 0) {
            return null;
        }
        Object e = this.getModel().getElementAt(n);
        if (n == this.getModel().getSize() - 1 && !(rectangle = this.getCellBounds(n, n)).contains(mouseEvent.getPoint())) {
            e = null;
        }
        if (e == null) {
            return null;
        }
        return e.toString();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.fireMouseClicked(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void fireSingleClick() {
        this.fireMouseClicked(1);
    }

    protected void fireDoubleClick() {
        this.fireMouseClicked(2);
    }

    protected void fireMouseClicked(MouseEvent mouseEvent) {
        this.fireMouseClicked(mouseEvent.getClickCount());
    }

    protected void fireMouseClicked(int n) {
        int n2 = super.getSelectedIndex();
        if (n2 != -1) {
            this.fireMouseClicked(n, n2);
        }
    }

    protected void fireMouseClicked(int n, int n2) {
        Object[] objectArray = this.clickListenerList.getListenerList();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof ListClickListener)) continue;
            ((ListClickListener)object).mouseClicked(this, n, n2);
        }
    }

    public void addListClickListener(ListClickListener listClickListener) {
        this.clickListenerList.add(ListClickListener.class, listClickListener);
    }

    public void removeListClickListener(ListClickListener listClickListener) {
        this.clickListenerList.remove(ListClickListener.class, listClickListener);
    }
}

