/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.FloatNumericDocument;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class FloatNumericTextField
extends JTextField
implements FocusListener {
    FloatNumericDocument nDoc;
    int behavior = 0;
    Vector focusLostListeners = new Vector();

    public FloatNumericTextField(String string, int n, FloatNumericDocument floatNumericDocument) {
        super(floatNumericDocument, string, 2);
        this.setHorizontalAlignment(4);
        this.nDoc = floatNumericDocument;
        this.nDoc.setMaximumFractionDigits(n);
        this.setText(string);
        super.removeFocusListener(this);
        super.addFocusListener(this);
    }

    public FloatNumericTextField(int n) {
        this.setHorizontalAlignment(4);
        this.nDoc = new FloatNumericDocument(1.0f, Float.MAX_VALUE);
        this.nDoc.setMaximumFractionDigits(n);
        this.setDocument(this.nDoc);
        this.setText("");
    }

    public void setNonNumericText(String string) {
        super.setText(string);
    }

    public void setLong(long l) {
        this.setText(new Long(l).toString());
    }

    @Override
    public void setText(String string) {
        try {
            double d = Double.parseDouble(string);
            if (d < this.getMinValue() || d > this.getMaxValue()) {
                return;
            }
            super.setText(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Document createDefaultModel() {
        return this.nDoc;
    }

    public double getMaxValue() {
        return this.nDoc.getMaxValue();
    }

    public double getMinValue() {
        return this.nDoc.getMinValue();
    }

    public void setBehavior(int n) {
        this.behavior = n;
    }

    public void setMaxValue(float f) {
        this.nDoc.setMaxValue(f);
    }

    public void setMinValue(float f) {
        this.nDoc.setMinValue(f);
    }

    public boolean isMaxValueReached() {
        return this.nDoc.isMaxValueReached();
    }

    public boolean isMinValueReached() {
        return this.nDoc.isMinValueReached();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        try {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInvalidValue() {
        String string = super.getText();
        if (string == null || string.trim().length() == 0) {
            return true;
        }
        return !this.nDoc.isValidValue();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.isInvalidValue() && this.behavior == 0) {
            this.nDoc.resetToValidValue();
        }
        for (int i = 0; i < this.focusLostListeners.size(); ++i) {
            ((FocusLostListener)this.focusLostListeners.elementAt(i)).lostFocus();
        }
    }

    public void addFocusLostListener(FocusLostListener focusLostListener) {
        if (focusLostListener != null) {
            this.focusLostListeners.addElement(focusLostListener);
        }
    }

    public double getFloatValue() {
        return this.nDoc.getFloatValue();
    }

    public void setMaxChars(int n) {
        this.nDoc.setMaxChars(n);
    }

    public void setAllowNonNumericValue(boolean bl) {
        this.nDoc.setAllowNonNumericValue(bl);
    }

    public boolean isAllowNonNumericValue() {
        return this.nDoc.isAllowNonNumericValue();
    }

    public int getMaximumFractionDigits() {
        return this.nDoc.getMaximumFractionDigits();
    }

    public static interface FocusLostListener {
        public void lostFocus();
    }
}

