/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentComponentAdapter;
import com.jidesoft.document.DocumentComponentEvent;
import com.jidesoft.document.DocumentComponentListener;
import commvault.cte.CteStringBank;
import commvault.cte.component.ControlPanel;
import commvault.cte.component.dock.DummyFeatureDocument;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.dock.FeatureFrame;
import commvault.cte.component.dock.FeatureLoader;
import commvault.cte.component.dock.FeatureLoaderFactory;
import commvault.cte.component.dock.LoaderContext;
import commvault.cte.component.explorer.Refreshable;
import commvault.cte.component.table.NTable;
import commvault.cte.util.Application;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class FeatureDocument
extends DocumentComponent
implements Refreshable {
    protected Feature feature;
    private boolean pinned;
    static int lastKey = 0;
    private static Set<String> keyMap = new HashSet<String>();
    private static boolean isUserPrefFramesLoaded = false;
    private boolean isLoading = false;

    protected FeatureDocument(final String string) {
        super((JComponent)new JLabel(CteStringBank.LOADING_DOTS.getI18n(), Application.instance().getIconSource().getIcon("Progress-Blue"), 0), string);
        this.addDocumentComponentListener((DocumentComponentListener)new DocumentComponentAdapter(){

            public void documentComponentClosed(DocumentComponentEvent documentComponentEvent) {
                FeatureDocument.this.documentComponentClosed();
            }

            public void documentComponentActivated(DocumentComponentEvent documentComponentEvent) {
                if (isUserPrefFramesLoaded && !FeatureDocument.this.isLoading) {
                    FeatureDocument.this.isLoading = true;
                    new Thread(){

                        @Override
                        public void run() {
                            if (FeatureDocument.loadInEventDespatch(string)) {
                                SwingUtilities.invokeLater(() -> {
                                    FeatureDocument.this.documentComponentActivated();
                                    FeatureDocument.this.isLoading = false;
                                });
                            } else {
                                FeatureDocument.this.documentComponentActivated();
                                FeatureDocument.this.isLoading = false;
                            }
                        }
                    }.start();
                }
            }

            public void documentComponentOpened(DocumentComponentEvent documentComponentEvent) {
                FeatureDocument.this.documentComponentOpened();
            }

            public void documentComponentClosing(DocumentComponentEvent documentComponentEvent) {
                FeatureDocument.this.documentComponentClosing();
            }
        });
        keyMap.add(string);
    }

    public static FeatureDocument createDocument(Feature feature) {
        return FeatureDocument.createDocument1(feature, FeatureDocument.createKey(feature.getFeatureContext().getType()));
    }

    public static FeatureDocument createDocument1(Feature feature, String string) {
        LoaderContext.FrameInfo frameInfo = new LoaderContext.FrameInfo();
        frameInfo.setKey(string);
        frameInfo.setContext(feature.getFeatureContext());
        DummyFeatureDocument dummyFeatureDocument = new DummyFeatureDocument(frameInfo, FeatureLoaderFactory.getInstance().createFeatureLoader(feature.getFeatureContext().getType()));
        dummyFeatureDocument.setFeature(feature);
        return dummyFeatureDocument;
    }

    public static DummyFeatureDocument createDummyDocument(LoaderContext.FrameInfo frameInfo, FeatureLoader featureLoader) {
        return FeatureDocument.createDummyDocument(frameInfo, featureLoader, FeatureDocument.createKey(frameInfo.getContext().getType()));
    }

    public static DummyFeatureDocument createDummyDocument(LoaderContext.FrameInfo frameInfo, FeatureLoader featureLoader, String string) {
        frameInfo.setKey(string);
        return new DummyFeatureDocument(frameInfo, featureLoader);
    }

    private static String createKey(Feature.FeatureType featureType) {
        String string = featureType.toString() + "$$" + ++lastKey;
        if (keyMap.contains(string)) {
            return FeatureDocument.createKey(featureType);
        }
        return string;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public void setFeature(Feature feature) {
        Feature feature2 = this.feature;
        this.feature = feature;
        this.setIcon((Icon)this.feature.getValue("Icon"));
        this.setTitle(this.getName());
        this.setTooltip(this.getRenderTitle());
        FeatureFrame featureFrame = new FeatureFrame(feature);
        this.setIcon((Icon)feature.getValue("Icon"));
        featureFrame.setName(this.getName());
        this.setComponent((JComponent)((Object)featureFrame));
        if (feature2 != feature && feature2 != null) {
            feature2.featureClosed();
        }
        if (feature != null && feature.getFeatureContext() != null && feature.getFeatureContext().getType() != null && feature.getFeatureContext().getType().isRefreshDocFeatureChanged()) {
            feature.refresh();
        }
        this.transferFocusToTable();
    }

    public String getRenderTitle() {
        if (this.feature == null) {
            return this.getTitle();
        }
        String string = (String)this.feature.getValue("Tab Title");
        if (string == null) {
            string = (String)this.feature.getValue("Name");
        }
        return string;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean bl) {
        this.pinned = bl;
    }

    @Override
    public void refresh(Object object) {
        this.feature.refresh();
        this.transferFocusToTable();
    }

    protected void documentComponentClosed() {
        if (this.feature != null) {
            this.feature.featureClosed();
        }
        this.getComponent().removeAll();
        this.feature = null;
        this.setComponent(null);
    }

    protected void documentComponentClosing() {
        if (this.feature != null) {
            this.setAllowClosing(this.feature.featureClosing());
        }
    }

    protected void documentComponentActivated() {
        if (this.feature != null) {
            this.feature.featureActivated();
            this.transferFocusToTable();
        }
    }

    protected void transferFocusToTable() {
        this.setTableFocus(this.getComponent());
    }

    protected void setTableFocus(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        for (Component component : jComponent.getComponents()) {
            if (component instanceof NTable) {
                ((NTable)component).getTable().grabFocus();
                ((NTable)component).setShowMatchingRowsOnlyState();
                return;
            }
            if (component instanceof ControlPanel) {
                if (((ControlPanel)component).getFirstFocusableComponent() != null) {
                    ((ControlPanel)component).getFirstFocusableComponent().grabFocus();
                }
                return;
            }
            if (!(component instanceof JComponent)) continue;
            this.setTableFocus((JComponent)component);
        }
    }

    protected void documentComponentOpened() {
        if (this.feature != null) {
            this.feature.featureAdded();
        }
    }

    public void resetFeatureToNull() {
        this.feature = null;
    }

    public static boolean isUserPrefFramesLoaded() {
        return isUserPrefFramesLoaded;
    }

    public static void setUserPrefFramesLoaded(boolean bl) {
        isUserPrefFramesLoaded = bl;
    }

    public static boolean loadInEventDespatch(String string) {
        return string != null && string.trim().length() > 0 && string.startsWith("JOBCONTROLLER");
    }
}

