/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ControlledDocument
extends PlainDocument {
    protected char[] unWantedChars = null;
    protected int maxChars = -1;
    protected boolean editable = true;

    public ControlledDocument() {
    }

    public ControlledDocument(boolean bl) {
        this.setEditable(bl);
    }

    public ControlledDocument(char[] cArray) {
        this.setUnwantedChars(cArray);
    }

    public ControlledDocument(String string) {
        this.setUnwantedChars(string);
    }

    public ControlledDocument(char c) {
        this.setUnwantedChars(c);
    }

    public ControlledDocument(int n) {
        this.setMaximumChars(n);
    }

    public ControlledDocument(char[] cArray, int n) {
        this.setMaximumChars(n);
        this.setUnwantedChars(cArray);
    }

    public ControlledDocument(String string, int n) {
        this.setMaximumChars(n);
        this.setUnwantedChars(string);
    }

    public ControlledDocument(char c, int n) {
        this.setMaximumChars(n);
        this.setUnwantedChars(c);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setMaximumChars(int n) {
        this.maxChars = n;
        try {
            String string = this.getText(0, this.getLength());
            if (string.length() > n) {
                this.remove(n, string.length() - n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getMaximumChars() {
        return this.maxChars;
    }

    public char[] getUnwantedChars() {
        return this.unWantedChars;
    }

    public void setUnwantedChars(char[] cArray) {
        this.unWantedChars = cArray;
    }

    public void setUnwantedChars(String string) {
        if (string == null) {
            this.unWantedChars = null;
            return;
        }
        this.unWantedChars = new char[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            this.unWantedChars[i] = string.charAt(i);
        }
    }

    public void setUnwantedChars(char c) {
        this.setUnwantedChars(new char[]{c});
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (!this.isEditable() || this.containsInvalidChars(string)) {
            return;
        }
        if (this.isLimitExceeded(string)) {
            string = this.trimThis(string);
        }
        super.insertString(n, string, attributeSet);
    }

    protected String trimThis(String string) {
        int n = this.getMaximumChars();
        int n2 = this.getLength();
        if (n2 + string.length() <= n) {
            return string;
        }
        return string.substring(0, n - n2);
    }

    protected boolean containsInvalidChars(String string) {
        char[] cArray = this.getUnwantedChars();
        if (cArray == null) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (string.indexOf(cArray[i]) == -1) continue;
            return true;
        }
        return false;
    }

    protected boolean isLimitExceeded(String string) {
        try {
            String string2 = this.getText(0, this.getLength());
            if (string2 == null || string == null) {
                return false;
            }
            if (this.maxChars >= 0 && string2.length() + string.length() > this.getMaximumChars()) {
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        if (!this.isEditable()) {
            return;
        }
        super.remove(n, n2);
    }
}

