/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.JSLabel;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.SComboBox;
import commvault.cte.component.SortedComboBoxModel;
import commvault.cte.component.table.CVColumn;
import commvault.cte.component.table.CVTableModel;
import commvault.cte.component.table.NTable;
import commvault.cte.net.IdNameItem;
import commvault.cte.reports.util.ReportConverterUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class ConfigurableContentPanel<T>
extends JPanel
implements ActionListener {
    protected CVTableModel<T> tableModel;
    private SComboBox combo = new SComboBox();
    protected JButton applyButton = new JButton(CteStringBank.Apply.getI18n());
    private NTable table;
    protected List<IdNameItem> selectableItem;

    public ConfigurableContentPanel(Class<T> clazz, List<T> list, List<IdNameItem> list2) {
        super(new GridBagLayout());
        this.selectableItem = list2;
        List<String> list3 = this.createColumnsForTable();
        final Class[] classArray = this.getColumnClassesForTable();
        this.getColumnNameMap();
        this.tableModel = new CVTableModel<T>(clazz, list3, list){

            @Override
            public Class getColumnClass(int n) {
                return classArray[n];
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (((CVColumn)this.columns.get(n2)).getId() == ConfigurableContentPanel.this.getEditingColumn()) {
                    IdNameItem idNameItem = (IdNameItem)object;
                    Integer[] integerArray = new Integer[]{n};
                    if (!ConfigurableContentPanel.this.validateLREPSupport(integerArray, idNameItem.getId())) {
                        return;
                    }
                    if (!ConfigurableContentPanel.this.validateLogSP(integerArray, idNameItem.getId())) {
                        return;
                    }
                    ConfigurableContentPanel.this.setSubclientOnTable(n, idNameItem);
                } else {
                    super.setValueAt(object, n, n2);
                }
            }
        };
        this.table = new NTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.tableModel.getEditingColumns().add(this.getEditingColumn());
        LayoutUtils.fillRemaining(this, this.table);
        LayoutUtils.addRow((Container)this, new JComponent[]{new JLabel(this.getLabelForCombo()), this.combo, this.applyButton}, false);
        SearchableComboBoxModel searchableComboBoxModel = new SearchableComboBoxModel(list2.toArray());
        this.combo.setModel(searchableComboBoxModel);
        this.combo.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXX");
        this.combo.setUI(new ComboUI());
        this.table.setGroupingEnabled(true);
        this.table.setGroupingColumn(new int[]{0});
        this.table.fitToData();
        this.table.setColumnWidth("storagePolicyName", (int)new JSLabel(CteStringBank.SelectStoragePolicy.getI18n()).getPreferredSize().getWidth() + 25);
        this.table.getTable().setDefaultRenderer(IdNameItem.class, new ToolTipTextTableCellRenderer1());
        this.applyButton.addActionListener(this);
        TableColumn tableColumn = this.table.getTable().getColumn(this.getEditingColumn());
        tableColumn.setCellEditor(new DefaultCellEditor(new SComboBox((ComboBoxModel)searchableComboBoxModel)){
            SComboBox combo;
            SearchableComboBoxModel model;
            IdNameItem lastSelected;
            {
                this.combo = null;
                this.model = null;
                this.lastSelected = null;
                this.combo = (SComboBox)this.editorComponent;
                this.model = (SearchableComboBoxModel)this.combo.getModel();
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                int n3 = this.model.getIndexOf(object);
                this.combo.setSelectedIndex(n3);
                this.lastSelected = (IdNameItem)this.combo.getSelectedItem();
                this.combo.setUI(new ComboUI());
                return this.combo;
            }
        });
    }

    protected abstract String getLabelForCombo();

    protected abstract String getEditingColumn();

    protected abstract List<String> createColumnsForTable();

    protected abstract void setSubclientOnTable(int var1, IdNameItem var2);

    protected abstract boolean validateLREPSupport(Integer[] var1, int var2);

    protected abstract boolean validateLogSP(Integer[] var1, int var2);

    protected abstract Class[] getColumnClassesForTable();

    protected abstract Map<String, String> getColumnNameMap();

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.applyButton) {
            int[] nArray = this.getSelectedRows();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int n2 : nArray) {
                if (n2 == -1) continue;
                arrayList.add(new Integer(n2));
            }
            Integer[] integerArray = arrayList.toArray(new Integer[0]);
            if (!this.validateLREPSupport(integerArray, ((IdNameItem)this.combo.getSelectedItem()).getId())) {
                return;
            }
            if (!this.validateLogSP(integerArray, ((IdNameItem)this.combo.getSelectedItem()).getId())) {
                return;
            }
            Integer[] integerArray2 = integerArray;
            int n = integerArray2.length;
            for (int n2 = 0; n2 < n; ++n2) {
                int n3 = integerArray2[n2];
                if (n3 == -1) continue;
                this.setSubclientOnTable(n3, (IdNameItem)this.combo.getSelectedItem());
            }
            if (nArray.length != 0) {
                this.tableModel.fireTableRowsUpdated(integerArray[0], integerArray[integerArray.length - 1]);
            }
        }
    }

    protected int[] getSelectedRows() {
        return this.table.getUnsortedSelectedRows();
    }

    protected abstract void createAssociatingEntity();

    public abstract List<T> getAssociatedList();

    class ComboUI
    extends BasicComboBoxUI {
        ComboUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox){

                @Override
                protected JScrollPane createScroller() {
                    return new JScrollPane(this.list, 20, 30);
                }
            };
            return basicComboPopup;
        }
    }

    private class SearchableComboBoxModel
    extends SortedComboBoxModel {
        Object[] items;
        Map<String, Integer> map;

        public SearchableComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.items = null;
            this.map = new HashMap<String, Integer>(20);
            this.items = objectArray;
            for (Object object : objectArray) {
                this.map.put(((IdNameItem)object).getName(), ((IdNameItem)object).getId());
            }
        }

        @Override
        public int getIndexOf(Object object) {
            int n = -1;
            try {
                n = this.map.get((String)object);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (n == -1) {
                return -1;
            }
            return super.getIndexOf(new IdNameItem(n, (String)object));
        }
    }

    public class ToolTipTextTableCellRenderer1
    implements TableCellRenderer {
        private final DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                String string = object.toString();
                if (string.length() == 0) {
                    component = this.renderer.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
                    ((JLabel)component).setVerticalAlignment(1);
                    ((JLabel)component).setHorizontalAlignment(2);
                    ((JLabel)component).setText(CteStringBank.SelectStoragePolicy.getI18n());
                    if (!bl) {
                        if (n % 2 == 0) {
                            component.setBackground(Color.WHITE);
                        } else {
                            component.setBackground(ReportConverterUtilities.COLOR_LIGHT_LIGHT_GREY);
                        }
                        ((JLabel)component).setFont(((JLabel)component).getFont().deriveFont(1));
                        ((JLabel)component).setForeground(Color.BLUE);
                    }
                    return component;
                }
                if (!bl) {
                    ((JLabel)component).setForeground(Color.BLACK);
                }
            }
            return component;
        }
    }
}

