/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.component.CVFrame;
import commvault.cte.component.PDialog;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.calender.PopupCalendar;
import commvault.cte.component.wizard.WizardDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextArea;

public final class CXFocusManager
extends DefaultKeyboardFocusManager {
    public static final int PDIALOG = 0;
    public static final int PROPDIALOG = 1;
    public static final int WIZARD = 2;
    public static final int BASEFRAME = 3;
    public static final int JDIALOG = 4;
    public static final int UNKNOWN = -1;
    public static final int UNKNOWN_EVENT = 0;
    public static final int ACCEPT_EVENT = 1;
    public static final int CANCEL_EVENT = 2;
    public static final int NEXT_TAB_EVENT = 3;
    public static final int PREV_TAB_EVENT = 4;
    public static final int ENABLE_DISABLE_OP_EVENT = 5;
    private int containerType = 0;
    private int eventType = 0;
    Container container = null;
    public Hashtable pressedkeysTable = new Hashtable();

    public int getContainerType() {
        return this.containerType;
    }

    public int getEventType() {
        return this.eventType;
    }

    protected boolean isInterestedInEvent(Component component, KeyEvent keyEvent) {
        this.eventType = 0;
        if (this.isCancelEvent(component, keyEvent)) {
            this.eventType = 2;
            return true;
        }
        if (this.isAcceptChangesEvent(component, keyEvent)) {
            this.eventType = 1;
            return true;
        }
        if (this.isEnableOrDisableOutputEvent(component, keyEvent)) {
            this.eventType = 5;
            return true;
        }
        if (this.isPreviousTabEvent(component, keyEvent)) {
            this.eventType = 4;
            return true;
        }
        if (this.isNextTabEvent(component, keyEvent)) {
            this.eventType = 3;
            return true;
        }
        return this.isNextKeyEvent(component, keyEvent) || this.isBackKeyEvent(component, keyEvent);
    }

    @Override
    public void processKeyEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        this.recalculateContainerType(component);
        if (!this.isInterestedInEvent(component, keyEvent)) {
            this.processKey(component, keyEvent);
            return;
        }
        this.recalculateContainerType(component);
        if (this.container == null) {
            this.containerType = -1;
        }
        if (this.getEventType() == 5) {
            this.enableOrDisableOuput(keyEvent);
            return;
        }
        if (this.container instanceof FocusManagerListener) {
            this.handleFocusKeyEvent((FocusManagerListener)((Object)this.container), component, keyEvent);
            return;
        }
        switch (this.getContainerType()) {
            case 3: {
                break;
            }
            case 4: {
                this.handleJDialogKeyEvent((JDialog)this.container, component, keyEvent);
                break;
            }
            default: {
                this.processKey(component, keyEvent);
            }
        }
        this.container = null;
    }

    protected void handleFocusKeyEvent(FocusManagerListener focusManagerListener, Component component, KeyEvent keyEvent) {
        boolean bl = false;
        switch (this.getEventType()) {
            case 2: {
                if (this.shouldCancelOut(component, keyEvent)) {
                    bl = focusManagerListener.rejectChanges(component);
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = focusManagerListener.goToPreviousTab(component);
                break;
            }
            case 3: {
                bl = focusManagerListener.goToNextTab(component);
                break;
            }
            case 1: {
                bl = component instanceof JButton ? false : focusManagerListener.acceptChanges(component);
            }
        }
        if (bl) {
            keyEvent.consume();
        } else {
            this.processKey(component, keyEvent);
        }
    }

    protected void handleJDialogKeyEvent(JDialog jDialog, Component component, KeyEvent keyEvent) {
        if (this.getEventType() != 2 || !this.shouldCancelOut(component, keyEvent)) {
            this.processKey(component, keyEvent);
            return;
        }
        jDialog.dispose();
        keyEvent.consume();
    }

    protected boolean isEnableOrDisableOutputEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return false;
        }
        if (keyEvent.getKeyCode() == 117 || keyEvent.getKeyCode() == 118 || keyEvent.getKeyCode() == 122 || keyEvent.getKeyCode() == 120 || keyEvent.getKeyCode() == 123 || keyEvent.getKeyCode() == 113) {
            return true;
        }
        return keyEvent.getKeyCode() == 119 && this.containsModifier(keyEvent, 8);
    }

    protected boolean enableOrDisableOuput(KeyEvent keyEvent) {
        throw new UnsupportedOperationException("not implemented");
    }

    protected boolean shouldCancelOut(Component component, KeyEvent keyEvent) {
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            if (jComboBox.isPopupVisible()) {
                keyEvent.consume();
                jComboBox.setPopupVisible(false);
                return false;
            }
            if (component instanceof JTextArea) {
                keyEvent.consume();
                return false;
            }
        }
        return true;
    }

    private boolean containsModifier(KeyEvent keyEvent, int n) {
        return (keyEvent.getModifiers() & n) == n;
    }

    protected boolean isNextTabEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return false;
        }
        if (keyEvent.getKeyCode() != 9 || !this.containsModifier(keyEvent, 2)) {
            return false;
        }
        PopupCalendar popupCalendar = this.getParentPopup(component);
        if (popupCalendar != null) {
            popupCalendar.cancel();
        }
        return true;
    }

    protected boolean isPreviousTabEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return false;
        }
        if (keyEvent.getKeyCode() != 9 || !this.containsModifier(keyEvent, 2) || !this.containsModifier(keyEvent, 1)) {
            return false;
        }
        PopupCalendar popupCalendar = this.getParentPopup(component);
        if (popupCalendar != null) {
            popupCalendar.cancel();
        }
        return true;
    }

    protected boolean isNextKeyEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return false;
        }
        return keyEvent.getKeyCode() == 39 && this.containsModifier(keyEvent, 8);
    }

    protected boolean isBackKeyEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getID() != 401) {
            return false;
        }
        return keyEvent.getKeyCode() == 37 && this.containsModifier(keyEvent, 8);
    }

    protected boolean isCancelEvent(Component component, KeyEvent keyEvent) {
        if (keyEvent.getID() != 401 || keyEvent.getKeyChar() != '\u001b') {
            return false;
        }
        PopupCalendar popupCalendar = this.getParentPopup(component);
        return popupCalendar == null;
    }

    protected boolean isAcceptChangesEvent(Component component, KeyEvent keyEvent) {
        Serializable serializable;
        if (keyEvent.getID() == 401 && keyEvent.getKeyChar() == '\n') {
            if (this.container != null) {
                this.pressedkeysTable.put(this.container, Boolean.TRUE);
            }
            return false;
        }
        if (keyEvent.getID() != 402 || keyEvent.getKeyChar() != '\n') {
            return false;
        }
        if (this.container != null) {
            serializable = (Boolean)this.pressedkeysTable.get(this.container);
            if (serializable == null) {
                return false;
            }
            if (!serializable.booleanValue()) {
                return false;
            }
            this.pressedkeysTable.remove(this.container);
        }
        if (component instanceof JComboBox && ((JComboBox)component).isPopupVisible()) {
            return false;
        }
        if (component instanceof JTextArea) {
            return false;
        }
        if (component instanceof JMenuItem) {
            return false;
        }
        serializable = this.getParentPopup(component);
        return serializable == null;
    }

    public PopupCalendar getParentPopup(Component component) {
        Container container = null;
        for (container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof PopupCalendar)) continue;
            return (PopupCalendar)container;
        }
        return null;
    }

    private void recalculateContainerType(Component component) {
        Container container = null;
        for (container = component.getParent(); container != null; container = container.getParent()) {
            if (container instanceof PDialog) {
                this.container = container;
                this.containerType = 0;
                break;
            }
            if (container instanceof PropertyDialog) {
                this.container = container;
                this.containerType = 1;
                break;
            }
            if (container instanceof WizardDialog) {
                this.container = container;
                this.containerType = 2;
                break;
            }
            if (container instanceof CVFrame) {
                this.container = container;
                this.containerType = 3;
                break;
            }
            if (!(container instanceof JDialog)) continue;
            this.container = container;
            this.containerType = 4;
            break;
        }
    }

    public void processKey(Component component, KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t') {
            int n;
            JComponent jComponent;
            if (!(!(component instanceof JComponent) || (jComponent = (JComponent)component) instanceof JTable || jComponent.getFocusTraversalKeysEnabled() || (n = keyEvent.getModifiers() & 2) == 2 && keyEvent.getKeyCode() != 73)) {
                return;
            }
            if (keyEvent.getID() != 401) {
                keyEvent.consume();
                return;
            }
            if ((keyEvent.getModifiers() & 1) == 1) {
                this.focusPreviousComponent(component);
            } else {
                this.focusNextComponent(component);
            }
            keyEvent.consume();
        }
    }

    public static interface FocusManagerListener {
        public boolean acceptChanges(Component var1);

        public boolean rejectChanges(Component var1);

        public boolean goToNextTab(Component var1);

        public boolean goToPreviousTab(Component var1);

        public boolean goToNextPage(Component var1);

        public boolean goToPreviousPage(Component var1);
    }
}

