/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.document.DocumentComponent;
import com.jidesoft.document.DocumentPane;
import com.jidesoft.document.IDocumentGroup;
import com.jidesoft.document.IDocumentPane;
import com.jidesoft.document.PopupMenuCustomizer;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.ResizablePanel;
import com.jidesoft.swing.StringConverter;
import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.FeatureDocument;
import commvault.cte.component.KeyHandler;
import commvault.cte.component.dock.CVDockableFrameManager;
import commvault.cte.component.dock.CVMenuBar;
import commvault.cte.component.dock.DummyFeatureDocument;
import commvault.cte.component.dock.Feature;
import commvault.cte.component.dock.FeatureFrame;
import commvault.cte.component.explorer.Refreshable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CVWorkspace
extends DocumentPane
implements ChangeListener {
    private static final String GO_DOWN_NEXT_LEVEL = CteStringBank.Go_Down_Next_Level.getI18n();
    private static final String GO_UP_ONE_LEVEL = CteStringBank.Go_Up_One_Level.getI18n();
    private static boolean _autohideAll = false;
    private static byte[] _fullScreenLayout;
    private DockingManager dockMgr;
    public final Action popOutAction = new AbstractAction(CteStringBank.Float.getI18n()){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CVWorkspace.this.popOutTab();
        }
    };
    public final Action maximizeAction = new AbstractAction(CteStringBank.Maximize.getI18n()){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CVWorkspace.this.maximizeTab();
        }
    };
    public final Action minimizeAction = new AbstractAction(CteStringBank.Minimize.getI18n()){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CVWorkspace.this.minimizeTab();
        }
    };
    private String lastActiveSummaryWindow;
    public Dimension lastFloatingWindowDimension = new Dimension(800, 600);

    public CVWorkspace(DockingManager dockingManager) {
        this.dockMgr = dockingManager;
        this.setTabPlacement(1);
        this.popOutAction.putValue("ShortDescription", CteStringBank.Float.getI18n());
        this.maximizeAction.putValue("ShortDescription", CteStringBank.Maximize.getI18n());
        this.minimizeAction.putValue("ShortDescription", CteStringBank.Minimize.getI18n());
        this.popOutAction.putValue("SmallIcon", UIDefaultsLookup.getIcon((Object)"DockableFrameTitlePane.floatIcon"));
        this.maximizeAction.putValue("SmallIcon", UIDefaultsLookup.getIcon((Object)"DockableFrameTitlePane.maximizeIcon"));
        this.minimizeAction.putValue("SmallIcon", UIDefaultsLookup.getIcon((Object)"DockableFrameTitlePane.autohideIcon"));
        this.setPopupMenuCustomizer(new PopupMenuCustomizer(){

            public void customizePopupMenu(JPopupMenu jPopupMenu, final IDocumentPane iDocumentPane, final String string, IDocumentGroup iDocumentGroup, boolean bl) {
                jPopupMenu.addSeparator();
                jPopupMenu.add(CVWorkspace.this.popOutAction);
                jPopupMenu.add(CVWorkspace.this.maximizeAction);
                jPopupMenu.add(CVWorkspace.this.minimizeAction);
                jPopupMenu.addSeparator();
                if (string.startsWith(Feature.FeatureType.COMMCELL_SUMMARY.name())) {
                    jPopupMenu.add(CVMenuBar.createSubManu(GO_UP_ONE_LEVEL, KeyStroke.getKeyStroke(8, 0), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ((KeyHandler)((Object)((FeatureFrame)((Object)iDocumentPane.getDocument(string).getComponent())).getFeature())).handleKeyEvent(new KeyEvent((Component)((Object)CVWorkspace.this), 401, 0L, 0, 8));
                        }
                    }));
                    jPopupMenu.add(CVMenuBar.createSubManu(GO_DOWN_NEXT_LEVEL, KeyStroke.getKeyStroke(10, 0), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ((KeyHandler)((Object)((FeatureFrame)((Object)iDocumentPane.getDocument(string).getComponent())).getFeature())).handleKeyEvent(new KeyEvent((Component)((Object)CVWorkspace.this), 401, 0L, 0, 10));
                        }
                    }));
                }
                if (string.startsWith(Feature.FeatureType.USER_COMMUNICATOR.name())) {
                    jPopupMenu.add(CVMenuBar.createSubManu(CteStringBank.Save_as.getI18n(), KeyStroke.getKeyStroke(83, 2), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ((KeyHandler)((Object)((FeatureFrame)((Object)iDocumentPane.getDocument(string).getComponent())).getFeature())).handleKeyEvent(new KeyEvent((Component)((Object)CVWorkspace.this), 401, 0L, 2, 83));
                        }
                    }));
                }
            }
        });
        this.setTabbedPaneCustomizer(this.createTabbedPaneCustomizer());
        this.setTitleConverter(new StringConverter(){

            public String convert(String string) {
                DocumentComponent documentComponent = CVWorkspace.this.getDocument(string);
                if (documentComponent != null && documentComponent instanceof FeatureDocument) {
                    FeatureDocument featureDocument = (FeatureDocument)documentComponent;
                    String string2 = featureDocument.getRenderTitle();
                    if (string2.length() > 25) {
                        return string2.substring(0, 25) + "...";
                    }
                    return string2;
                }
                return string;
            }
        });
    }

    protected void minimizeTab() {
        FeatureDocument featureDocument = (FeatureDocument)this.getActiveDocument();
        if (featureDocument != null) {
            Feature feature = featureDocument.getFeature();
            featureDocument.resetFeatureToNull();
            this.closeDocument(featureDocument.getName());
            if (!this.isDocumentOpened(featureDocument.getName())) {
                FeatureFrame featureFrame = this.createMinimisedFrame(feature, featureDocument.getName());
                CVDockableFrameManager.getInstance().showFrame(featureFrame, false);
            }
        }
    }

    private FeatureFrame createMinimisedFrame(Feature feature, String string) {
        FeatureFrame featureFrame = new FeatureFrame(feature);
        featureFrame.setKey(string);
        featureFrame.setInitIndex(0);
        featureFrame.setInitMode(2);
        featureFrame.setInitSide(2);
        this.configureMinimisedFeature(featureFrame);
        return featureFrame;
    }

    public void configureMinimisedFeature(final FeatureFrame featureFrame) {
        AbstractAction abstractAction = new AbstractAction(CteStringBank.Restore.getI18n()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.popInTab(featureFrame.getKey());
            }
        };
        abstractAction.putValue("ShortDescription", CteStringBank.Restore.getI18n());
        featureFrame.setAutohideAction(abstractAction);
        featureFrame.setAvailableButtons(5);
        featureFrame.showButtonPanel(false);
    }

    public void configureMaximisedFeature(final FeatureFrame featureFrame) {
        this.dockMgr.maximizeFrame(featureFrame.getKey());
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.popInTab(featureFrame.getKey());
            }
        };
        abstractAction.putValue("ShortDescription", CteStringBank.Restore.getI18n());
        featureFrame.setMaximizeAction(abstractAction);
        featureFrame.setAvailableButtons(17);
        featureFrame.showButtonPanel(false);
    }

    public void configureFloatingFeature(final FeatureFrame featureFrame) {
        Dimension dimension = this.lastFloatingWindowDimension;
        featureFrame.getContentPane().setMinimumSize(dimension);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        rectangle.x = (rectangle.x + rectangle.width - dimension.width) / 2;
        rectangle.y = (rectangle.y + rectangle.height - dimension.height) / 2;
        rectangle.height = dimension.height;
        rectangle.width = dimension.width;
        featureFrame.setUndockedBounds(rectangle);
        AbstractAction abstractAction = new AbstractAction(CteStringBank.Dock_to_Tabs.getI18n()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.popInTab(featureFrame.getKey());
            }
        };
        abstractAction.putValue("ShortDescription", CteStringBank.Unfloat.getI18n());
        featureFrame.setFloatingAction(abstractAction);
        featureFrame.setMaximizeAction(this.maximizeAction);
        this.maximizeAction.putValue("ShortDescription", CteStringBank.Maximize.getI18n());
        featureFrame.setAvailableButtons(25);
        featureFrame.showButtonPanel(false);
        featureFrame.getContentPane().setMinimumSize(new Dimension(50, 50));
        featureFrame.setDockable(false);
    }

    private void popInTab(String string) {
        DockableFrame dockableFrame = this.dockMgr.getFrame(string);
        if (dockableFrame instanceof FeatureFrame) {
            FeatureFrame featureFrame = (FeatureFrame)dockableFrame;
            Feature feature = featureFrame.getFeature();
            featureFrame.setFeatureToNull();
            this.dockMgr.removeFrame(string);
            this.openDocument(feature, true, string);
            featureFrame.showButtonPanel(true);
        } else {
            this.dockMgr.removeFrame(string);
        }
    }

    public void popOutTab() {
        FeatureDocument featureDocument = (FeatureDocument)this.getActiveDocument();
        if (featureDocument != null) {
            Feature feature = featureDocument.getFeature();
            featureDocument.resetFeatureToNull();
            this.closeDocument(featureDocument.getName());
            if (!this.isDocumentOpened(featureDocument.getName())) {
                final FeatureFrame featureFrame = new FeatureFrame(feature, true);
                featureFrame.setKey(featureDocument.getName());
                featureFrame.setInitIndex(0);
                Dimension dimension = this.lastFloatingWindowDimension;
                featureFrame.getContentPane().setMinimumSize(dimension);
                Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                rectangle.x = (rectangle.x + rectangle.width - dimension.width) / 2;
                rectangle.y = (rectangle.y + rectangle.height - dimension.height) / 2;
                rectangle.height = dimension.height;
                rectangle.width = dimension.width;
                featureFrame.setUndockedBounds(rectangle);
                featureFrame.setInitMode(1);
                this.dockMgr.addFrame((DockableFrame)featureFrame);
                this.dockMgr.activateFrame(featureFrame.getKey());
                AbstractAction abstractAction = new AbstractAction(CteStringBank.Dock_to_Tabs.getI18n()){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CVWorkspace.this.popInTab(featureFrame.getKey());
                    }
                };
                abstractAction.putValue("ShortDescription", CteStringBank.Unfloat.getI18n());
                featureFrame.setFloatingAction(abstractAction);
                featureFrame.setMaximizeAction(this.maximizeAction);
                this.maximizeAction.putValue("ShortDescription", CteStringBank.Maximize.getI18n());
                featureFrame.setAvailableButtons(25);
                featureFrame.showButtonPanel(false);
                featureFrame.getContentPane().setMinimumSize(new Dimension(50, 50));
                featureFrame.setDockable(false);
            }
        }
    }

    public void popOutTab(String string) {
        final FeatureFrame featureFrame = (FeatureFrame)CVDockableFrameManager.getInstance().getDockMgr().getFrame(string);
        this.dockMgr.removeFrame(string);
        featureFrame.setInitIndex(0);
        Dimension dimension = this.lastFloatingWindowDimension;
        featureFrame.getContentPane().setMinimumSize(dimension);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        rectangle.x = (rectangle.x + rectangle.width - dimension.width) / 2;
        rectangle.y = (rectangle.y + rectangle.height - dimension.height) / 2;
        rectangle.height = dimension.height;
        rectangle.width = dimension.width;
        featureFrame.setUndockedBounds(rectangle);
        featureFrame.setInitMode(1);
        this.dockMgr.addFrame((DockableFrame)featureFrame);
        AbstractAction abstractAction = new AbstractAction(CteStringBank.Dock_to_Tabs.getI18n()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.popInTab(featureFrame.getKey());
            }
        };
        abstractAction.putValue("ShortDescription", CteStringBank.Unfloat.getI18n());
        featureFrame.setFloatingAction(abstractAction);
        featureFrame.setMaximizeAction(this.maximizeAction);
        this.maximizeAction.putValue("ShortDescription", CteStringBank.Maximize.getI18n());
        featureFrame.setAvailableButtons(25);
        featureFrame.showButtonPanel(false);
        featureFrame.getContentPane().setMinimumSize(new Dimension(50, 50));
        featureFrame.setDockable(true);
    }

    public void fullScreenOnly() {
        FeatureDocument featureDocument = (FeatureDocument)this.getActiveDocument();
        if (featureDocument != null) {
            Feature feature = featureDocument.getFeature();
            featureDocument.resetFeatureToNull();
            this.closeDocument(featureDocument.getName());
            if (!this.isDocumentOpened(featureDocument.getName())) {
                FeatureFrame featureFrame = new FeatureFrame(feature, true);
                featureFrame.setInitIndex(0);
                featureFrame.setInitMode(4);
                featureFrame.setInitSide(1);
                this.dockMgr.addFrame((DockableFrame)featureFrame);
                this.dockMgr.activateFrame(featureFrame.getKey());
                this.dockMgr.maximizeFrame(featureFrame.getKey());
                featureFrame.setAvailableButtons(1);
                featureFrame.showButtonPanel(false);
            }
        }
    }

    public void maximizeTab() {
        FeatureDocument featureDocument = (FeatureDocument)this.getActiveDocument();
        if (this.dockMgr.getFrame(this.dockMgr.getActiveFrameKey()) != null && !this.dockMgr.getActiveFrameKey().equals(Feature.FeatureType.COMMCELL_BROWSER.name()) && !this.dockMgr.getActiveFrameKey().equals(Feature.FeatureType.TASK.name())) {
            final FeatureFrame featureFrame = (FeatureFrame)this.dockMgr.getFrame(this.dockMgr.getActiveFrameKey());
            if (this.dockMgr.getFrame(this.dockMgr.getMaximizedFrameKey()) != null) {
                this.popInTab(this.dockMgr.getMaximizedFrameKey());
            }
            featureFrame.setInitIndex(0);
            featureFrame.setInitMode(4);
            featureFrame.setInitSide(1);
            featureFrame.setDockable(true);
            this.dockMgr.activateFrame(featureFrame.getKey());
            this.dockMgr.maximizeFrame(featureFrame.getKey());
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CVWorkspace.this.popInTab(featureFrame.getKey());
                }
            };
            abstractAction.putValue("ShortDescription", CteStringBank.Restore.getI18n());
            featureFrame.setMaximizeAction(abstractAction);
            featureFrame.setAvailableButtons(17);
        } else if (featureDocument != null) {
            Feature feature = featureDocument.getFeature();
            featureDocument.resetFeatureToNull();
            this.closeDocument(featureDocument.getName());
            if (!this.isDocumentOpened(featureDocument.getName())) {
                final FeatureFrame featureFrame = new FeatureFrame(feature, true);
                featureFrame.setInitIndex(0);
                featureFrame.setKey(featureDocument.getName());
                featureFrame.setInitMode(4);
                featureFrame.setInitSide(1);
                featureFrame.setDockable(true);
                this.dockMgr.addFrame((DockableFrame)featureFrame);
                this.dockMgr.activateFrame(featureFrame.getKey());
                this.dockMgr.maximizeFrame(featureFrame.getKey());
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        CVWorkspace.this.popInTab(featureFrame.getKey());
                    }
                };
                abstractAction.putValue("ShortDescription", CteStringBank.Restore.getI18n());
                featureFrame.setMaximizeAction(abstractAction);
                featureFrame.setAvailableButtons(17);
                featureFrame.showButtonPanel(false);
            }
        }
    }

    private void dockTab(IDocumentPane iDocumentPane, String string, int n) {
        FeatureDocument featureDocument = (FeatureDocument)iDocumentPane.getDocument(string);
        if (featureDocument != null) {
            iDocumentPane.closeDocument(string);
            if (!iDocumentPane.isDocumentOpened(string)) {
                FeatureFrame featureFrame = new FeatureFrame(featureDocument.getFeature());
                featureFrame.setInitIndex(0);
                featureFrame.setInitSide(n);
                featureFrame.setInitMode(4);
                this.dockMgr.addFrame((DockableFrame)featureFrame);
                this.dockMgr.activateFrame(featureFrame.getKey());
            }
        }
    }

    private DocumentPane.TabbedPaneCustomizer createTabbedPaneCustomizer() {
        return new DocumentPane.TabbedPaneCustomizer(){

            public void customize(final JideTabbedPane jideTabbedPane) {
                jideTabbedPane.setShowCloseButton(true);
                jideTabbedPane.addChangeListener((ChangeListener)CVWorkspace.this);
                jideTabbedPane.setUseDefaultShowCloseButtonOnTab(false);
                jideTabbedPane.setShowCloseButtonOnTab(true);
                jideTabbedPane.setTabListCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                        this.setText(CVWorkspace.this.getTitleConverter().convert(jideTabbedPane.getTitleAt(n)));
                        this.setIcon(jideTabbedPane.getIconAt(n));
                        return this;
                    }
                });
            }
        };
    }

    private void closeTab(FeatureDocument featureDocument) {
        System.out.println("closeTab() is being called...");
        this.closeDocument(featureDocument.getName());
        System.out.println("closeTab() is done...");
    }

    private void tabToFrame(FeatureDocument featureDocument) {
        this.closeTab(featureDocument);
        if (!this.isDocumentOpened(featureDocument.getName())) {
            this.openFrame(new FeatureFrame(featureDocument.getFeature()));
        }
    }

    private void frameToTab(FeatureFrame featureFrame) {
        this.closeFrame(featureFrame);
        this.openDocument(featureFrame.getFeature(), true);
    }

    private void openFrame(final FeatureFrame featureFrame) {
        featureFrame.setInitIndex(0);
        featureFrame.setInitMode(1);
        featureFrame.setDockable(false);
        featureFrame.setFloatingAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.frameToTab(featureFrame);
            }
        });
        featureFrame.setCloseAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.closeFrame(featureFrame);
            }
        });
        this.dockMgr.addFrame((DockableFrame)featureFrame);
        this.dockMgr.activateFrame(featureFrame.getKey());
    }

    private void closeFrame(FeatureFrame featureFrame) {
        this.dockMgr.removeFrame(featureFrame.getKey());
    }

    public String openDocument(Feature feature, boolean bl, String string) {
        Object object;
        Refreshable refreshable;
        DockableFrame dockableFrame;
        if (!bl) {
            dockableFrame = CVFrame.getInstance().getDockingManager().getFrame(CVFrame.getInstance().getDockingManager().getActiveFrameKey());
            if (dockableFrame instanceof FeatureFrame && ((FeatureFrame)(refreshable = (FeatureFrame)dockableFrame)).getFeature().getFeatureContext().getType().toString().equals(feature.getFeatureContext().getType().toString())) {
                ((FeatureFrame)refreshable).setFeature(feature);
                if (feature.getFeatureContext().getType() == Feature.FeatureType.COMMCELL_SUMMARY) {
                    this.lastActiveSummaryWindow = refreshable.getName();
                }
                return refreshable.getName();
            }
            if (this.lastActiveSummaryWindow != null && feature.getFeatureContext().getType() == Feature.FeatureType.COMMCELL_SUMMARY && (refreshable = CVFrame.getInstance().getDockingManager().getFrame(this.lastActiveSummaryWindow)) instanceof FeatureFrame) {
                ((FeatureFrame)refreshable).setFeature(feature);
                return refreshable.getName();
            }
            refreshable = (FeatureDocument)this.getActiveDocument();
            if (refreshable != null && (!((String)(object = refreshable.getName())).startsWith(feature.getFeatureContext().getType().toString()) || ((FeatureDocument)refreshable).isPinned())) {
                refreshable = null;
            }
            if (refreshable == null && feature.getFeatureContext().getType() == Feature.FeatureType.COMMCELL_SUMMARY && this.lastActiveSummaryWindow != null) {
                refreshable = (FeatureDocument)this.getDocument(this.lastActiveSummaryWindow);
            }
            if (refreshable == null) {
                for (int i = 0; i < this.getDocumentCount(); ++i) {
                    FeatureDocument featureDocument;
                    String string2;
                    if (!this.getDocumentNameAt(i).startsWith(feature.getFeatureContext().getType().toString()) || !(string2 = (featureDocument = (FeatureDocument)this.getDocumentAt(i)).getName()).startsWith(feature.getFeatureContext().getType().toString()) || featureDocument.isPinned()) continue;
                    refreshable = featureDocument;
                    break;
                }
            }
            if (refreshable != null) {
                ((FeatureDocument)refreshable).setFeature(feature);
                this.updateDocument(refreshable.getName());
                if (this.getActiveDocument() != refreshable) {
                    this.setActiveDocument(refreshable.getName());
                }
                if (feature.getFeatureContext().getType() == Feature.FeatureType.COMMCELL_SUMMARY) {
                    this.lastActiveSummaryWindow = refreshable.getName();
                }
                return refreshable.getName();
            }
        }
        if ((dockableFrame = CVFrame.getInstance().getDockingManager().getFrame(CVFrame.getInstance().getDockingManager().getMaximizedFrameKey())) != null) {
            this.popInTab(dockableFrame.getKey());
            refreshable = new FeatureFrame(feature, true);
            refreshable.setInitIndex(0);
            refreshable.setInitMode(4);
            refreshable.setInitSide(1);
            refreshable.setDockable(true);
            this.dockMgr.addFrame((DockableFrame)refreshable);
            this.dockMgr.activateFrame(refreshable.getKey());
            this.dockMgr.maximizeFrame(refreshable.getKey());
            object = new AbstractAction((FeatureFrame)refreshable){
                final /* synthetic */ FeatureFrame val$ff;
                {
                    this.val$ff = featureFrame;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CVWorkspace.this.popInTab(this.val$ff.getKey());
                }
            };
            object.putValue("ShortDescription", CteStringBank.Restore.getI18n());
            refreshable.setMaximizeAction((Action)object);
            refreshable.setAvailableButtons(17);
            ((FeatureFrame)refreshable).showButtonPanel(false);
            return refreshable.getKey();
        }
        refreshable = string == null ? FeatureDocument.createDocument(feature) : FeatureDocument.createDocument1(feature, string);
        super.openDocument((DocumentComponent)refreshable);
        if (feature.getFeatureContext().getType().getDockSide() == 2 && this.getDocumentGroupCount() == 1) {
            this.newDocumentGroup(refreshable.getName(), 1, 0);
        }
        this.setActiveDocument(refreshable.getName(), true);
        if (feature.getFeatureContext().getType() == Feature.FeatureType.COMMCELL_SUMMARY) {
            this.lastActiveSummaryWindow = refreshable.getName();
        }
        return refreshable.getName();
    }

    public String openDocument(Feature feature, boolean bl) {
        return this.openDocument(feature, bl, null);
    }

    public void openDummyDocument(DummyFeatureDocument dummyFeatureDocument) {
        super.openDocument((DocumentComponent)dummyFeatureDocument);
        if (dummyFeatureDocument.getFrameInfo().getContext().getType().getDockSide() == 2 && this.getDocumentGroupCount() == 1) {
            this.newDocumentGroup(dummyFeatureDocument.getName(), 1, 0);
        }
        this.setActiveDocument(dummyFeatureDocument.getName(), false);
    }

    protected IDocumentGroup createDocumentGroup() {
        IDocumentGroup iDocumentGroup = super.createDocumentGroup();
        if (iDocumentGroup instanceof JideTabbedPane) {
            ((JideTabbedPane)iDocumentGroup).addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                        if (!_autohideAll) {
                            CVWorkspace.access$602(CVWorkspace.this.dockMgr.getLayoutRawData());
                            CVWorkspace.this.dockMgr.autohideAll();
                            _autohideAll = true;
                        } else {
                            if (_fullScreenLayout != null) {
                                CVWorkspace.this.dockMgr.setLayoutRawData(_fullScreenLayout);
                            }
                            _autohideAll = false;
                        }
                        if (CVWorkspace.this.getActiveDocument() == null) {
                            return;
                        }
                        Component component = CVWorkspace.this.getActiveDocument().getLastFocusedComponent();
                        if (component != null) {
                            component.requestFocusInWindow();
                        }
                    }
                }
            });
        }
        return iDocumentGroup;
    }

    public void setLastActiveSummaryWindow(String string) {
        this.lastActiveSummaryWindow = string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
        for (ChangeListener changeListener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void createFloatFrame(Feature feature, String string) {
        final FeatureFrame featureFrame = new FeatureFrame(feature, true);
        featureFrame.setKey(string);
        featureFrame.setInitIndex(0);
        Dimension dimension = new Dimension(400, 400);
        featureFrame.getContentPane().setMinimumSize(dimension);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        rectangle.x = (rectangle.x + rectangle.width - dimension.width) / 2;
        rectangle.y = (rectangle.y + rectangle.height - dimension.height) / 2;
        rectangle.height = dimension.height;
        rectangle.width = dimension.width;
        featureFrame.setUndockedBounds(rectangle);
        featureFrame.setInitMode(1);
        if (feature.getFeatureContext().getType().equals((Object)Feature.FeatureType.USER_COMMUNICATOR)) {
            if (EventQueue.isDispatchThread()) {
                try {
                    rectangle.x = (rectangle.x + rectangle.width - 350) / 2;
                    rectangle.y = (rectangle.y + rectangle.height - 400) / 2;
                    rectangle.height = 400;
                    rectangle.width = 350;
                    featureFrame.setUndockedBounds(rectangle);
                    featureFrame.setShowContextMenu(false);
                    featureFrame.setAvailableButtons(1);
                    featureFrame.showButtonPanel(false);
                    featureFrame.getContentPane().setMinimumSize(new Dimension(300, 300));
                    featureFrame.setDockable(false);
                    this.dockMgr.addFrame((DockableFrame)featureFrame);
                    this.dockMgr.activateFrame(featureFrame.getKey());
                    if (feature.getFeatureContext().getType().equals((Object)Feature.FeatureType.USER_COMMUNICATOR)) {
                        ((ResizablePanel)featureFrame.getParent().getParent().getParent()).setBorder((Border)new LineBorder(Color.WHITE, 1));
                        ((ContainerContainer)((ResizablePanel)featureFrame.getParent().getParent().getParent()).getComponents()[0]).setBorder((Border)new LineBorder(Color.WHITE, 0));
                    }
                    return;
                }
                catch (Exception exception) {}
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                            rectangle.x = (rectangle.x + rectangle.width - 350) / 2;
                            rectangle.y = (rectangle.y + rectangle.height - 400) / 2;
                            rectangle.height = 400;
                            rectangle.width = 350;
                            featureFrame.setUndockedBounds(rectangle);
                            featureFrame.setShowContextMenu(false);
                            featureFrame.setAvailableButtons(1);
                            featureFrame.showButtonPanel(false);
                            featureFrame.getContentPane().setMinimumSize(new Dimension(300, 300));
                            featureFrame.setDockable(false);
                            CVWorkspace.this.dockMgr.addFrame((DockableFrame)featureFrame);
                            CVWorkspace.this.dockMgr.activateFrame(featureFrame.getKey());
                            if (featureFrame.getFeature().getFeatureContext().getType().equals((Object)Feature.FeatureType.USER_COMMUNICATOR)) {
                                ((ResizablePanel)featureFrame.getParent().getParent().getParent()).setBorder((Border)new LineBorder(Color.WHITE, 1));
                                ((ContainerContainer)((ResizablePanel)featureFrame.getParent().getParent().getParent()).getComponents()[0]).setBorder((Border)new LineBorder(Color.WHITE, 0));
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                return;
            }
        }
        this.dockMgr.addFrame((DockableFrame)featureFrame);
        this.dockMgr.activateFrame(featureFrame.getKey());
        AbstractAction abstractAction = new AbstractAction(CteStringBank.Dock_to_Tabs.getI18n()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CVWorkspace.this.popInTab(featureFrame.getKey());
            }
        };
        abstractAction.putValue("ShortDescription", CteStringBank.Unfloat.getI18n());
        featureFrame.setAutohideAction(new AbstractAction(CteStringBank.Minimize.getI18n()){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FeatureFrame featureFrame = (FeatureFrame)CVWorkspace.this.dockMgr.getFrame(CVWorkspace.this.dockMgr.getActiveFrameKey());
                if (featureFrame != null) {
                    CVWorkspace.this.dockMgr.removeFrame(featureFrame.getKey());
                    if (CVWorkspace.this.dockMgr.getFrame(featureFrame.getKey()) == null) {
                        FeatureFrame featureFrame2 = CVWorkspace.this.createMinimisedFrame(featureFrame.getFeature(), featureFrame.getName());
                        CVDockableFrameManager.getInstance().showFrame(featureFrame2, false);
                    }
                }
            }
        });
        featureFrame.setMaximizeAction(this.maximizeAction);
        featureFrame.setFloatingAction(abstractAction);
        this.maximizeAction.putValue("ShortDescription", CteStringBank.Maximize.getI18n());
        featureFrame.setAvailableButtons(29);
        featureFrame.setButtonsOrder(new int[]{1, 8, 16, 4});
        featureFrame.showButtonPanel(false);
        featureFrame.getContentPane().setMinimumSize(new Dimension(400, 400));
        featureFrame.setDockable(false);
    }

    public void setActiveDocument(String string, boolean bl) {
        if (this.getActiveDocumentName() == null) {
            super.setActiveDocument(string, bl);
        } else if (string != null && !this.getActiveDocumentName().equalsIgnoreCase(string)) {
            super.setActiveDocument(string, bl);
        }
    }

    static /* synthetic */ byte[] access$602(byte[] byArray) {
        _fullScreenLayout = byArray;
        return byArray;
    }
}

