/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.component;

import commvault.cte.CteStringBank;
import commvault.cte.component.BasicJRootPane;
import commvault.cte.component.CVFrame;
import commvault.cte.component.GlassPane;
import commvault.cte.help.IHelpAction;
import commvault.cte.util.EnumUtil;
import commvault.cte.util.Logger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.FocusManager;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class BasicJDialog
extends JDialog
implements IHelpAction {
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final String OK = CteStringBank.OK.getI18n();
    public static final String CANCEL = CteStringBank.Cancel.getI18n();
    public static final String HELP = CteStringBank.Help.getI18n();
    public static final String SCHEDULE = CteStringBank.Schedule.getI18n();
    public static String ENUM_KEY = "enumValue";
    private Enum<?> titleEnum = null;
    private JRootPane rootPane = new BasicJRootPane();

    public BasicJDialog() {
        super((Frame)SwingUtilities.getAncestorOfClass(Frame.class, FocusManager.getCurrentManager().getFocusOwner()));
        this.setRootPane(this.rootPane);
        this.init();
    }

    public BasicJDialog(Dialog dialog) {
        super(dialog);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    public BasicJDialog(Window window) {
        super(window);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    public BasicJDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    public BasicJDialog(Dialog dialog, Enum<?> enum_) {
        this(dialog, enum_, false);
    }

    public BasicJDialog(Dialog dialog, Enum<?> enum_, boolean bl) {
        super(dialog, EnumUtil.getI18n(enum_), bl);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.setTitle(enum_);
        this.init();
    }

    public BasicJDialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public BasicJDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    public BasicJDialog(Frame frame) {
        super(frame);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    public BasicJDialog(Frame frame, Enum<?> enum_) {
        this(frame, enum_, false);
    }

    public BasicJDialog(Frame frame, Enum<?> enum_, boolean bl) {
        super(frame, EnumUtil.getI18n(enum_), bl);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.setTitle(enum_);
        this.init();
    }

    public BasicJDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    public BasicJDialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public BasicJDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.setRootPane(this.rootPane);
        this.setGlassPane(new GlassPane());
        this.init();
    }

    private void init() {
        if (Logger.instance().isLogging(Logger.INFO)) {
            Logger.instance().println(Logger.INFO, "Initializing Dialog: " + this.getClass().getName());
        }
    }

    public void setBusyCursor() {
        this.getGlassPane().setVisible(true);
    }

    public void resetCursor() {
        this.getGlassPane().setVisible(false);
    }

    @Override
    public void dispose() {
        this.rootPane = null;
        super.dispose();
        if (Logger.instance().isLogging(Logger.INFO)) {
            Logger.instance().println(Logger.INFO, "Disposing Dialog: " + this.getClass().getName());
        }
    }

    public void setFullBusyCursor() {
        this.setCursor(WAIT_CURSOR);
    }

    public void resetFullBusyCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void setPartialWaitCursor() {
        this.setCursor(CVFrame.waitPointCursor);
    }

    public void resetPartialWaitCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void helpActionPerformed() {
        this.actionPerformed(new ActionEvent(this, 0, HELP));
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setTitle(Enum<?> enum_) {
        this.setTitle(enum_, null);
    }

    public void setTitle(Enum<?> enum_, String string) {
        this.titleEnum = enum_;
        if (string != null) {
            this.setTitle(string);
        } else {
            this.setTitle(EnumUtil.getI18n(enum_));
        }
    }

    public Enum<?> getTitleEnum() {
        return this.titleEnum;
    }

    @Override
    public void show() {
        if (Logger.instance().isLogging(Logger.INFO)) {
            Logger.instance().println(Logger.INFO, "Dialog: " + this.getClass().getName());
        }
        super.show();
    }

    @Override
    public void setVisible(boolean bl) {
        if (Logger.instance().isLogging(Logger.INFO)) {
            Logger.instance().println(Logger.INFO, "Dialog: " + this.getClass().getName());
        }
        super.setVisible(bl);
    }

    protected void setMinimumResizableSize(final Component component, final int n, final int n2) {
        if (component != null) {
            component.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    int n3 = component.getWidth();
                    int n22 = component.getHeight();
                    if (n3 < n) {
                        n3 = n;
                        component.setSize(n3, n22);
                    }
                    if (n22 < n2) {
                        n22 = n2;
                        component.setSize(n3, n22);
                    }
                }
            });
        }
    }
}

