/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.xml;

import commvault.cte.common.FastStack;
import commvault.cte.common.xml.AbstractDOMStreamReader;
import commvault.cte.common.xml.JDOMNamespaceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.Namespace;
import org.jdom2.Text;

public class JDOMStreamReader
extends AbstractDOMStreamReader<Element, Integer> {
    private Content content;
    private FastStack<Map<String, Namespace>> namespaceStack = new FastStack();
    private List<Namespace> namespaces = new ArrayList<Namespace>();
    private Map<String, Namespace> prefix2decNs;
    private JDOMNamespaceContext namespaceContext = new JDOMNamespaceContext();

    public JDOMStreamReader(Element element) {
        super(new AbstractDOMStreamReader.ElementFrame<Element, Integer>(element, null, -1));
        this.setupNamespaces(element);
    }

    public JDOMStreamReader(Document document) {
        this(document.getRootElement());
    }

    private void setupNamespaces(Element element) {
        this.namespaceContext.setElement(element);
        if (this.prefix2decNs != null) {
            this.namespaceStack.push(this.prefix2decNs);
        }
        this.prefix2decNs = new HashMap<String, Namespace>();
        this.namespaces.clear();
        Namespace namespace = element.getAdditionalNamespaces().iterator();
        while (namespace.hasNext()) {
            this.declare((Namespace)namespace.next());
        }
        namespace = element.getNamespace();
        if (this.shouldDeclare(namespace)) {
            this.declare(namespace);
        }
        Iterator iterator = element.getAttributes().iterator();
        while (iterator.hasNext()) {
            namespace = ((Attribute)iterator.next()).getNamespace();
            if (!this.shouldDeclare(namespace)) continue;
            this.declare(namespace);
        }
    }

    private void declare(Namespace namespace) {
        this.prefix2decNs.put(namespace.getPrefix(), namespace);
        this.namespaces.add(namespace);
    }

    private boolean shouldDeclare(Namespace namespace) {
        if (namespace == Namespace.XML_NAMESPACE) {
            return false;
        }
        if (namespace == Namespace.NO_NAMESPACE && this.getDeclaredURI("") == null) {
            return false;
        }
        String string = this.getDeclaredURI(namespace.getPrefix());
        return string == null || !string.equals(namespace.getURI());
    }

    private String getDeclaredURI(String string) {
        for (int i = this.namespaceStack.size() - 1; i == 0; --i) {
            Map map = (Map)this.namespaceStack.get(i);
            Namespace namespace = (Namespace)map.get(string);
            if (namespace == null) continue;
            return namespace.getURI();
        }
        return null;
    }

    @Override
    protected void endElement() {
        if (this.namespaceStack.size() > 0) {
            this.prefix2decNs = this.namespaceStack.pop();
        }
    }

    public Element getCurrentElement() {
        return (Element)this.getCurrentFrame().getElement();
    }

    @Override
    protected AbstractDOMStreamReader.ElementFrame<Element, Integer> getChildFrame() {
        int n = (Integer)this.getCurrentFrame().getCurrentChild();
        return new AbstractDOMStreamReader.ElementFrame<Element, Integer>((Element)this.getCurrentElement().getContent(n), this.getCurrentFrame(), -1);
    }

    @Override
    protected boolean hasMoreChildren() {
        int n = (Integer)this.getCurrentFrame().getCurrentChild();
        return n < this.getCurrentElement().getContentSize() - 1;
    }

    @Override
    protected int nextChild() {
        int n = (Integer)this.getCurrentFrame().getCurrentChild();
        this.getCurrentFrame().setCurrentChild(++n);
        this.content = this.getCurrentElement().getContent(n);
        if (this.content instanceof Text) {
            return 4;
        }
        if (this.content instanceof Element) {
            this.setupNamespaces((Element)this.content);
            return 1;
        }
        if (this.content instanceof CDATA) {
            return 4;
        }
        if (this.content instanceof Comment) {
            return 4;
        }
        if (this.content instanceof EntityRef) {
            return 9;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return ((Text)this.content).getText();
    }

    @Override
    public String getNamespaceURI(String string) {
        return this.getCurrentElement().getNamespace(string).getURI();
    }

    @Override
    public String getAttributeValue(String string, String string2) {
        return this.getCurrentElement().getAttributeValue(string2, Namespace.getNamespace((String)string));
    }

    @Override
    public int getAttributeCount() {
        return this.getCurrentElement().getAttributes().size();
    }

    Attribute getAttribute(int n) {
        return (Attribute)this.getCurrentElement().getAttributes().get(n);
    }

    @Override
    public QName getAttributeName(int n) {
        Attribute attribute = this.getAttribute(n);
        return new QName(attribute.getNamespaceURI(), attribute.getName(), attribute.getNamespacePrefix());
    }

    @Override
    public String getAttributeNamespace(int n) {
        return this.getAttribute(n).getNamespaceURI();
    }

    @Override
    public String getAttributeLocalName(int n) {
        return this.getAttribute(n).getName();
    }

    @Override
    public String getAttributePrefix(int n) {
        return this.getAttribute(n).getNamespacePrefix();
    }

    @Override
    public String getAttributeType(int n) {
        return this.getAttribute(n).getAttributeType().toString();
    }

    @Override
    public String getAttributeValue(int n) {
        return this.getAttribute(n).getValue();
    }

    @Override
    public boolean isAttributeSpecified(int n) {
        return this.getAttribute(n).getValue() != null;
    }

    @Override
    public int getNamespaceCount() {
        return this.namespaces.size();
    }

    Namespace getNamespace(int n) {
        return this.namespaces.get(n);
    }

    @Override
    public String getNamespacePrefix(int n) {
        return this.getNamespace(n).getPrefix();
    }

    @Override
    public String getNamespaceURI(int n) {
        return this.getNamespace(n).getURI();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public String getText() {
        return this.content.getValue();
    }

    @Override
    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public QName getName() {
        Element element = this.getCurrentElement();
        return new QName(element.getNamespaceURI(), element.getName(), element.getNamespacePrefix());
    }

    @Override
    public String getLocalName() {
        return this.getCurrentElement().getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.getCurrentElement().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.getCurrentElement().getNamespacePrefix();
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException();
    }
}

