/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.wsdl;

import commvault.cte.common.schema.SchemaElement;
import commvault.cte.common.schema.SchemaType;
import commvault.cte.common.schema.SchemaTypeSystem;
import commvault.cte.common.wsdl.Binding;
import commvault.cte.common.wsdl.BindingProtocol;
import commvault.cte.common.wsdl.Message;
import commvault.cte.common.wsdl.PortType;
import commvault.cte.common.wsdl.Service;
import commvault.cte.common.wsdl.WSDLDocument;
import commvault.cte.common.wsdl.WSDLException;
import commvault.cte.common.wsdl.WSDLImport;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class WSDLSystem {
    private Map<String, WSDLDocument> wsdlDocuments = new HashMap<String, WSDLDocument>();
    private WSDLDocument root;
    protected SchemaTypeSystem sts;
    private Map<QName, Message> messages = new HashMap<QName, Message>();
    private Map<QName, PortType> portTypes = new HashMap<QName, PortType>();
    private Map<QName, Binding> bindings = new HashMap<QName, Binding>();
    private Map<QName, Service> services = new HashMap<QName, Service>();
    private Map<BindingProtocol, List<Binding>> protocolBindings = new HashMap<BindingProtocol, List<Binding>>();

    public static void main(String[] stringArray) throws Exception {
        WSDLSystem.parse(new URL("http://www.restfulwebservices.net/rest/BibleASVService.svc?wsdl"));
    }

    public static WSDLSystem parse(URL uRL) throws Exception {
        return WSDLSystem.parse(uRL.openStream());
    }

    public static WSDLSystem parse(Reader reader) throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(reader);
        return new WSDLSystem(document);
    }

    public static WSDLSystem parse(InputStream inputStream) throws Exception {
        SAXBuilder sAXBuilder = new SAXBuilder();
        Document document = sAXBuilder.build(inputStream);
        WSDLSystem wSDLSystem = new WSDLSystem(document);
        inputStream.close();
        return wSDLSystem;
    }

    private WSDLSystem(Document document) throws Exception {
        WSDLDocument wSDLDocument;
        this.root = wSDLDocument = new WSDLDocument(document, this);
        this.importWSDLDocument(wSDLDocument);
        this.parseSchema();
        this.parseMessages();
        this.parsePortTypes();
        this.parseBindings();
        this.buildProtocolBindings();
        this.parseServices();
    }

    private void importWSDLDocument(WSDLDocument wSDLDocument) throws Exception {
        this.wsdlDocuments.put(wSDLDocument.getTargetNamespace().getURI(), wSDLDocument);
        for (WSDLImport wSDLImport : wSDLDocument.getImports()) {
            if (this.wsdlDocuments.containsKey(wSDLImport.getNamespace())) continue;
            WSDLDocument wSDLDocument2 = WSDLDocument.parse(new URL(wSDLImport.getLocation()), this);
            if (wSDLDocument2.getTargetNamespace().getURI().equals(wSDLImport.getNamespace())) {
                this.importWSDLDocument(wSDLDocument2);
                continue;
            }
            throw new WSDLException(String.format("imported namespace [%s] from url [%s] does not match actual namespace [%s]", wSDLImport.getNamespace(), wSDLImport.getLocation(), wSDLDocument2.getTargetNamespace().getURI()));
        }
    }

    private void parseSchema() throws Exception {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (WSDLDocument wSDLDocument : this.wsdlDocuments.values()) {
            arrayList.addAll(wSDLDocument.getSchema());
        }
        this.sts = new SchemaTypeSystem(arrayList.toArray(new Element[0]));
    }

    protected void parseMessages() throws Exception {
        for (WSDLDocument wSDLDocument : this.wsdlDocuments.values()) {
            wSDLDocument.parseMessages(this.messages);
        }
    }

    protected void parsePortTypes() throws Exception {
        for (WSDLDocument wSDLDocument : this.wsdlDocuments.values()) {
            wSDLDocument.parsePortTypes(this.portTypes);
        }
    }

    protected void parseBindings() throws Exception {
        for (WSDLDocument wSDLDocument : this.wsdlDocuments.values()) {
            wSDLDocument.parseBindings(this.bindings);
        }
    }

    protected void buildProtocolBindings() throws Exception {
        for (Binding binding : this.bindings.values()) {
            List<Binding> list = this.protocolBindings.get((Object)binding.getProtocol());
            if (list == null) {
                list = new ArrayList<Binding>();
                this.protocolBindings.put(binding.getProtocol(), list);
            }
            list.add(binding);
        }
    }

    protected void parseServices() throws Exception {
        for (WSDLDocument wSDLDocument : this.wsdlDocuments.values()) {
            wSDLDocument.parseServices(this.services);
        }
    }

    public Message[] getAllMessages() {
        return this.messages.values().toArray(new Message[0]);
    }

    public Message getMessage(QName qName) {
        return this.messages.get(qName);
    }

    public PortType[] getAllPortTypes() {
        return this.portTypes.values().toArray(new PortType[0]);
    }

    public PortType getPortType(QName qName) {
        return this.portTypes.get(qName);
    }

    public Binding[] getAllBindings() {
        return this.bindings.values().toArray(new Binding[0]);
    }

    public Binding getBinding(QName qName) {
        return this.bindings.get(qName);
    }

    public List<Binding> getBindings(BindingProtocol bindingProtocol) {
        return this.protocolBindings.get((Object)bindingProtocol);
    }

    protected SchemaElement findElement(QName qName) {
        if (this.sts != null && this.sts.getGlobalElements() != null) {
            for (SchemaElement schemaElement : this.sts.getGlobalElements()) {
                if (schemaElement.getName() == null || !schemaElement.getName().equals(qName)) continue;
                return schemaElement;
            }
        }
        return null;
    }

    protected SchemaType findType(QName qName) {
        if (this.sts != null && this.sts.getGlobalTypes() != null) {
            for (SchemaType schemaType : this.sts.getGlobalTypes()) {
                if (schemaType.getName() == null || !schemaType.getName().equals(qName)) continue;
                return schemaType;
            }
        }
        return null;
    }

    public SchemaTypeSystem getSchemaTypeSystem() {
        return this.sts;
    }

    public WSDLDocument getRoot() {
        return this.root;
    }
}

