/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.wsdl;

import commvault.cte.common.wsdl.Binding;
import commvault.cte.common.wsdl.Service;
import commvault.cte.common.wsdl.WSDLDocument;
import commvault.cte.common.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.jdom2.Element;

public class Port {
    private WSDLDocument wsdlDocument;
    private Service service;
    private Element element;
    private QName name;
    private Binding binding;
    private String location;

    protected Port(WSDLDocument wSDLDocument, Service service, Element element) throws Exception {
        this.wsdlDocument = wSDLDocument;
        this.service = service;
        this.element = element;
        this.name = this.wsdlDocument.retrieveName(element.getAttributeValue("name"));
        QName qName = this.wsdlDocument.retrieveName(element.getAttributeValue("binding"));
        this.binding = this.wsdlDocument.getBinding(qName);
        if (this.binding == null) {
            throw new WSDLException(String.format("cannot retrieve binding %s for port %s", qName, this.name));
        }
        this.binding.addPort(this);
    }

    public QName getName() {
        return this.name;
    }

    public Service getService() {
        return this.service;
    }

    public String getLocation() {
        return this.location;
    }

    protected void parse() {
        Element element = this.element.getChild("address", this.binding.getNamespace());
        if (element != null) {
            this.location = element.getAttributeValue("location");
        }
    }
}

