/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.workflow;

import commvault.cte.common.workflow.CompletionStatus;

public enum ProcessStatus {
    RUNNING(1, "RUNNING", false, false, false, true, true, CompletionStatus.INTERRUPTED),
    PENDING(2, "PENDING", false, true, true, true, true, CompletionStatus.FAILED),
    WAITING(3, "WAITING", false, true, true, true, true, CompletionStatus.COMPLETED),
    COMPLETED(4, "COMPLETED", true, true, false, false, false, CompletionStatus.COMPLETED),
    SUSPENDED(5, "SUSPENDED", false, true, true, false, true, CompletionStatus.STOPPED),
    KILL_PENDING(6, "KILL PENDING", false, true, false, false, false, CompletionStatus.KILLED),
    SUSPEND_PENDING(7, "SUSPEND PENDING", false, true, false, false, false, CompletionStatus.STOPPED),
    INTERRUPT_PENDING(8, "INTERRUPT PENDING", false, true, false, false, false, CompletionStatus.INTERRUPTED),
    FAILED(10, "FAILED", true, true, false, false, false, CompletionStatus.FAILED),
    KILLED(11, "KILLED", true, true, false, false, false, CompletionStatus.KILLED),
    COMPLETED_PARTIAL(12, "COMPLETED WITH ERRRORS", true, true, false, false, false, CompletionStatus.COMPLETED_PARTIAL),
    QUEUED(15, "QUEUED", false, false, true, true, true, CompletionStatus.INTERRUPTED),
    SKIPPED(25, "SKIPPED", true, true, false, false, false, CompletionStatus.SKIPPED);

    private int flag;
    private String text;
    private CompletionStatus completionStatus;
    private boolean jobComplete;
    private boolean attemptComplete;
    private boolean resumable;
    private boolean suspendable;
    private boolean killable;

    private ProcessStatus(int n2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, CompletionStatus completionStatus) {
        this.flag = n2;
        this.text = string2;
        this.jobComplete = bl;
        this.attemptComplete = bl2;
        this.resumable = bl3;
        this.completionStatus = completionStatus;
        this.suspendable = bl4;
        this.killable = bl5;
    }

    public int toInt() {
        return this.flag;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public boolean isJobComplete() {
        return this.jobComplete;
    }

    public boolean isAttemptComplete() {
        return this.attemptComplete;
    }

    public boolean isResumable() {
        return this.resumable;
    }

    public boolean isSuspendable() {
        return this.suspendable;
    }

    public boolean isKillable() {
        return this.killable;
    }

    public String toString() {
        return this.text;
    }

    public static ProcessStatus fromInt(int n) {
        for (ProcessStatus processStatus : ProcessStatus.values()) {
            if (processStatus.toInt() != n) continue;
            return processStatus;
        }
        return null;
    }
}

