/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.ui;

import commvault.cte.CteStringBank;
import commvault.cte.component.CVFrame;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.Utilities;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ChangeUserAccountDialog
extends PropertyDialog
implements ItemListener {
    static final String prefix = "cte.common.ui.ChangeUserAccountDialog";
    private JCheckBox userOptionCheckBox = new JCheckBox(CteStringBank.Use_This_Account.getI18n());
    private JLabel nameFieldLabel = new JLabel(CteStringBank.User_Name7.getI18n());
    private JTextField userNameField = new JTextField(30);
    private JLabel passwordLabel = new JLabel(CteStringBank.Password7.getI18n());
    private JTextField passwordField = new JPasswordField();
    private JLabel confirmPasswordLabel = new JLabel(CteStringBank.Confirm_Password7.getI18n());
    private JTextField confirmPasswordField = new JPasswordField();
    private boolean isCancelled = false;
    String m_helpId;

    public ChangeUserAccountDialog(String string) {
        this(string, null);
    }

    public ChangeUserAccountDialog(String string, String string2) {
        super((Frame)((Object)CVFrame.getInstance()), CteStringBank.Change_User_Account.getI18n(), true);
        this.m_helpId = string2;
        this.init(string, false);
    }

    public ChangeUserAccountDialog(String string, boolean bl) {
        this(string, bl, null);
    }

    public ChangeUserAccountDialog(String string, boolean bl, JDialog jDialog) {
        super(jDialog, "", true);
        if (bl) {
            this.setTitle(CteStringBank.NetworkPassword.getI18n());
        } else {
            this.setTitle(CteStringBank.Change_User_Account.getI18n());
        }
        this.init(string, bl);
    }

    private void init(String string, boolean bl) {
        this.setResizable(true);
        this.contentPane.removeAll();
        this.contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(5, 5, 5, 40);
        this.userOptionCheckBox.setMnemonic('U');
        this.userOptionCheckBox.addItemListener(this);
        if (bl) {
            this.getContentPane().add((Component)new JLabel(CteStringBank.IncorrectPasswordOrUser.getI18n()), Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 5, 5)));
            this.nameFieldLabel.setText(CteStringBank.ConnectAs.getI18n());
            this.getContentPane().add((Component)this.nameFieldLabel, Utilities.getConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 40, 5, 5)));
            this.userOptionCheckBox.setSelected(true);
        } else {
            this.getContentPane().add((Component)this.userOptionCheckBox, Utilities.getConstraints(gridBagConstraints, 0, 1, 0, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 5, 5)));
            this.getContentPane().add((Component)this.nameFieldLabel, Utilities.getConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 40, 5, 5)));
        }
        this.nameFieldLabel.setDisplayedMnemonic('U');
        this.nameFieldLabel.setLabelFor(this.userNameField);
        this.getContentPane().add((Component)this.userNameField, Utilities.getConstraints(gridBagConstraints, 1, 2, 0, 1, 1.0, 0.0, 17, 1, insets));
        this.getContentPane().add((Component)this.passwordLabel, Utilities.getConstraints(gridBagConstraints, 0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 40, 5, 5)));
        this.passwordLabel.setDisplayedMnemonic('P');
        this.passwordLabel.setLabelFor(this.passwordField);
        this.getContentPane().add((Component)this.passwordField, Utilities.getConstraints(gridBagConstraints, 1, 3, 0, 1, 1.0, 0.0, 17, 1, insets));
        this.getContentPane().add((Component)this.confirmPasswordLabel, Utilities.getConstraints(gridBagConstraints, 0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 40, 5, 5)));
        this.confirmPasswordLabel.setDisplayedMnemonic('C');
        this.confirmPasswordLabel.setLabelFor(this.confirmPasswordField);
        this.getContentPane().add((Component)this.confirmPasswordField, Utilities.getConstraints(gridBagConstraints, 1, 4, 0, 1, 1.0, 0.0, 17, 1, insets));
        JPanel jPanel = new JPanel(new FlowLayout(2, 5, 0));
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        jPanel.add(this.helpButton);
        this.okButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.cancelButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.helpButton.setPreferredSize(Utilities.STANDARD_BUTTON_DIMENSION);
        this.contentPane.add((Component)jPanel, Utilities.getConstraints(gridBagConstraints, -1, -1, 0, 0, 1.0, 0.0, 10, 2, new Insets(15, 5, 5, 5)));
        this.setLocationRelativeTo((Component)((Object)CVFrame.getInstance()));
        if (!bl) {
            if (string == null) {
                this.userOptionCheckBox.setSelected(false);
            } else {
                this.userOptionCheckBox.setSelected(true);
                this.userNameField.setText(string);
            }
        }
        this.itemStateChanged(null);
        this.initHelp("MainHelp");
        this.createHelpLink();
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    public boolean checkValidity() {
        if (!this.userOptionCheckBox.isSelected()) {
            return true;
        }
        if (this.userNameField.getText().trim().length() == 0) {
            Utilities.showErrorMessage(this, CteStringBank.Please_enter_a_user_name.getI18n());
            return false;
        }
        if (this.userNameField.getText().trim().indexOf(47) != -1) {
            Utilities.showErrorMessage(this, CteStringBank.cte_common_ui_ChangeUserAccountDialog_impersonationMsg.getI18n());
            return false;
        }
        if (!this.passwordField.getText().equals(this.confirmPasswordField.getText())) {
            Utilities.showErrorMessage(this, CteStringBank.Passwords_do_not_match.getI18n());
            return false;
        }
        if (this.passwordField.getText().trim().length() == 0) {
            Utilities.showErrorMessage(this, CteStringBank.cte_common_ui_ChangeUserAccountDialog_emptyPass.getI18n());
            return false;
        }
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = true;
        if (!this.userOptionCheckBox.isSelected()) {
            bl = false;
        }
        this.nameFieldLabel.setEnabled(bl);
        this.passwordLabel.setEnabled(bl);
        this.confirmPasswordLabel.setEnabled(bl);
        this.userNameField.setEnabled(bl);
        this.passwordField.setEnabled(bl);
        this.confirmPasswordField.setEnabled(bl);
    }

    public boolean isNoUserOptionSelected() {
        return !this.userOptionCheckBox.isSelected();
    }

    @Override
    public void setFirstFocus() {
        if (this.userNameField.isEnabled()) {
            this.userNameField.requestFocus();
        } else {
            this.okButton.requestFocus();
        }
    }

    public String getPassword() {
        return this.passwordField.getText().trim();
    }

    @Override
    public void okButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.checkValidity()) {
            this.setVisible(true);
            return;
        }
        super.okButtonActionPerformed(actionEvent);
    }

    @Override
    public void cancelButtonActionPerformed(ActionEvent actionEvent) {
        super.cancelButtonActionPerformed(actionEvent);
        this.isCancelled = true;
    }

    private void createHelpLink() {
        this.helpId = "english-en-us-main-nt-NO_TOCHEADINGS.txt-ChangeUserAccount";
    }
}

