/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema.util;

import commvault.cte.common.schema.util.GDateBuilder;
import commvault.cte.common.schema.util.GDateSpecification;
import commvault.cte.common.schema.util.GDurationSpecification;
import commvault.cte.common.schema.util.XmlCalendar;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class GDate
implements GDateSpecification,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int MAX_YEAR = 292277265;
    static final int MIN_YEAR = -292275295;
    private transient String _canonicalString;
    private transient String _string;
    private int _bits;
    private int _CY;
    private int _M;
    private int _D;
    private int _h;
    private int _m;
    private int _s;
    private BigDecimal _fs;
    private int _tzsign;
    private int _tzh;
    private int _tzm;
    static final BigDecimal _zero = BigDecimal.valueOf(0L);
    static final BigDecimal _one = BigDecimal.valueOf(1L);
    private static final char[] _tensDigit = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] _onesDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final TimeZone GMTZONE = TimeZone.getTimeZone("GMT");
    private static final TimeZone[] MINUSZONE = new TimeZone[]{TimeZone.getTimeZone("GMT-00:00"), TimeZone.getTimeZone("GMT-01:00"), TimeZone.getTimeZone("GMT-02:00"), TimeZone.getTimeZone("GMT-03:00"), TimeZone.getTimeZone("GMT-04:00"), TimeZone.getTimeZone("GMT-05:00"), TimeZone.getTimeZone("GMT-06:00"), TimeZone.getTimeZone("GMT-07:00"), TimeZone.getTimeZone("GMT-08:00"), TimeZone.getTimeZone("GMT-09:00"), TimeZone.getTimeZone("GMT-10:00"), TimeZone.getTimeZone("GMT-11:00"), TimeZone.getTimeZone("GMT-12:00"), TimeZone.getTimeZone("GMT-13:00"), TimeZone.getTimeZone("GMT-14:00")};
    private static final TimeZone[] PLUSZONE = new TimeZone[]{TimeZone.getTimeZone("GMT+00:00"), TimeZone.getTimeZone("GMT+01:00"), TimeZone.getTimeZone("GMT+02:00"), TimeZone.getTimeZone("GMT+03:00"), TimeZone.getTimeZone("GMT+04:00"), TimeZone.getTimeZone("GMT+05:00"), TimeZone.getTimeZone("GMT+06:00"), TimeZone.getTimeZone("GMT+07:00"), TimeZone.getTimeZone("GMT+08:00"), TimeZone.getTimeZone("GMT+09:00"), TimeZone.getTimeZone("GMT+10:00"), TimeZone.getTimeZone("GMT+11:00"), TimeZone.getTimeZone("GMT+12:00"), TimeZone.getTimeZone("GMT+13:00"), TimeZone.getTimeZone("GMT+14:00")};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GDate(CharSequence charSequence) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        block49: {
            n6 = 0;
            for (n5 = charSequence.length(); n5 > 0 && GDate.isSpace(charSequence.charAt(n5 - 1)); --n5) {
            }
            while (n6 < n5 && GDate.isSpace(charSequence.charAt(n6))) {
                ++n6;
            }
            if (n5 - n6 >= 1 && charSequence.charAt(n5 - 1) == 'Z') {
                this._bits |= 1;
                --n5;
            } else if (n5 - n6 >= 6 && charSequence.charAt(n5 - 3) == ':') {
                switch (charSequence.charAt(n5 - 6)) {
                    case '-': {
                        n4 = -1;
                        break;
                    }
                    case '+': {
                        n4 = 1;
                        break;
                    }
                    default: {
                        break block49;
                    }
                }
                n3 = GDate.twoDigit(charSequence, n5 - 5);
                n2 = GDate.twoDigit(charSequence, n5 - 2);
                if (n3 > 14) {
                    throw new IllegalArgumentException("time zone hour must be two digits between -14 and +14");
                }
                if (n2 > 59) {
                    throw new IllegalArgumentException("time zone minute must be two digits between 00 and 59");
                }
                this._bits |= 1;
                this._tzsign = n4;
                this._tzh = n3;
                this._tzm = n2;
                n5 -= 6;
            }
        }
        if (n6 < n5 && (n6 + 2 >= n5 || charSequence.charAt(n6 + 2) != ':')) {
            char c;
            n4 = 0;
            if (n6 < n5 && charSequence.charAt(n6) == '-') {
                n4 = 1;
                ++n6;
            }
            n3 = 0;
            n2 = -n6;
            n = n6 < n5 && GDate.digitVal(charSequence.charAt(n6)) == 0 ? 1 : 0;
            while (true) {
                char c2 = c = n6 < n5 ? charSequence.charAt(n6) : (char)'\u0000';
                if (!GDate.isDigit(c)) break;
                if (n != 0 && n6 + n2 >= 4) {
                    throw new IllegalArgumentException("year value starting with zero must be 4 or less digits: " + charSequence);
                }
                n3 = n3 * 10 + GDate.digitVal(c);
                ++n6;
            }
            if ((n2 += n6) > 9) {
                throw new IllegalArgumentException("year too long (up to 9 digits)");
            }
            if (n2 >= 4) {
                this._bits |= 2;
                int n7 = this._CY = n4 != 0 ? -n3 : n3;
                if (this._CY == 0) {
                    throw new IllegalArgumentException("year must not be zero");
                }
            } else if (n2 > 0) {
                throw new IllegalArgumentException("year must be four digits (may pad with zeroes, e.g., 0560)");
            }
            if (this._CY > 292277265) {
                throw new IllegalArgumentException("year value not supported: too big, must be less than 292277265");
            }
            if (this._CY < -292275295) {
                throw new IllegalArgumentException("year values not supported: too small, must be bigger than -292275295");
            }
            if (c != '-') {
                if (n4 != 0 && !this.hasYear()) {
                    throw new IllegalArgumentException();
                }
            } else {
                if (n5 - ++n6 >= 2 && (n3 = GDate.twoDigit(charSequence, n6)) >= 1 && n3 <= 12) {
                    this._bits |= 4;
                    this._M = n3;
                    n6 += 2;
                }
                char c3 = c = n6 < n5 ? charSequence.charAt(n6) : (char)'\u0000';
                if (c != '-') {
                    if (!this.hasMonth()) {
                        throw new IllegalArgumentException();
                    }
                } else {
                    if (n5 - ++n6 >= 2 && (n3 = GDate.twoDigit(charSequence, n6)) >= 1 && n3 <= 31) {
                        this._bits |= 8;
                        this._D = n3;
                        n6 += 2;
                    }
                    if (!this.hasDay()) {
                        if (!this.hasMonth() || this.hasYear()) throw new IllegalArgumentException();
                        char c4 = c = n6 < n5 ? charSequence.charAt(n6) : (char)'\u0000';
                        if (c != '-') throw new IllegalArgumentException();
                        ++n6;
                    }
                }
            }
        }
        if (n6 < n5) {
            if (this.hasYear() || this.hasMonth() || this.hasDay()) {
                if (charSequence.charAt(n6) != 'T') {
                    throw new IllegalArgumentException("date and time must be separated by 'T'");
                }
                ++n6;
            }
            if (n5 < n6 + 8 || charSequence.charAt(n6 + 2) != ':' || charSequence.charAt(n6 + 5) != ':') {
                throw new IllegalArgumentException();
            }
            n4 = GDate.twoDigit(charSequence, n6);
            if (n4 > 24) {
                throw new IllegalArgumentException("hour must be between 00 and 23");
            }
            n3 = GDate.twoDigit(charSequence, n6 + 3);
            if (n3 >= 60) {
                throw new IllegalArgumentException("minute must be between 00 and 59");
            }
            n2 = GDate.twoDigit(charSequence, n6 + 6);
            if (n2 >= 60) {
                throw new IllegalArgumentException("second must be between 00 and 59");
            }
            BigDecimal bigDecimal = _zero;
            if ((n6 += 8) < n5) {
                if (charSequence.charAt(n6) != '.') {
                    throw new IllegalArgumentException();
                }
                if (n6 + 1 < n5) {
                    for (n = n6 + 1; n < n5; ++n) {
                        if (GDate.isDigit(charSequence.charAt(n))) continue;
                        throw new IllegalArgumentException();
                    }
                    try {
                        bigDecimal = new BigDecimal(charSequence.subSequence(n6, n5).toString());
                    }
                    catch (Throwable throwable) {
                        throw new IllegalArgumentException();
                    }
                }
            }
            this._bits |= 0x10;
            this._h = n4;
            this._m = n3;
            this._s = n2;
            this._fs = bigDecimal;
        }
        if (this.hasTime() && this._h == 24) {
            if (this._m != 0 || this._s != 0 || this._fs.compareTo(_zero) != 0) {
                throw new IllegalArgumentException("if hour is 24, minutes, seconds and fraction must be 0");
            }
            if (this.hasDate()) {
                GDateBuilder gDateBuilder = new GDateBuilder(this._CY, this._M, this._D, this._h, this._m, this._s, this._fs, this._tzsign, this._tzh, this._tzm);
                gDateBuilder.normalize24h();
                this._D = gDateBuilder.getDay();
                this._M = gDateBuilder.getMonth();
                this._CY = gDateBuilder.getYear();
                this._h = 0;
            } else if (this.hasDay()) {
                ++this._D;
                this._h = 0;
            }
        }
        if (this.isValid()) return;
        throw new IllegalArgumentException("invalid date");
    }

    public GDate(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal) {
        this._bits = 30;
        this._CY = n;
        this._M = n2;
        this._D = n3;
        this._h = n4;
        this._m = n5;
        this._s = n6;
        BigDecimal bigDecimal2 = this._fs = bigDecimal == null ? _zero : bigDecimal;
        if (!this.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    public GDate(int n, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7, int n8, int n9) {
        this._bits = 31;
        this._CY = n;
        this._M = n2;
        this._D = n3;
        this._h = n4;
        this._m = n5;
        this._s = n6;
        this._fs = bigDecimal == null ? _zero : bigDecimal;
        this._tzsign = n7;
        this._tzh = n8;
        this._tzm = n9;
        if (!this.isValid()) {
            throw new IllegalArgumentException();
        }
    }

    public GDate(Date date) {
        this(new GDateBuilder(date));
    }

    public GDate(Calendar calendar) {
        int n;
        boolean bl = calendar.isSet(1);
        boolean bl2 = calendar.isSet(0);
        boolean bl3 = calendar.isSet(2);
        boolean bl4 = calendar.isSet(5);
        boolean bl5 = calendar.isSet(11);
        boolean bl6 = calendar.isSet(10);
        boolean bl7 = calendar.isSet(9);
        boolean bl8 = calendar.isSet(12);
        boolean bl9 = calendar.isSet(13);
        boolean bl10 = calendar.isSet(14);
        boolean bl11 = calendar.isSet(15);
        boolean bl12 = calendar.isSet(16);
        if (bl) {
            n = calendar.get(1);
            if (bl2 && calendar instanceof GregorianCalendar && calendar.get(0) == 0) {
                n = -n;
            }
            this._bits |= 2;
            this._CY = n;
        }
        if (bl3) {
            this._bits |= 4;
            this._M = calendar.get(2) + 1;
        }
        if (bl4) {
            this._bits |= 8;
            this._D = calendar.get(5);
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        BigDecimal bigDecimal = _zero;
        if (bl5) {
            n2 = calendar.get(11);
            n = 1;
        } else if (bl6 && bl7) {
            n2 = calendar.get(10) + calendar.get(9) * 12;
            n = 1;
        }
        if (bl8) {
            n3 = calendar.get(12);
            n = 1;
        }
        if (bl9) {
            n4 = calendar.get(13);
            n = 1;
        }
        if (bl10) {
            bigDecimal = BigDecimal.valueOf(calendar.get(14), 3);
            n = 1;
        }
        if (n != 0) {
            this._bits |= 0x10;
            this._h = n2;
            this._m = n3;
            this._s = n4;
            this._fs = bigDecimal;
        }
        if (bl11) {
            int n5 = calendar.get(15);
            if (bl12) {
                n5 += calendar.get(16);
            }
            this._bits |= 1;
            if (n5 == 0) {
                this._tzsign = 0;
                this._tzh = 0;
                this._tzm = 0;
                TimeZone timeZone = calendar.getTimeZone();
                String string = timeZone.getID();
                if (string != null && string.length() > 3) {
                    switch (string.charAt(3)) {
                        case '+': {
                            this._tzsign = 1;
                            break;
                        }
                        case '-': {
                            this._tzsign = -1;
                        }
                    }
                }
            } else {
                this._tzsign = n5 < 0 ? -1 : 1;
                this._tzh = (n5 *= this._tzsign) / 3600000;
                this._tzm = (n5 - this._tzh * 3600000) / 60000;
            }
        }
    }

    public GDate(GDateSpecification gDateSpecification) {
        if (gDateSpecification.hasTimeZone()) {
            this._bits |= 1;
            this._tzsign = gDateSpecification.getTimeZoneSign();
            this._tzh = gDateSpecification.getTimeZoneHour();
            this._tzm = gDateSpecification.getTimeZoneMinute();
        }
        if (gDateSpecification.hasTime()) {
            this._bits |= 0x10;
            this._h = gDateSpecification.getHour();
            this._m = gDateSpecification.getMinute();
            this._s = gDateSpecification.getSecond();
            this._fs = gDateSpecification.getFraction();
        }
        if (gDateSpecification.hasDay()) {
            this._bits |= 8;
            this._D = gDateSpecification.getDay();
        }
        if (gDateSpecification.hasMonth()) {
            this._bits |= 4;
            this._M = gDateSpecification.getMonth();
        }
        if (gDateSpecification.hasYear()) {
            this._bits |= 2;
            this._CY = gDateSpecification.getYear();
        }
    }

    static final boolean isDigit(char c) {
        return (char)(c - 48) <= '\t';
    }

    static final boolean isSpace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static final int digitVal(char c) {
        return c - 48;
    }

    private static final int twoDigit(CharSequence charSequence, int n) {
        char c = charSequence.charAt(n);
        char c2 = charSequence.charAt(n + 1);
        if (!GDate.isDigit(c) || !GDate.isDigit(c2)) {
            return 100;
        }
        return GDate.digitVal(c) * 10 + GDate.digitVal(c2);
    }

    @Override
    public final boolean isImmutable() {
        return true;
    }

    @Override
    public int getFlags() {
        return this._bits;
    }

    @Override
    public final boolean hasTimeZone() {
        return (this._bits & 1) != 0;
    }

    @Override
    public final boolean hasYear() {
        return (this._bits & 2) != 0;
    }

    @Override
    public final boolean hasMonth() {
        return (this._bits & 4) != 0;
    }

    @Override
    public final boolean hasDay() {
        return (this._bits & 8) != 0;
    }

    @Override
    public final boolean hasTime() {
        return (this._bits & 0x10) != 0;
    }

    @Override
    public final boolean hasDate() {
        return (this._bits & 0xE) == 14;
    }

    @Override
    public final int getYear() {
        return this._CY;
    }

    @Override
    public final int getMonth() {
        return this._M;
    }

    @Override
    public final int getDay() {
        return this._D;
    }

    @Override
    public final int getHour() {
        return this._h;
    }

    @Override
    public final int getMinute() {
        return this._m;
    }

    @Override
    public final int getSecond() {
        return this._s;
    }

    @Override
    public final BigDecimal getFraction() {
        return this._fs;
    }

    @Override
    public final int getTimeZoneSign() {
        return this._tzsign;
    }

    @Override
    public final int getTimeZoneHour() {
        return this._tzh;
    }

    @Override
    public final int getTimeZoneMinute() {
        return this._tzm;
    }

    @Override
    public int getMillisecond() {
        if (this._fs == null) {
            return 0;
        }
        return this._fs.setScale(3, 1).unscaledValue().intValue();
    }

    @Override
    public String canonicalString() {
        this.ensureCanonicalString();
        return this._canonicalString;
    }

    @Override
    public boolean isValid() {
        return GDateBuilder.isValidGDate(this);
    }

    @Override
    public int getJulianDate() {
        return GDateBuilder.julianDateForGDate(this);
    }

    @Override
    public XmlCalendar getCalendar() {
        return new XmlCalendar(this);
    }

    @Override
    public Date getDate() {
        return GDateBuilder.dateForGDate(this);
    }

    @Override
    public int compareToGDate(GDateSpecification gDateSpecification) {
        return GDateBuilder.compareGDate(this, gDateSpecification);
    }

    @Override
    public int getBuiltinTypeCode() {
        return GDateBuilder.btcForFlags(this._bits);
    }

    public GDate add(GDurationSpecification gDurationSpecification) {
        GDateBuilder gDateBuilder = new GDateBuilder(this);
        gDateBuilder.addGDuration(gDurationSpecification);
        return gDateBuilder.toGDate();
    }

    public GDate subtract(GDurationSpecification gDurationSpecification) {
        GDateBuilder gDateBuilder = new GDateBuilder(this);
        gDateBuilder.subtractGDuration(gDurationSpecification);
        return gDateBuilder.toGDate();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GDate)) {
            return false;
        }
        this.ensureCanonicalString();
        return this._canonicalString.equals(((GDate)object).canonicalString());
    }

    public int hashCode() {
        this.ensureCanonicalString();
        return this._canonicalString.hashCode();
    }

    private void ensureCanonicalString() {
        Serializable serializable;
        boolean bl;
        if (this._canonicalString != null) {
            return;
        }
        boolean bl2 = bl = this.hasTimeZone() && this.getTimeZoneSign() != 0 && this.hasTime() && this.hasDay() == this.hasMonth() && this.hasDay() == this.hasYear();
        if (!bl && this.getFraction() != null && this.getFraction().scale() > 0) {
            serializable = this.getFraction().unscaledValue();
            boolean bl3 = bl = ((BigInteger)serializable).mod(GDateBuilder.TEN).signum() == 0;
        }
        if (!bl) {
            this._canonicalString = this.toString();
        } else {
            serializable = new GDateBuilder(this);
            ((GDateBuilder)serializable).normalize();
            this._canonicalString = ((GDateBuilder)serializable).toString();
        }
    }

    @Override
    public String toString() {
        if (this._string == null) {
            this._string = GDate.formatGDate(this);
        }
        return this._string;
    }

    private static final int _padTwoAppend(char[] cArray, int n, int n2) {
        assert (n2 >= 0 && n2 < 100);
        cArray[n] = _tensDigit[n2];
        cArray[n + 1] = _onesDigit[n2];
        return n + 2;
    }

    private static final int _padFourAppend(char[] cArray, int n, int n2) {
        if (n2 < 0) {
            cArray[n++] = 45;
            n2 = -n2;
        }
        if (n2 >= 10000) {
            String string = Integer.toString(n2);
            string.getChars(0, string.length(), cArray, n);
            return n + string.length();
        }
        int n3 = n2 / 100;
        int n4 = n2 - n3 * 100;
        cArray[n] = _tensDigit[n3];
        cArray[n + 1] = _onesDigit[n3];
        cArray[n + 2] = _tensDigit[n4];
        cArray[n + 3] = _onesDigit[n4];
        return n + 4;
    }

    static final TimeZone timeZoneForGDate(GDateSpecification gDateSpecification) {
        if (!gDateSpecification.hasTimeZone()) {
            return TimeZone.getDefault();
        }
        if (gDateSpecification.getTimeZoneSign() == 0) {
            return GMTZONE;
        }
        if (gDateSpecification.getTimeZoneMinute() == 0 && gDateSpecification.getTimeZoneHour() <= 14 && gDateSpecification.getTimeZoneHour() >= 0) {
            return gDateSpecification.getTimeZoneSign() < 0 ? MINUSZONE[gDateSpecification.getTimeZoneHour()] : PLUSZONE[gDateSpecification.getTimeZoneHour()];
        }
        char[] cArray = new char[9];
        cArray[0] = 71;
        cArray[1] = 77;
        cArray[2] = 84;
        cArray[3] = gDateSpecification.getTimeZoneSign() < 0 ? 45 : 43;
        GDate._padTwoAppend(cArray, 4, gDateSpecification.getTimeZoneHour());
        cArray[6] = 58;
        GDate._padTwoAppend(cArray, 7, gDateSpecification.getTimeZoneMinute());
        return TimeZone.getTimeZone(new String(cArray));
    }

    static String formatGDate(GDateSpecification gDateSpecification) {
        BigDecimal bigDecimal = gDateSpecification.getFraction();
        char[] cArray = new char[33 + (bigDecimal == null ? 0 : bigDecimal.scale())];
        int n = 0;
        if (gDateSpecification.hasYear() || gDateSpecification.hasMonth() || gDateSpecification.hasDay()) {
            if (gDateSpecification.hasYear()) {
                n = GDate._padFourAppend(cArray, 0, gDateSpecification.getYear());
            } else {
                cArray[n++] = 45;
            }
            if (gDateSpecification.hasMonth() || gDateSpecification.hasDay()) {
                cArray[n++] = 45;
                if (gDateSpecification.hasMonth()) {
                    n = GDate._padTwoAppend(cArray, n, gDateSpecification.getMonth());
                }
                if (gDateSpecification.hasDay()) {
                    cArray[n++] = 45;
                    n = GDate._padTwoAppend(cArray, n, gDateSpecification.getDay());
                }
            }
            if (gDateSpecification.hasTime()) {
                cArray[n++] = 84;
            }
        }
        if (gDateSpecification.hasTime()) {
            String string;
            int n2;
            n = GDate._padTwoAppend(cArray, n, gDateSpecification.getHour());
            cArray[n++] = 58;
            n = GDate._padTwoAppend(cArray, n, gDateSpecification.getMinute());
            cArray[n++] = 58;
            n = GDate._padTwoAppend(cArray, n, gDateSpecification.getSecond());
            if (bigDecimal != _zero && (n2 = (string = bigDecimal.toString()).indexOf(46)) >= 0) {
                string.getChars(n2, string.length(), cArray, n);
                n += string.length() - n2;
            }
        }
        if (gDateSpecification.hasTimeZone()) {
            if (gDateSpecification.getTimeZoneSign() == 0) {
                cArray[n++] = 90;
            } else {
                cArray[n++] = gDateSpecification.getTimeZoneSign() > 0 ? 43 : 45;
                n = GDate._padTwoAppend(cArray, n, gDateSpecification.getTimeZoneHour());
                cArray[n++] = 58;
                n = GDate._padTwoAppend(cArray, n, gDateSpecification.getTimeZoneMinute());
            }
        }
        return new String(cArray, 0, n);
    }
}

