/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.GenericTypes;
import commvault.cte.common.schema.SchemaException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import workflow.types.Time;

public class TypeMap {
    private static final Map<String, Class> classMapper = new HashMap<String, Class>();
    private static final Map<String, GenericTypes> nameMapper = new HashMap<String, GenericTypes>();

    public static Class getJavaClass(String string) {
        return classMapper.get(string);
    }

    public static GenericTypes fromName(String string) {
        return nameMapper.get(string);
    }

    public static boolean validW3CType(String string) {
        return classMapper.containsKey(string);
    }

    public static Object fromString(String string, Class clazz) throws Exception {
        if (string == null) {
            return null;
        }
        if (clazz.equals(String.class) || clazz.equals(Byte[].class) || clazz.equals(Date.class) || clazz.equals(Calendar.class) || clazz.equals(Object.class)) {
            return string;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.parseBoolean(string);
        }
        if (clazz.equals(Character.class)) {
            return Character.valueOf(string.charAt(0));
        }
        if (clazz.equals(Byte.class)) {
            return Byte.parseByte(string);
        }
        if (clazz.equals(Short.class)) {
            return Short.parseShort(string);
        }
        if (clazz.equals(Integer.class)) {
            return Integer.parseInt(string);
        }
        if (clazz.equals(Long.class)) {
            return Long.parseLong(string);
        }
        if (clazz.equals(Float.class)) {
            return Float.valueOf(Float.parseFloat(string));
        }
        if (clazz.equals(Double.class)) {
            return Double.parseDouble(string);
        }
        if (clazz.equals(BigInteger.class)) {
            return BigInteger.valueOf(Long.parseLong(string));
        }
        throw new SchemaException("unknown conversion type [" + clazz.getName() + "]");
    }

    static {
        classMapper.put("anySimpleType", Object.class);
        classMapper.put("anyType", Object.class);
        classMapper.put("anyURI", String.class);
        classMapper.put("base64Binary", Byte[].class);
        classMapper.put("boolean", Boolean.class);
        classMapper.put("byte", Byte.class);
        classMapper.put("date", Date.class);
        classMapper.put("dateTime", Calendar.class);
        classMapper.put("decimal", Double.class);
        classMapper.put("double", Double.class);
        classMapper.put("duration", String.class);
        classMapper.put("float", Float.class);
        classMapper.put("gDay", Calendar.class);
        classMapper.put("gMonth", Calendar.class);
        classMapper.put("gMonthDay", Calendar.class);
        classMapper.put("gYear", Calendar.class);
        classMapper.put("gYearMonth", Calendar.class);
        classMapper.put("ghexBinary", Byte[].class);
        classMapper.put("int", Integer.class);
        classMapper.put("integer", Integer.class);
        classMapper.put("long", Long.class);
        classMapper.put("negativeInteger", Integer.class);
        classMapper.put("nonNegativeInteger", Integer.class);
        classMapper.put("nonPositiveInteger", Integer.class);
        classMapper.put("normalizedString", String.class);
        classMapper.put("positiveInteger", Integer.class);
        classMapper.put("short", Short.class);
        classMapper.put("string", String.class);
        classMapper.put("time", Time.class);
        classMapper.put("unsignedByte", Short.class);
        classMapper.put("unsignedInt", Long.class);
        classMapper.put("unsignedLong", BigInteger.class);
        classMapper.put("unsignedShort", Short.class);
        nameMapper.put(String.class.getName(), GenericTypes.STRING);
        nameMapper.put(Integer.class.getName(), GenericTypes.INTEGER);
        nameMapper.put(Integer.TYPE.getName(), GenericTypes.INTEGER);
        nameMapper.put(Double.class.getName(), GenericTypes.DOUBLE);
        nameMapper.put(Double.TYPE.getName(), GenericTypes.DOUBLE);
        nameMapper.put(Float.class.getName(), GenericTypes.FLOAT);
        nameMapper.put(Float.TYPE.getName(), GenericTypes.FLOAT);
        nameMapper.put(Boolean.class.getName(), GenericTypes.BOOLEAN);
        nameMapper.put(Boolean.TYPE.getName(), GenericTypes.BOOLEAN);
        nameMapper.put(Byte.class.getName(), GenericTypes.BYTE);
        nameMapper.put(Byte.TYPE.getName(), GenericTypes.BYTE);
        nameMapper.put(Date.class.getName(), GenericTypes.DATE);
        nameMapper.put(Calendar.class.getName(), GenericTypes.DATETIME);
        nameMapper.put(Time.class.getName(), GenericTypes.TIME);
        nameMapper.put(Byte[].class.getName(), GenericTypes.BASE64BINARY);
        nameMapper.put(Long.class.getName(), GenericTypes.LONG);
        nameMapper.put(Long.TYPE.getName(), GenericTypes.LONG);
        nameMapper.put(Short.class.getName(), GenericTypes.SHORT);
        nameMapper.put(Short.TYPE.getName(), GenericTypes.SHORT);
        nameMapper.put(Character.class.getName(), GenericTypes.CHARACTER);
        nameMapper.put(Character.TYPE.getName(), GenericTypes.CHARACTER);
        nameMapper.put(Object.class.getName(), GenericTypes.ANYTYPE);
    }
}

