/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.ComplexType;
import commvault.cte.common.schema.SchemaAnnotation;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaException;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class SchemaElement
extends SchemaProperty
implements Serializable {
    protected static SchemaElement newInstance(String string, SchemaType schemaType, SchemaDocument schemaDocument) throws Exception {
        Element element = new Element("element", schemaDocument.getSchema().getNamespace());
        element.setAttribute("name", string);
        SchemaElement schemaElement = new SchemaElement(element, schemaDocument);
        schemaElement.setType(schemaType);
        return schemaElement;
    }

    protected static SchemaElement parse(Element element, SchemaDocument schemaDocument) throws Exception {
        SchemaElement schemaElement;
        if (element.getAttribute("ref") != null) {
            QName qName = schemaDocument.buildName(element.getAttributeValue("ref"), element.getAdditionalNamespaces());
            schemaElement = schemaDocument.getSchemaTypeSystem().lookupElement(qName);
        } else {
            schemaElement = new SchemaElement(element, schemaDocument);
            schemaElement.parse();
        }
        return schemaElement;
    }

    private SchemaElement(String string) {
        super(new Element("element"), null);
        this.element.setAttribute("name", string);
    }

    protected SchemaElement(Element element, SchemaDocument schemaDocument) {
        super(element, schemaDocument);
    }

    @Override
    protected void parse(List<Element> list) throws Exception {
        for (Element element : list) {
            if (element.getName().equals("complexType")) {
                this.type = ComplexType.build(element, this.schemaDocument);
                continue;
            }
            if (element.getName().equals("annotation")) {
                this.annotation = new SchemaAnnotation(element);
                continue;
            }
            throw new SchemaException("unknown schema element [" + element.getName() + "] under [" + this.element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.schemaDocument.elements.containsKey(this.getName().getLocalPart());
    }

    @Override
    public int getMinOccurs() {
        if (this.element.getAttribute("minOccurs") == null) {
            return 1;
        }
        return Integer.parseInt(this.element.getAttributeValue("minOccurs"));
    }

    @Override
    public int getMaxOccurs() {
        if (this.element.getAttribute("maxOccurs") == null) {
            return 1;
        }
        if (this.element.getAttributeValue("maxOccurs").equals("unbounded")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(this.element.getAttributeValue("maxOccurs"));
    }

    @Override
    public void setRequired(boolean bl) {
        if (bl) {
            this.element.removeAttribute("minOccurs");
        } else {
            this.element.setAttribute("minOccurs", "0");
        }
    }

    @Override
    public void setList(boolean bl) {
        if (bl) {
            this.element.setAttribute("maxOccurs", "unbounded");
        } else {
            this.element.removeAttribute("maxOccurs");
        }
    }

    private void removeType() {
        this.element.removeAttribute("type");
        this.element.removeContent();
        this.type = null;
    }

    public ComplexType createComplexType() {
        this.removeType();
        ComplexType complexType = new ComplexType(this.schemaDocument);
        this.element.addContent((Content)complexType.element);
        this.type = complexType;
        return complexType;
    }

    @Override
    public void setType(SchemaType schemaType) throws Exception {
        this.removeType();
        if (schemaType.getName() != null) {
            this.element.setAttribute("type", this.schemaDocument.getReferenceName(schemaType.getName()));
        } else {
            this.element.addContent((Content)schemaType.getElement());
        }
        this.type = schemaType;
    }

    @Override
    public String toString() {
        try {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            xMLOutputter.output(this.element, (Writer)stringWriter);
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            return String.valueOf(this.getName());
        }
    }
}

