/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common.schema;

import commvault.cte.common.schema.SchemaAnnotation;
import commvault.cte.common.schema.SchemaDocument;
import commvault.cte.common.schema.SchemaException;
import commvault.cte.common.schema.SchemaProperty;
import commvault.cte.common.schema.SchemaType;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.jdom2.Element;

public class SchemaAttribute
extends SchemaProperty
implements Serializable {
    protected static SchemaAttribute parse(Element element, SchemaDocument schemaDocument) throws Exception {
        SchemaAttribute schemaAttribute = new SchemaAttribute(element, schemaDocument);
        schemaAttribute.parse();
        return schemaAttribute;
    }

    protected static SchemaAttribute newInstance(String string, SchemaDocument schemaDocument) throws Exception {
        Element element = new Element("attribute", schemaDocument.getSchema().getNamespace());
        element.setAttribute("name", string);
        SchemaAttribute schemaAttribute = new SchemaAttribute(element, schemaDocument);
        return schemaAttribute;
    }

    protected SchemaAttribute(Element element, SchemaDocument schemaDocument) throws Exception {
        super(element, schemaDocument);
        if (element.getAttribute("use") != null && element.getAttributeValue("use").equals("prohibited")) {
            throw new SchemaException("prohibited attributes not implemented in namespace [" + schemaDocument.getTargetNamespace() + "]");
        }
    }

    @Override
    protected void parse(List<Element> list) throws Exception {
        for (Element element : this.element.getChildren()) {
            if (element.getName().equals("annotation")) {
                this.annotation = new SchemaAnnotation(element);
                continue;
            }
            throw new SchemaException("unknown schema element [" + element.getName() + "] under [" + this.element.getName() + "], namespace [" + this.schemaDocument.getTargetNamespace() + "]");
        }
    }

    @Override
    public boolean isAttribute() {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return this.schemaDocument.attributes.containsKey(this.getName().getLocalPart());
    }

    public boolean isOptional() {
        return this.element.getAttribute("use") == null || this.element.getAttributeValue("use").equals("optional");
    }

    @Override
    public int getMinOccurs() {
        if (this.isOptional()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getMaxOccurs() {
        return 1;
    }

    @Override
    public void setRequired(boolean bl) {
        if (bl) {
            this.element.setAttribute("use", "required");
        } else {
            this.element.setAttribute("use", "optional");
        }
    }

    @Override
    public void setList(boolean bl) {
    }

    public void setType(QName qName) throws Exception {
        this.setType(this.schemaDocument.sts.lookupType(qName));
    }

    @Override
    public void setType(SchemaType schemaType) throws Exception {
        this.type = schemaType;
        this.element.setAttribute("type", this.schemaDocument.getReferenceName(schemaType.getName()));
    }
}

