/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import commvault.cte.CteStringBank;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaName;
import javax.print.attribute.standard.Sides;
import javax.swing.JFrame;

public class PrintUtil {
    private static Properties printPrefs = new Properties();

    public static void print(String string, String string2, char c) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        if (fileInputStream == null) {
            return;
        }
        DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
        SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, null);
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        hashPrintRequestAttributeSet.add(new Copies(1));
        hashPrintRequestAttributeSet.add(MediaName.ISO_A4_WHITE);
        hashPrintRequestAttributeSet.add(Sides.DUPLEX);
        PrintService printService = PrintServiceLookup.lookupDefaultPrintService();
        DocPrintJob docPrintJob = printService.createPrintJob();
        simpleDoc.getDocFlavor();
        try {
            docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
        }
        catch (PrintException printException) {
            printException.printStackTrace();
        }
    }

    private static void print(Frame frame, String string, String string2, char c) {
        PrintJob printJob = null;
        printJob = Toolkit.getDefaultToolkit().getPrintJob(frame, string, printPrefs);
        PagePrinter pagePrinter = new PagePrinter(printJob);
        string2 = string2.replace(c, ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            pagePrinter.printParagraph(stringTokenizer.nextToken());
        }
        pagePrinter.finalize();
        printJob.end();
    }

    public static void main(String[] stringArray) {
        PrintUtil.print(new JFrame(), CteStringBank.Title.getI18n(), CteStringBank.Content.getI18n(), ' ');
    }

    private static class PagePrinter {
        private static Dimension a4mm = new Dimension(210, 297);
        private static int marginmm = 20;
        private static float lineFactor = 1.3f;
        private static Font printFont = new Font("Serif", 0, 8);
        private Point cursor;
        private Graphics page;
        private PrintJob printJob;
        private FontMetrics fm;
        private int lineHeight;
        private int printableWidth;
        private int printableHeight;
        private LinePrinter linePrinter;

        PagePrinter(PrintJob printJob) {
            this.printJob = printJob;
            this.newPage();
        }

        private void newPage() {
            if (this.page != null) {
                this.page.dispose();
            }
            this.page = this.printJob.getGraphics();
            Dimension dimension = this.printJob.getPageDimension();
            this.printableWidth = (int)((float)dimension.width * (float)(PagePrinter.a4mm.width - 2 * marginmm) / (float)PagePrinter.a4mm.width);
            this.printableHeight = (int)((float)dimension.height * (float)(PagePrinter.a4mm.height - 2 * marginmm) / (float)PagePrinter.a4mm.height);
            this.page.translate((dimension.width - this.printableWidth) / 2, (dimension.height - this.printableHeight) / 2);
            this.page.setClip(0, 0, (int)((double)this.printableWidth * 1.1), this.printableHeight);
            this.page.setFont(printFont);
            this.fm = this.page.getFontMetrics();
            this.lineHeight = (int)((float)this.fm.getHeight() * lineFactor);
            if (this.linePrinter == null) {
                int n = (int)((double)this.printableWidth * 0.95);
                this.linePrinter = new LinePrinter(this.fm, n);
            }
            this.cursor = new Point(0, this.fm.getHeight());
        }

        void printParagraph(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (!stringTokenizer.hasMoreTokens()) {
                this.cursor.y += this.lineHeight;
                return;
            }
            while (stringTokenizer.hasMoreTokens()) {
                if (this.linePrinter.append(stringTokenizer.nextToken())) continue;
                this.printLine();
                while (this.linePrinter.isFull()) {
                    this.printLine();
                }
            }
            if (!this.linePrinter.isEmpty()) {
                this.printLine();
            }
        }

        private void printLine() {
            this.linePrinter.print(this.page, this.cursor);
            this.cursor.y += this.lineHeight;
            if (this.cursor.y > this.printableHeight) {
                this.newPage();
            }
        }

        public void finalize() {
            this.page.dispose();
        }
    }

    private static class LinePrinter {
        private int currentWidth = 0;
        private StringBuffer line = new StringBuffer();
        private FontMetrics fm;
        private int spw;
        private static final String sp = " ";
        private int maxWidth;
        private String savedToken = null;
        private int savedTokenWidth = 0;

        LinePrinter(FontMetrics fontMetrics, int n) {
            this.fm = fontMetrics;
            this.spw = fontMetrics.stringWidth(sp);
            this.maxWidth = n;
        }

        void print(Graphics graphics, Point point) {
            graphics.drawString(this.line.toString(), point.x, point.y);
            if (this.savedToken != null) {
                this.line = new StringBuffer(this.savedToken);
                this.currentWidth = this.savedTokenWidth;
                this.line.append(sp);
                this.currentWidth += this.spw;
            } else {
                this.line = new StringBuffer();
                this.currentWidth = 0;
            }
            this.savedToken = null;
        }

        boolean append(String string) {
            int n = this.fm.stringWidth(string);
            if (this.currentWidth > 0 && this.currentWidth + this.spw + n > this.maxWidth) {
                this.savedToken = string;
                this.savedTokenWidth = n;
                return false;
            }
            this.line.append(string);
            this.currentWidth += n;
            this.line.append(sp);
            this.currentWidth += this.spw;
            return true;
        }

        boolean isEmpty() {
            return this.currentWidth == 0;
        }

        boolean isFull() {
            return this.currentWidth > this.maxWidth;
        }
    }
}

