/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.common;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class ButtonPanel
extends JPanel
implements Serializable,
SwingConstants {
    private int orientation = 0;
    private JPanel _buttonHolder;
    private ArrayList _buttons = new ArrayList();

    public ButtonPanel() {
        this.initDisplay();
    }

    public ButtonPanel(int n) {
        this.orientation = n;
        this.initDisplay();
    }

    private void initDisplay() {
        this.setLayout(new FlowLayout(this.orientation == 0 ? 2 : 1));
        this._buttonHolder = new JPanel();
        this._buttonHolder.setOpaque(false);
        GridLayout gridLayout = new GridLayout();
        if (this.orientation == 0) {
            gridLayout.setRows(1);
            gridLayout.setColumns(0);
            gridLayout.setHgap(3);
        } else {
            gridLayout.setColumns(1);
            gridLayout.setRows(0);
            gridLayout.setVgap(3);
        }
        this._buttonHolder.setLayout(gridLayout);
        this.add(this._buttonHolder);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.initDisplay();
        this.updateButtons();
    }

    private void updateButtons() {
        Iterator iterator = this._buttons.iterator();
        while (iterator.hasNext()) {
            this._buttonHolder.add((JButton)iterator.next());
        }
    }

    public void addButton(JButton jButton) {
        this._buttonHolder.add(jButton);
        this._buttons.add(jButton);
    }

    public void add(JButton jButton) {
        this._buttonHolder.add(jButton);
        this._buttons.add(jButton);
    }
}

