/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.cm;

import commvault.cte.cm.ColumnEntry;
import commvault.cte.cm.FolderType;
import commvault.msgs.CM.Column;
import commvault.msgs.CM.Folder;
import commvault.msgs.CM.Site;
import commvault.msgs.CvEntities.FolderEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class BaseFolder
extends Folder {
    private static final Comparator<Column> COLUMN_ORDER = new Comparator<Column>(){

        @Override
        public int compare(Column column, Column column2) {
            return Integer.valueOf(column.getColumnIndex()).compareTo(column2.getColumnIndex());
        }
    };
    protected Map<String, Column> namedColumns = new HashMap<String, Column>();

    protected BaseFolder(Site site) {
        this.setSite(site);
        this.setFolder(new FolderEntity());
        this.setColumns(new ArrayList());
    }

    protected BaseFolder(Folder folder) {
        super(folder);
        ArrayList<ColumnEntry> arrayList = new ArrayList<ColumnEntry>();
        if (this.columns != null) {
            for (int i = 0; i < this.getColumns().size(); ++i) {
                ColumnEntry columnEntry = new ColumnEntry((Column)this.getColumns().get(i));
                columnEntry.setColumnIndex(i + 1);
                arrayList.add(columnEntry);
                this.namedColumns.put(columnEntry.getColumn().getColumnName(), columnEntry);
            }
        }
        this.setColumns(arrayList);
    }

    public String getName() {
        return this.getFolder().getFolderName();
    }

    public void setName(String string) {
        this.getFolder().setFolderName(string);
    }

    public FolderType getType() {
        return FolderType.fromInt(this.getFolderType());
    }

    public Column getColumn(String string) {
        return this.namedColumns.get(string);
    }

    public void reindex() {
        for (int i = 0; i < this.getColumns().size(); ++i) {
            ((Column)this.getColumns().get(i)).setColumnIndex(i);
        }
    }

    public void sort() {
        Collections.sort(this.columns, COLUMN_ORDER);
    }

    public String toString() {
        return this.getName();
    }
}

