/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.binder.builder;

import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ToggleButtonAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractConverter;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jidesoft.swing.JideButton;
import commvault.cte.CteStringBank;
import commvault.cte.I18nAware;
import commvault.cte.binder.CVPresentationModel;
import commvault.cte.binder.ValueModelUtil;
import commvault.cte.binder.builder.RadioButtonModel;
import commvault.cte.common.ui.ClientBrowseAction;
import commvault.cte.common.ui.HourMinComponent;
import commvault.cte.common.xml.CVEnum;
import commvault.cte.component.CNFilterListSelectionPanel;
import commvault.cte.component.CNListSelectionPanel;
import commvault.cte.component.ControlledTextField;
import commvault.cte.component.DescriptionPanel;
import commvault.cte.component.FSTextField;
import commvault.cte.component.JNumericTextField;
import commvault.cte.component.JNumericTextField2;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.NameTextField;
import commvault.cte.component.NumericDocument;
import commvault.cte.component.NumericDocument2;
import commvault.cte.component.SList;
import commvault.cte.component.SortedListModel;
import commvault.cte.component.calender.CalendarComboBox;
import commvault.cte.component.calender.TimeChooser;
import commvault.cte.component.calender.TimeRangePanel;
import commvault.cte.component.dock.IContext;
import commvault.cte.component.events.WRActionListener;
import commvault.cte.net.IdNameItem;
import commvault.cte.util.Application;
import commvault.cte.util.EnumUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class UIFactory
extends BasicComponentFactory {
    public static JRadioButton createRadioButton(ValueModel valueModel, Object object, String string) {
        if (object instanceof ButtonGroup) {
            ButtonGroup buttonGroup = (ButtonGroup)object;
            JRadioButton jRadioButton = new JRadioButton(string);
            ToggleButtonAdapter toggleButtonAdapter = new ToggleButtonAdapter(valueModel);
            RadioButtonModel radioButtonModel = new RadioButtonModel((ButtonModel)toggleButtonAdapter);
            jRadioButton.setModel(radioButtonModel);
            buttonGroup.add(jRadioButton);
            return jRadioButton;
        }
        JRadioButton jRadioButton = BasicComponentFactory.createRadioButton((ValueModel)valueModel, (Object)object, (String)string);
        return jRadioButton;
    }

    public static ValueModel createEnumToIntConverter(ValueModel valueModel, final Enum[] enumArray) {
        return new AbstractConverter(valueModel){

            public Object convertFromSubject(Object object) {
                if (object == null) {
                    return null;
                }
                for (Enum enum_ : enumArray) {
                    if (!object.equals(enum_.ordinal())) continue;
                    return enum_;
                }
                return null;
            }

            public void setValue(Object object) {
                if (object != null) {
                    this.subject.setValue((Object)((Enum)object).ordinal());
                } else {
                    this.subject.setValue(object);
                }
            }
        };
    }

    public static JTextField createPlaceHolderTextField(ValueModel valueModel, final String string) {
        if (valueModel == null) {
            valueModel = new ValueHolder();
        }
        JFormattedTextField.AbstractFormatter abstractFormatter = new JFormattedTextField.AbstractFormatter(){

            @Override
            public Object stringToValue(String string2) throws ParseException {
                if (string2 == null || string2.trim().equalsIgnoreCase(string) || string2.isEmpty()) {
                    return "";
                }
                return string2;
            }

            @Override
            public String valueToString(Object object) throws ParseException {
                if (object == null || object.toString().trim().isEmpty()) {
                    return string;
                }
                return object.toString();
            }
        };
        JFormattedTextField jFormattedTextField = BasicComponentFactory.createFormattedTextField((ValueModel)valueModel, (JFormattedTextField.AbstractFormatter)abstractFormatter);
        class JTextFieldDecorator {
            private JTextField uiTextField;
            private String placeHolder;
            private Color defaultTextColor;
            private Color placeHolderColor = Color.GRAY;

            public JTextFieldDecorator(JTextField jTextField, String string) {
                this.uiTextField = jTextField;
                this.placeHolder = string;
                this.build();
            }

            private void build() {
                if (this.uiTextField != null) {
                    this.defaultTextColor = this.uiTextField.getForeground();
                }
                this.resetToPlaceHolder();
                this.attachListeners();
            }

            private void resetToPlaceHolder() {
                if (this.uiTextField == null || this.placeHolder == null || this.placeHolderColor == null || !this.uiTextField.getText().isEmpty() && !this.uiTextField.getText().trim().equalsIgnoreCase(this.placeHolder)) {
                    return;
                }
                this.uiTextField.setForeground(this.placeHolderColor);
                this.uiTextField.setText(this.uiTextField.isEnabled() ? this.placeHolder : "");
                this.uiTextField.setCaretPosition(0);
            }

            private void resetToDefault() {
                if (!this.uiTextField.getText().isEmpty() && !this.uiTextField.getText().trim().equalsIgnoreCase(this.placeHolder)) {
                    return;
                }
                this.uiTextField.setForeground(this.defaultTextColor);
                this.uiTextField.setText("");
            }

            private void attachListeners() {
                this.uiTextField.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent focusEvent) {
                        this.resetToDefault();
                    }

                    @Override
                    public void focusLost(FocusEvent focusEvent) {
                        this.resetToPlaceHolder();
                    }
                });
                this.uiTextField.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        this.resetToPlaceHolder();
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        this.resetToDefault();
                    }
                });
                this.uiTextField.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        this.resetToDefault();
                    }

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        if (keyEvent.getKeyChar() == '\b' && uiTextField.getText().trim().isEmpty()) {
                            this.resetToPlaceHolder();
                        }
                    }
                });
                this.uiTextField.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if (!propertyChangeEvent.getPropertyName().trim().equalsIgnoreCase("enabled") || !(propertyChangeEvent.getNewValue() instanceof Boolean)) {
                            return;
                        }
                        if (!((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                            this.resetToDefault();
                            return;
                        }
                        this.resetToPlaceHolder();
                    }
                });
                this.uiTextField.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        if (uiTextField.getText().length() != 0 && !uiTextField.getText().equals(placeHolder)) {
                            uiTextField.setForeground(defaultTextColor);
                        } else {
                            uiTextField.setForeground(placeHolderColor);
                        }
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                    }
                });
            }

            public JTextField getTextField() {
                return this.uiTextField;
            }
        }
        return new JTextFieldDecorator(jFormattedTextField, string).getTextField();
    }

    public static ValueModel createIntToEnumConverter(ValueModel valueModel, final Class clazz) {
        return new AbstractConverter(valueModel){

            public Object convertFromSubject(Object object) {
                if (object instanceof Integer) {
                    return EnumUtil.getEnum(clazz, (int)((Integer)object));
                }
                return null;
            }

            public void setValue(Object object) {
                if (object != null && object instanceof CVEnum) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object);
                    this.subject.setValue((Object)((CVEnum)object).getEnumValue());
                }
            }
        };
    }

    public static ValueModel createIdNameItemConverter(ValueModel valueModel, final List list) {
        return new AbstractConverter(valueModel){

            public Object convertFromSubject(Object object) {
                if (list == null || object == null) {
                    return 0;
                }
                for (Object e : list) {
                    if (((IdNameItem)e).getId() != ((Integer)object).intValue()) continue;
                    return e;
                }
                return null;
            }

            public void setValue(Object object) {
                if (object != null) {
                    this.subject.setValue((Object)((IdNameItem)object).getId());
                } else {
                    this.subject.setValue((Object)0);
                }
            }
        };
    }

    public static JNumericTextField createNumericTF(ValueModel valueModel, int n, int n2) {
        return UIFactory.createNumericTF(valueModel, n, n2, null);
    }

    public static JNumericTextField createNumericTF(ValueModel valueModel, int n, int n2, String string) {
        return UIFactory.createNumericTF("", valueModel, n, n2, string);
    }

    public static JNumericTextField createNumericTF(String string, ValueModel valueModel, int n, int n2, String string2) {
        JNumericTextField jNumericTextField = new JNumericTextField(string, new NumericDocument(n, n2), string2);
        Bindings.bind((JTextField)jNumericTextField.getTextField(), (ValueModel)new AbstractConverter(valueModel){

            public Object convertFromSubject(Object object) {
                if (object == null) {
                    return "";
                }
                return "" + object;
            }

            public void setValue(Object object) {
                if (object == null) {
                    this.subject.setValue(null);
                }
                try {
                    this.subject.setValue((Object)Integer.parseInt((String)object));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return jNumericTextField;
    }

    public static JNumericTextField2 createLongNumericTF(ValueModel valueModel, long l, long l2) {
        return UIFactory.createLongNumericTF(valueModel, l, l2, null);
    }

    public static JNumericTextField2 createLongNumericTF(ValueModel valueModel, long l, long l2, String string) {
        JNumericTextField2 jNumericTextField2 = new JNumericTextField2("", new NumericDocument2(l, l2), string);
        Bindings.bind((JTextField)jNumericTextField2.getTextField(), (ValueModel)new AbstractConverter(valueModel){

            public Object convertFromSubject(Object object) {
                if (object == null) {
                    return "";
                }
                return "" + object;
            }

            public void setValue(Object object) {
                if (object == null) {
                    this.subject.setValue(null);
                }
                try {
                    this.subject.setValue((Object)Long.parseLong((String)object));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return jNumericTextField2;
    }

    public static SList createList(ValueModel valueModel) {
        SList sList = new SList();
        return sList;
    }

    public static SList createList(SelectionInList selectionInList) {
        SList sList = new SList();
        Bindings.bind((JList)sList, (SelectionInList)selectionInList);
        return sList;
    }

    public static HourMinComponent createHourMinsChooser(ValueModel valueModel) {
        HourMinComponent hourMinComponent = new HourMinComponent();
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)hourMinComponent, (String)"time");
        return hourMinComponent;
    }

    public static TimeChooser createTimeChooser(ValueModel valueModel) {
        TimeChooser timeChooser = new TimeChooser();
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)timeChooser, (String)"unixTime");
        return timeChooser;
    }

    public static TimeChooser createTimeChooser(ValueModel valueModel, int n) {
        TimeChooser timeChooser = new TimeChooser(n);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)timeChooser, (String)"unixTime");
        return timeChooser;
    }

    public static ControlledTextField createControlledTextField(ValueModel valueModel, boolean bl) {
        ControlledTextField controlledTextField = new ControlledTextField("", "", 128);
        Bindings.bind((JTextField)controlledTextField, (ValueModel)valueModel, (boolean)bl);
        return controlledTextField;
    }

    public static ControlledTextField createControlledTextField(ValueModel valueModel, int n, boolean bl) {
        ControlledTextField controlledTextField = new ControlledTextField("", "", n);
        Bindings.bind((JTextField)controlledTextField, (ValueModel)valueModel, (boolean)bl);
        return controlledTextField;
    }

    public static JButton createLinkButton(Action action) {
        JideButton jideButton = new JideButton(action);
        jideButton.setButtonStyle(3);
        jideButton.setOpaque(false);
        jideButton.setHorizontalAlignment(10);
        jideButton.setRequestFocusEnabled(true);
        jideButton.setFocusable(true);
        jideButton.setCursor(Cursor.getPredefinedCursor(12));
        return jideButton;
    }

    public static JPasswordField createCVPasswordField(ValueModel valueModel) {
        return UIFactory.createPasswordField((ValueModel)new ValueModelUtil.ByteArrayConverter(valueModel));
    }

    public static JPasswordField createCVPasswordField(ValueModel valueModel, boolean bl) {
        JPasswordField jPasswordField = UIFactory.createPasswordField((ValueModel)new ValueModelUtil.ByteArrayConverter(valueModel), (boolean)bl);
        return jPasswordField;
    }

    public static JButton createToolBarButton(Icon icon, Action action) {
        JideButton jideButton = new JideButton(action);
        jideButton.setToolTipText(jideButton.getText());
        jideButton.setText(null);
        jideButton.setIcon(icon);
        return jideButton;
    }

    public static CalendarComboBox createDateChooser(ValueModel valueModel) {
        return UIFactory.createDateChooser(valueModel, false);
    }

    public static CalendarComboBox createDateChooser(ValueModel valueModel, boolean bl) {
        CalendarComboBox calendarComboBox = new CalendarComboBox(bl);
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)calendarComboBox.getPopupCalendar(), (String)"time");
        return calendarComboBox;
    }

    public static DescriptionPanel createDescriptionUI(ValueModel valueModel) {
        DescriptionPanel descriptionPanel = new DescriptionPanel();
        PropertyConnector.connectAndUpdate((ValueModel)valueModel, (Object)descriptionPanel, (String)"description");
        return descriptionPanel;
    }

    public static <T> CNListSelectionPanel createDnDPanel(ValueModel valueModel, List<T> list, boolean bl, boolean bl2, DefaultListCellRenderer defaultListCellRenderer) {
        return UIFactory.createDnDPanel(valueModel, list, bl, bl2, defaultListCellRenderer, null);
    }

    public static <T> CNListSelectionPanel createDnDPanel(final ValueModel valueModel, List<T> list, boolean bl, boolean bl2, DefaultListCellRenderer defaultListCellRenderer, WRActionListener wRActionListener) {
        int n = 100;
        int n2 = 15;
        CNListSelectionPanel cNListSelectionPanel = new CNListSelectionPanel(bl, bl2, wRActionListener);
        ArrayList arrayList = (ArrayList)valueModel.getValue();
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayList<T> arrayList2 = new ArrayList<T>();
        if (list != null) {
            arrayList2.addAll(list);
        }
        arrayList2.removeAll(arrayList);
        SortedListModel sortedListModel = (SortedListModel)cNListSelectionPanel.availableList.getModel();
        for (Object object : arrayList2) {
            sortedListModel.addElement(object);
        }
        final SortedListModel sortedListModel2 = (SortedListModel)cNListSelectionPanel.selectedList.getModel();
        for (Object e : arrayList) {
            sortedListModel2.addElement(e);
        }
        cNListSelectionPanel.selectedList.setFixedCellHeight(n2);
        cNListSelectionPanel.availableList.setFixedCellHeight(n2);
        cNListSelectionPanel.selectedList.setFixedCellWidth(n);
        cNListSelectionPanel.availableList.setFixedCellWidth(n);
        if (defaultListCellRenderer != null) {
            cNListSelectionPanel.selectedList.setCellRenderer(defaultListCellRenderer);
            cNListSelectionPanel.availableList.setCellRenderer(defaultListCellRenderer);
        }
        cNListSelectionPanel.selectedList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                this.updateModel();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.updateModel();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                this.updateModel();
            }

            private void updateModel() {
                valueModel.setValue(Arrays.asList(sortedListModel2.toArray()));
            }
        });
        return cNListSelectionPanel;
    }

    public static <T> CNFilterListSelectionPanel createCNFilterDnDPanel(ValueModel valueModel, List<T> list, boolean bl, boolean bl2, DefaultListCellRenderer defaultListCellRenderer) {
        return UIFactory.createCNFilterDnDPanel(valueModel, list, bl, bl2, defaultListCellRenderer, null, null);
    }

    public static <T> CNFilterListSelectionPanel createCNFilterDnDPanel(final ValueModel valueModel, List<T> list, boolean bl, boolean bl2, DefaultListCellRenderer defaultListCellRenderer, WRActionListener wRActionListener, CNFilterListSelectionPanel cNFilterListSelectionPanel) {
        ArrayList arrayList;
        int n = 100;
        int n2 = 15;
        if (cNFilterListSelectionPanel == null) {
            cNFilterListSelectionPanel = new CNFilterListSelectionPanel(bl, bl2, wRActionListener, true);
        }
        if ((arrayList = (ArrayList)valueModel.getValue()) == null) {
            arrayList = new ArrayList();
        }
        ArrayList<T> arrayList2 = new ArrayList<T>();
        if (list != null) {
            arrayList2.addAll(list);
        }
        arrayList2.removeAll(arrayList);
        SortedListModel sortedListModel = (SortedListModel)cNFilterListSelectionPanel.availableList.getActualModel();
        for (Object object : arrayList2) {
            sortedListModel.addElement(object);
        }
        final SortedListModel sortedListModel2 = (SortedListModel)cNFilterListSelectionPanel.selectedList.getActualModel();
        for (Object e : arrayList) {
            sortedListModel2.addElement(e);
        }
        cNFilterListSelectionPanel.selectedList.setFixedCellHeight(n2);
        cNFilterListSelectionPanel.availableList.setFixedCellHeight(n2);
        cNFilterListSelectionPanel.selectedList.setFixedCellWidth(n);
        cNFilterListSelectionPanel.availableList.setFixedCellWidth(n);
        if (defaultListCellRenderer != null) {
            cNFilterListSelectionPanel.selectedList.setCellRenderer(defaultListCellRenderer);
            cNFilterListSelectionPanel.availableList.setCellRenderer(defaultListCellRenderer);
        }
        cNFilterListSelectionPanel.selectedList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                this.updateModel();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.updateModel();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                this.updateModel();
            }

            private void updateModel() {
                valueModel.setValue(Arrays.asList(sortedListModel2.toArray()));
            }
        });
        return cNFilterListSelectionPanel;
    }

    public static JComponent createTimeRangePanel(JRadioButton jRadioButton, Object object, String string, String string2) {
        TimeRangePanel timeRangePanel = new TimeRangePanel(true, false, true, jRadioButton);
        return timeRangePanel;
    }

    public static JComponent createTimeRangePanelFromBrowser(Object object, String string, String string2) {
        return UIFactory.createTimeRangePanelFromBrowser(object, string, string2, false);
    }

    public static TimeRangePanel createTimeRangePanelFromBrowser(Object object, String string, String string2, boolean bl) {
        TimeRangePanel timeRangePanel = new TimeRangePanel(true, true, true, true, bl);
        PropertyConnector.connect((Object)object, (String)string, (Object)timeRangePanel, (String)"startTime");
        PropertyConnector.connect((Object)object, (String)string2, (Object)timeRangePanel, (String)"endTime");
        return timeRangePanel;
    }

    public static JComponent createTimeRangePanelForFilter(Object object, String string, String string2) {
        TimeRangePanel timeRangePanel = new TimeRangePanel(true, true, true, true);
        timeRangePanel.setBorder(BorderFactory.createEtchedBorder());
        PropertyConnector.connect((Object)object, (String)string, (Object)timeRangePanel, (String)"startTime");
        PropertyConnector.connect((Object)object, (String)string2, (Object)timeRangePanel, (String)"endTime");
        return timeRangePanel;
    }

    public static JComponent createClientBrowse(IContext iContext, ValueModel valueModel) {
        JTextField jTextField = UIFactory.createTextField((ValueModel)valueModel);
        JPanel jPanel = new JPanel(new GridBagLayout());
        LayoutUtils.addRow(jPanel, (JComponent)jTextField, (JComponent)new JButton(new BrowseAction(jTextField, iContext)));
        return jPanel;
    }

    public static JCheckBox createCheckBox(Object object, String string, String string2) {
        CVPresentationModel<Object> cVPresentationModel = new CVPresentationModel<Object>(object);
        AbstractValueModel abstractValueModel = cVPresentationModel.getModel(string);
        return UIFactory.createCheckBox((ValueModel)abstractValueModel, (String)string2);
    }

    public static JRadioButton createRadioButton(Object object, Object object2, String string, String string2) {
        CVPresentationModel<Object> cVPresentationModel = new CVPresentationModel<Object>(object);
        AbstractValueModel abstractValueModel = cVPresentationModel.getModel(string);
        return UIFactory.createRadioButton((ValueModel)abstractValueModel, object2, string2);
    }

    public static DescriptionPanel createDescriptionUI(Object object, String string) {
        CVPresentationModel<Object> cVPresentationModel = new CVPresentationModel<Object>(object);
        AbstractValueModel abstractValueModel = cVPresentationModel.getModel(string);
        return UIFactory.createDescriptionUI((ValueModel)abstractValueModel);
    }

    public static NameTextField createNameTextField(Object object, String string, double d, String string2) {
        NameTextField nameTextField = new NameTextField(d, string2);
        CVPresentationModel<Object> cVPresentationModel = new CVPresentationModel<Object>(object);
        AbstractValueModel abstractValueModel = cVPresentationModel.getModel(string);
        Bindings.bind((JTextField)nameTextField, (ValueModel)abstractValueModel);
        return nameTextField;
    }

    public static FSTextField createFSTextField(Object object, String string, String string2, int n) {
        FSTextField fSTextField = new FSTextField(string2, n);
        CVPresentationModel<Object> cVPresentationModel = new CVPresentationModel<Object>(object);
        AbstractValueModel abstractValueModel = cVPresentationModel.getModel(string);
        Bindings.bind((JTextField)fSTextField, (ValueModel)abstractValueModel);
        return fSTextField;
    }

    public static FSTextField createControlledFSTextField(ValueModel valueModel, String string, int n, int n2, boolean bl) {
        FSTextField fSTextField = new FSTextField(string, n);
        fSTextField.setMaximumChars(n2);
        Bindings.bind((JTextField)fSTextField, (ValueModel)valueModel, (boolean)bl);
        return fSTextField;
    }

    public static ListCellRenderer getI18nListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof I18nAware) {
                    object = ((I18nAware)object).getI18n();
                } else if (object instanceof Enum) {
                    object = EnumUtil.getI18n((Enum)object);
                } else if (object == null) {
                    object = " ";
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        };
    }

    public static class BrowseAction
    extends AbstractAction {
        private JTextField fileLocation = null;
        private IContext context = null;
        private boolean dirOnly = false;

        public BrowseAction(JTextField jTextField, IContext iContext) {
            this(jTextField, iContext, CteStringBank.Browse.getI18n());
        }

        public BrowseAction(JTextField jTextField, IContext iContext, String string) {
            super(string);
            this.fileLocation = jTextField;
            this.context = iContext;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ClientBrowseAction clientBrowseAction = Application.instance().getClientBrowseActionBean();
            if (this.context != null) {
                clientBrowseAction.setContext(this.context);
            }
            clientBrowseAction.setDirOnly(this.dirOnly);
            PropertyConnector.connect((Object)this.fileLocation, (String)"text", (Object)clientBrowseAction, (String)"srcPath");
            clientBrowseAction.actionPerformed(actionEvent);
            this.fileLocation.grabFocus();
        }

        public void setContext(IContext iContext) {
            this.context = iContext;
        }

        public void setDirOnly(boolean bl) {
            this.dirOnly = bl;
        }
    }
}

