/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import commvault.cte.CteStringBank;
import commvault.cte.alert.AlertConstants;
import commvault.cte.alert.model.Alert;
import commvault.cte.alert.model.AlertNotifMsg;
import commvault.cte.alert.model.RunCommand;
import commvault.cte.common.ui.ChangeUserAccountDialog;
import commvault.cte.common.ui.NetBrowsePath;
import commvault.cte.component.FSTextField;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.PropertyDialog;
import commvault.cte.component.SComboBox;
import commvault.cte.component.SortedComboBoxModel;
import commvault.cte.component.TogglePanel;
import commvault.cte.component.Utilities;
import commvault.cte.component.events.CTEAction;
import commvault.cte.component.wizard.AbstractWizardPage;
import commvault.cte.component.wizard.IWizardController;
import commvault.cte.component.wizard.WizardDialog;
import commvault.cte.net.IdIdNameItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class AlertNotifTypeSelectionPage
extends AbstractWizardPage {
    static final String prefix = "cte.alert.AlertNotifTypeSelectionPage";
    private static final ImageIcon DOWN_ICON = Utilities.getIcon("down.GIF");
    private static final ImageIcon DOWN_ICON12 = Utilities.getIcon("down_red.GIF");
    private static final ImageIcon CHECK_ICON = Utilities.getIcon("check.GIF");
    private boolean initialized = false;
    TextMsgNotifPanel emailPanel = null;
    TextMsgNotifPanel snmpPanel = null;
    TextMsgNotifPanel eventViewerPanel = null;
    BrowseNotifPanel runCmdPanel = null;
    JTabbedPane tabbedPane = new JTabbedPane();
    int remoteCmdAssoc = 0;
    private final int ALERT_ID = 1241513996;
    private final int REPORT_HIST_ID = 1241514422;
    private final int REPORT_ID = 1241514421;
    private final int VM_NAME = 1241514774;

    public AlertNotifTypeSelectionPage(WizardDialog wizardDialog) {
        super(wizardDialog);
        this.setTitle(CteStringBank.Notification_Type3s4_Selection.getI18n());
        this.createHelpLink();
    }

    public static String getNotifTypeAsString(int n) {
        return AlertConstants.TABNAMES[(int)(Math.log(n) / Math.log(2.0))];
    }

    private void initComponents() {
        this.componentPanel = new JPanel();
        this.componentPanel.setLayout(new BorderLayout());
        this.emailPanel = new TextMsgNotifPanel(1);
        this.snmpPanel = new TextMsgNotifPanel(4);
        this.eventViewerPanel = new TextMsgNotifPanel(8);
        this.runCmdPanel = new BrowseNotifPanel(16);
        this.tabbedPane.addTab(AlertConstants.EMAIL, this.emailPanel);
        this.tabbedPane.addTab(AlertConstants.SNMP, this.snmpPanel);
        if (!this.getAlertDetails().getAlertServerObject().isSNMPEnabled()) {
            Utilities.addRow((Container)this.snmpPanel, null, (JComponent)new JLabel(CteStringBank.AlertNotifTypeSelectionPage_0.getI18n()), true);
        }
        this.tabbedPane.addTab(AlertConstants.EVENTVIEWER, this.eventViewerPanel);
        this.tabbedPane.addTab(AlertConstants.RUNCMD, this.runCmdPanel);
        this.setTabsEnabledState();
        this.componentPanel.add((Component)this.tabbedPane, "Center");
        this.remoteCmdAssoc = this.getAlertDetails().getRemoteCmdAssoc();
    }

    private Alert getAlertDetails() {
        return (Alert)this.getWizardController().getData();
    }

    private void setTabsEnabledState() {
        int n = this.getAlertDetails().getAlertType().getNotifTypesAllowed();
        for (int i = 0; i < AlertConstants.TABNAMES.length; ++i) {
            int n2 = this.getTwoPowerOf(i);
            boolean bl = (n & n2) > 0;
            int n3 = i;
            if (i > 0) {
                --n3;
            }
            if (i == 1) continue;
            this.tabbedPane.setEnabledAt(n3, bl);
        }
        this.tabbedPane.setEnabledAt(this.tabbedPane.indexOfTab(AlertConstants.SNMP), this.getAlertDetails().getAlertServerObject().isSNMPInstalled());
    }

    private int getTwoPowerOf(int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (i == 1) continue;
            n2 *= 2;
        }
        return n2;
    }

    @Override
    public boolean checkValid() {
        if (!(this.emailPanel.isRegularNotifSelected() || this.snmpPanel.isRegularNotifSelected() || this.eventViewerPanel.isRegularNotifSelected() || this.runCmdPanel.isRegularNotifSelected())) {
            return false;
        }
        return !this.getAlertDetails().isEscalationSelected() || this.emailPanel.isEscalatedNotifSelected() || this.snmpPanel.isEscalatedNotifSelected() || this.eventViewerPanel.isEscalatedNotifSelected() || this.runCmdPanel.isEscalatedNotifSelected();
    }

    private void setTabIcons() {
        int n = this.getWizardController().getMode();
        if (n == 2) {
            this.emailPanel.setTabIcon();
            this.snmpPanel.setTabIcon();
            this.eventViewerPanel.setTabIcon();
            this.runCmdPanel.setTabIcon();
        }
    }

    @Override
    public void activated() {
        if (!this.initialized || this.remoteCmdAssoc != this.getAlertDetails().getRemoteCmdAssoc()) {
            this.removeAll();
            this.tabbedPane.removeAll();
            this.initComponents();
            this.addComponents();
            this.initialized = true;
            this.setTabIcons();
        } else {
            this.setTabsEnabledState();
            this.emailPanel.setInitialState();
            this.snmpPanel.setInitialState();
            this.eventViewerPanel.setInitialState();
            this.runCmdPanel.setInitialState();
            this.setTabIcons();
        }
    }

    @Override
    public void deactivated() {
        String string;
        if (this.wizard.getActionPerformed() != 1 && (string = this.runCmdPanel.checkForValidity()) != null) {
            throw new IllegalStateException(string);
        }
        this.fillRequestObject((Alert)this.getWizardController().getData());
    }

    public void fillRequestObject(Alert alert) {
        if (this.hasChanged()) {
            alert.setModificationBit(4);
        }
        this.emailPanel.fillRequestObject(alert);
        this.snmpPanel.fillRequestObject(alert);
        this.eventViewerPanel.fillRequestObject(alert);
        this.runCmdPanel.fillRequestObject(alert);
    }

    private boolean hasChanged() {
        return this.hasRegularNotifMsgListChanged() || this.hasEscalatedNotifMsgListChanged();
    }

    private boolean hasRegularNotifMsgListChanged() {
        return this.emailPanel.hasRegularNotifMsgChanged() || this.snmpPanel.hasRegularNotifMsgChanged() || this.eventViewerPanel.hasRegularNotifMsgChanged();
    }

    private boolean hasEscalatedNotifMsgListChanged() {
        if (!this.getAlertDetails().isEscalationSelected()) {
            return false;
        }
        return this.emailPanel.hasEscalatedNotifMsgChanged() || this.snmpPanel.hasEscalatedNotifMsgChanged() || this.eventViewerPanel.hasEscalatedNotifMsgChanged();
    }

    public int getTabIndex(String string) {
        for (int i = 0; i < AlertConstants.TABNAMES.length; ++i) {
            if (!AlertConstants.TABNAMES[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getTabIndex(int n) {
        if (n == 1) {
            return 0;
        }
        return (int)(Math.log(n) / Math.log(2.0)) - 1;
    }

    private void clearNotifMsgs(int n, Alert alert, boolean bl) {
        List list = alert.getNotifMsgs();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<AlertNotifMsg> arrayList = new ArrayList<AlertNotifMsg>();
        for (AlertNotifMsg alertNotifMsg : list) {
            if (bl) {
                if (alertNotifMsg.getEsclationLevel() != 2 || alertNotifMsg.getNotifType() != n) continue;
                arrayList.add(alertNotifMsg);
                continue;
            }
            if (alertNotifMsg.getEsclationLevel() != 1 || alertNotifMsg.getNotifType() != n) continue;
            arrayList.add(alertNotifMsg);
        }
        list.removeAll(arrayList);
    }

    private void createHelpLink() {
        String string = "main-nt";
        String string2 = "english-en-us-" + string + "-NO_TOCHEADINGS.txt-AlertWizard(NotificationTypesSelection)";
        this.setHelpLink(string2);
    }

    public TextMsgNotifPanel getEmailPanel() {
        return this.emailPanel;
    }

    public void setEmailPanel(TextMsgNotifPanel textMsgNotifPanel) {
        this.emailPanel = textMsgNotifPanel;
    }

    public class BrowseComponent
    extends JPanel
    implements ActionListener,
    NetBrowsePath {
        JCheckBox toggleCheckBox = null;
        JLabel loginNameLabel = new JLabel();
        JButton changeUserButton = new JButton(CteStringBank.Change666.getI18n());
        JButton browseCmdParams = new JButton("Browse");
        JRadioButton useLocalDriveRadioButton = new JRadioButton(CteStringBank.Use_Local_Drive.getI18n(), true);
        JRadioButton useNetworkShareRadioButton = new JRadioButton(CteStringBank.Use_Network_Share.getI18n());
        FSTextField fileLocationTextField = FSTextField.getTextField(true);
        JTextField argumentsTextField = new JTextField();
        JButton browseButton = new JButton("Browse");
        TogglePanel togglePanel = null;
        private String ntPassword;
        private String ntUser;
        private boolean accountSet;
        int category;
        JCheckBox executeDM = new JCheckBox(CteStringBank.Execute_Data_Archiver.getI18n());

        public BrowseComponent(JCheckBox jCheckBox, int n) {
            this.setLayout(new GridBagLayout());
            this.category = n;
            this.toggleCheckBox = jCheckBox;
            this.togglePanel = new TogglePanel(this.toggleCheckBox);
            this.togglePanel.setLayout(new GridBagLayout());
            this.useLocalDriveRadioButton.setMnemonic('L');
            this.useNetworkShareRadioButton.setMnemonic('W');
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.useLocalDriveRadioButton);
            buttonGroup.add(this.useNetworkShareRadioButton);
            Insets insets = this.browseButton.getMargin();
            insets.left = 4;
            insets.right = 4;
            this.browseButton.setMargin(insets);
            this.browseCmdParams.setMargin(insets);
            this.browseButton.addActionListener(this);
            this.changeUserButton.addActionListener(this);
            this.browseCmdParams.addActionListener(this);
            JLabel jLabel = new JLabel(CteStringBank.Impersonate_User7.getI18n());
            jLabel.setLabelFor(this.changeUserButton);
            jLabel.setDisplayedMnemonic('U');
            if (AlertNotifTypeSelectionPage.this.getAlertDetails().getRemoteCmdAssoc() > 0) {
                LayoutUtils.addRow(this.togglePanel, this.executeDM);
            } else {
                this.togglePanel.add((Component)jLabel, Utilities.getLeftConstraints());
                this.togglePanel.add((Component)this.loginNameLabel, Utilities.getLeftConstraints(true));
                this.togglePanel.add((Component)this.changeUserButton, Utilities.getRightConstraints());
                Utilities.addRow((Container)this.togglePanel, (JComponent)this.useLocalDriveRadioButton, (JComponent)this.useNetworkShareRadioButton, true);
                jLabel = new JLabel(CteStringBank.Command_Script_Location.getI18n());
                jLabel.setLabelFor(this.fileLocationTextField);
                jLabel.setDisplayedMnemonic('P');
                this.togglePanel.add((Component)jLabel, Utilities.getLeftConstraints());
                this.togglePanel.add((Component)this.fileLocationTextField, Utilities.getLeftConstraints(true));
                this.togglePanel.add((Component)this.browseButton, Utilities.getRightConstraints());
                jLabel = new JLabel(CteStringBank.Arguments7.getI18n());
                jLabel.setLabelFor(this.argumentsTextField);
                jLabel.setDisplayedMnemonic(CteStringBank.Arguments7.getI18n().charAt(0));
                this.togglePanel.add((Component)jLabel, Utilities.getLeftConstraints());
                this.togglePanel.add((Component)this.argumentsTextField, Utilities.getLeftConstraints(true));
                this.togglePanel.add((Component)this.browseCmdParams, Utilities.getRightConstraints());
                AbstractDocument abstractDocument = (AbstractDocument)this.argumentsTextField.getDocument();
                abstractDocument.setDocumentFilter(new DocumentFilter(){

                    @Override
                    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (string.equals("\n")) {
                            super.insertString(filterBypass, n, " ", attributeSet);
                        } else {
                            super.insertString(filterBypass, n, string, attributeSet);
                        }
                    }

                    @Override
                    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                        if (string.equals("\n")) {
                            super.replace(filterBypass, n, n2, " ", attributeSet);
                        } else {
                            super.replace(filterBypass, n, n2, string, attributeSet);
                        }
                    }

                    @Override
                    public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                        super.remove(filterBypass, n, n2);
                    }
                });
            }
            Utilities.addRow((Container)this, null, (JComponent)this.togglePanel, true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.browseButton) {
                AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertServerObject().browseScriptPath(this.useLocalDriveRadioButton.isSelected(), AlertNotifTypeSelectionPage.this.getAlertDetails(), this, "this File needs to be removed");
            } else if (actionEvent.getSource() == this.changeUserButton) {
                this.changeNTUserAction();
            } else if (actionEvent.getSource() == this.browseCmdParams) {
                this.browseCmdParams(this.argumentsTextField.getDocument());
            }
        }

        private void browseCmdParams(Document document) {
            final JTextArea jTextArea = new JTextArea(document);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            PropertyDialog propertyDialog = new PropertyDialog(AlertNotifTypeSelectionPage.this.wizard, CteStringBank.Run_Command_Script_Arguments.getI18n(), true){
                {
                    this.buttonPane.removeAll();
                    this.buttonPane.setLayout(new FlowLayout(2));
                    this.okButton.setText(CteStringBank.Close.getI18n());
                    this.buttonPane.add(this.okButton);
                }
            };
            JPanel jPanel = new JPanel(new GridBagLayout());
            Vector vector = AlertNotifTypeSelectionPage.this.getAlertDetails().getTokensList(16);
            final SComboBox sComboBox = new SComboBox(vector);
            JButton jButton = new JButton(CteStringBank.Add_Token.getI18n());
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Caret caret = jTextArea.getCaret();
                    Document document = jTextArea.getDocument();
                    try {
                        document.insertString(caret.getDot(), sComboBox.getSelectedItem().toString(), null);
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
            Utilities.addRow(jPanel, (JComponent)sComboBox, (JComponent)jButton);
            Utilities.fillRemaining(jPanel, jScrollPane);
            propertyDialog.getContentPane().add(jPanel);
            jTextArea.setPreferredSize(new Dimension(300, 200));
            propertyDialog.pack();
            propertyDialog.setVisible(true);
        }

        private boolean setUpdated(int n) {
            RunCommand runCommand = AlertNotifTypeSelectionPage.this.getAlertDetails().getRunCommand(n);
            if (runCommand.getImpersonateUser() != 0) {
                this.loginNameLabel.setText(runCommand.getLoginName());
                this.ntUser = runCommand.getLoginName();
            }
            this.useNetworkShareRadioButton.setSelected(runCommand.getUseNetworkShare() != 0);
            this.fileLocationTextField.setText(runCommand.getCmdPath());
            this.argumentsTextField.setText(runCommand.getArguments());
            if (AlertNotifTypeSelectionPage.this.getAlertDetails().getRemoteCmdAssoc() > 0 && this.fileLocationTextField.getText().length() > 0 && this.argumentsTextField.getText().length() > 0) {
                this.executeDM.setSelected(true);
            }
            return true;
        }

        public String checkForValidity() {
            String string = null;
            if (AlertNotifTypeSelectionPage.this.getAlertDetails().getRemoteCmdAssoc() > 0) {
                if (!this.executeDM.isSelected()) {
                    return CteStringBank.Selct_execute_data_migrator_option.getI18n();
                }
                return string;
            }
            if (this.fileLocationTextField.getText().length() != 0) {
                if (this.useNetworkShareRadioButton.isSelected() && !this.fileLocationTextField.getText().startsWith("\\\\")) {
                    this.fileLocationTextField.requestFocus();
                    return CteStringBank.cte_alert_AlertNotifTypeSelectionPage_enterNetworkPath.getI18n();
                }
                if (this.useLocalDriveRadioButton.isSelected() && !this.fileLocationTextField.validatePath(this.fileLocationTextField.getText().trim(), this.fileLocationTextField.getSeparator())) {
                    this.fileLocationTextField.requestFocus();
                    return CteStringBank.cte_alert_AlertNotifTypeSelectionPage_enterLocalPath.getI18n();
                }
            } else {
                this.fileLocationTextField.requestFocus();
                return CteStringBank.Enter_a_valid_command_script_location.getI18n();
            }
            return string;
        }

        public void fillRequestObject(RunCommand runCommand) {
            if (this.loginNameLabel.getText().length() != 0) {
                runCommand.setImpersonateUser(1);
                runCommand.setLoginName(this.loginNameLabel.getText());
                if (this.ntPassword != null) {
                    runCommand.setPassword(this.ntPassword.getBytes());
                }
            } else {
                runCommand.setImpersonateUser(0);
            }
            if (this.accountSet) {
                AlertNotifTypeSelectionPage.this.getAlertDetails().setModificationBit(this.category == 1 ? 16 : 64);
                AlertNotifTypeSelectionPage.this.getAlertDetails().setModificationBit(32);
            }
            runCommand.setUseNetworkShare(this.useNetworkShareRadioButton.isSelected() ? 1 : 0);
            runCommand.setCmdPath(this.fileLocationTextField.getText().trim());
            runCommand.setArguments(this.argumentsTextField.getText().trim());
            runCommand.setDomain("");
        }

        private String getArgumentToken(int n) {
            Vector vector = AlertNotifTypeSelectionPage.this.getAlertDetails().getTokensList(16);
            for (int i = 0; i < vector.size(); ++i) {
                IdIdNameItem idIdNameItem = (IdIdNameItem)vector.get(i);
                if (idIdNameItem.getFirstId() != n) continue;
                return idIdNameItem.getName();
            }
            return "";
        }

        @Override
        public String getUserName() {
            return this.ntUser;
        }

        @Override
        public String getUserPassword() {
            return this.ntPassword;
        }

        @Override
        public void setSrcPath(Object object) {
            this.fileLocationTextField.setText(object.toString());
        }

        public void changeNTUserAction() {
            ChangeUserAccountDialog changeUserAccountDialog = new ChangeUserAccountDialog(this.ntUser, false, AlertNotifTypeSelectionPage.this.wizard);
            changeUserAccountDialog.setVisible(true);
            if (changeUserAccountDialog.isCancelled()) {
                return;
            }
            this.accountSet = true;
            if (changeUserAccountDialog.isNoUserOptionSelected()) {
                this.setNtUserName(null);
                this.ntPassword = null;
            } else {
                this.ntUser = changeUserAccountDialog.getUserName();
                this.setNtUserName(changeUserAccountDialog.getUserName());
                this.ntPassword = changeUserAccountDialog.getPassword();
            }
        }

        public void setNtUserName(String string) {
            this.loginNameLabel.setText(string == null ? "" : string);
            this.ntUser = string;
        }
    }

    public class BrowseNotifPanel
    extends JPanel
    implements ActionListener {
        private int notifType;
        JCheckBox regularCheckBox = null;
        JCheckBox escalationCheckBox = null;
        String notifMethod;
        BrowseComponent regularNotifPanel = null;
        BrowseComponent escalatedNotifPanel = null;

        public BrowseNotifPanel(int n) {
            this.setLayout(new GridBagLayout());
            this.notifType = n;
            this.notifMethod = AlertNotifTypeSelectionPage.getNotifTypeAsString(n);
            this.regularCheckBox = new JCheckBox(MessageFormat.format(CteStringBank.cte_alert_AlertNotifTypeSelectionPage_selectregnotif.getI18n(), this.notifMethod));
            this.escalationCheckBox = new JCheckBox(MessageFormat.format(CteStringBank.cte_alert_AlertNotifTypeSelectionPage_selectregnotif.getI18n(), this.notifMethod));
            this.regularCheckBox.addActionListener(this);
            this.escalationCheckBox.addActionListener(this);
            this.regularNotifPanel = new BrowseComponent(this.regularCheckBox, 1);
            this.escalatedNotifPanel = new BrowseComponent(this.escalationCheckBox, 2);
            Utilities.addRow((Container)this, null, (JComponent)this.regularNotifPanel, true);
            Utilities.addRow((Container)this, null, (JComponent)this.escalatedNotifPanel, true);
            Utilities.fillRemaining(this);
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(1)) {
                    this.regularCheckBox.setSelected(true);
                } else {
                    this.regularCheckBox.setSelected(false);
                }
                if (this.initialSelectionState(2)) {
                    this.escalationCheckBox.setSelected(true);
                } else {
                    this.escalationCheckBox.setSelected(false);
                }
            }
            this.setInitialState();
        }

        private void setInitialState() {
            this.escalatedNotifPanel.setVisible(AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected());
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(1)) {
                    this.regularNotifPanel.setUpdated(1);
                }
                if (this.initialSelectionState(2)) {
                    this.escalatedNotifPanel.setUpdated(2);
                } else if (AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected()) {
                    this.escalationCheckBox.setEnabled(true);
                } else {
                    this.escalationCheckBox.setEnabled(false);
                }
            } else if (!AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected()) {
                this.escalationCheckBox.setEnabled(false);
            } else {
                this.escalationCheckBox.setEnabled(true);
            }
        }

        private boolean isRegularNotifSelected() {
            return this.regularCheckBox.isSelected();
        }

        private boolean isEscalatedNotifSelected() {
            return this.escalationCheckBox.isSelected();
        }

        public void fillRequestObject(Alert alert) {
            int n;
            if (this.hasRegularNotifMsgChanged() || this.hasEscalatedNotifMsgChanged()) {
                AlertNotifTypeSelectionPage.this.getAlertDetails().setModificationBit(16);
            }
            RunCommand runCommand = alert.getRunCommand(1);
            runCommand.setEnabled(this.regularCheckBox.isSelected() ? 1 : 0);
            if (this.regularCheckBox.isSelected()) {
                this.regularNotifPanel.fillRequestObject(runCommand);
            } else {
                runCommand.clear();
            }
            if (AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected() && this.escalationCheckBox.isSelected()) {
                runCommand = alert.getRunCommand(2);
                runCommand.setEnabled(this.escalationCheckBox.isSelected() ? 1 : 0);
                this.escalatedNotifPanel.fillRequestObject(runCommand);
            } else {
                runCommand = alert.getRunCommand(2);
                if (runCommand != null) {
                    runCommand.clear();
                }
            }
            if (this.regularCheckBox.isSelected()) {
                n = alert.getAlertDetails().getNotifType() | this.notifType;
                alert.getAlertDetails().setNotifType(n);
            } else {
                n = alert.getAlertDetails().getNotifType() & (0xFFFF ^ this.notifType);
                alert.getAlertDetails().setNotifType(n);
                AlertNotifTypeSelectionPage.this.clearNotifMsgs(this.notifType, alert, false);
            }
            if (this.escalationCheckBox.isSelected()) {
                n = alert.getAlertDetails().getEscNotifType() | this.notifType;
                alert.getAlertDetails().setEscNotifType(n);
            } else {
                n = alert.getAlertDetails().getEscNotifType() & (0xFFFF ^ this.notifType);
                alert.getAlertDetails().setEscNotifType(n);
                AlertNotifTypeSelectionPage.this.clearNotifMsgs(this.notifType, alert, true);
            }
        }

        private boolean initialSelectionState(int n) {
            RunCommand runCommand;
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2 && (runCommand = AlertNotifTypeSelectionPage.this.getAlertDetails().getRunCommand(n)) != null) {
                if (n == 1) {
                    return (AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertDetails().getNotifType() & 0x10) > 0;
                }
                return (AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertDetails().getEscNotifType() & 0x10) > 0;
            }
            return bl;
        }

        private boolean hasRegularNotifMsgChanged() {
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(1)) {
                    if (!this.regularCheckBox.isSelected()) {
                        bl = true;
                    } else {
                        RunCommand runCommand = new RunCommand(1);
                        this.regularNotifPanel.fillRequestObject(runCommand);
                        if (!AlertNotifTypeSelectionPage.this.getAlertDetails().getRunCommand(1).equals(runCommand)) {
                            bl = true;
                        }
                    }
                } else if (this.regularCheckBox.isSelected()) {
                    bl = true;
                }
            }
            return bl;
        }

        private boolean hasEscalatedNotifMsgChanged() {
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(2)) {
                    if (!this.escalationCheckBox.isSelected()) {
                        bl = true;
                    } else {
                        RunCommand runCommand = new RunCommand(2);
                        this.escalatedNotifPanel.fillRequestObject(runCommand);
                        if (!AlertNotifTypeSelectionPage.this.getAlertDetails().getRunCommand(2).equals(runCommand)) {
                            bl = true;
                        }
                    }
                } else if (this.escalationCheckBox.isSelected()) {
                    bl = true;
                }
            }
            return bl;
        }

        private void setTabIcon() {
            int n = AlertNotifTypeSelectionPage.this.getTabIndex(this.notifType);
            if (this.regularCheckBox.isSelected() && this.escalationCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, DOWN_ICON12);
            } else if (this.regularCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, CHECK_ICON);
            } else if (this.escalationCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, DOWN_ICON);
            } else {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, null);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.regularCheckBox) {
                this.setTabIcon();
                AlertNotifTypeSelectionPage.this.fireStateChanged();
            } else if (actionEvent.getSource() == this.escalationCheckBox) {
                this.setTabIcon();
                AlertNotifTypeSelectionPage.this.fireStateChanged();
            }
        }

        public String checkForValidity() {
            String string = null;
            if (this.regularCheckBox.isSelected()) {
                string = this.regularNotifPanel.checkForValidity();
            }
            if (this.escalationCheckBox.isSelected() && string == null && AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected()) {
                string = this.escalatedNotifPanel.checkForValidity();
            }
            return string;
        }
    }

    public class PlainNotifPanel
    extends JPanel
    implements ActionListener {
        private int notifType;
        JCheckBox regularCheckBox = null;
        JCheckBox escalationCheckBox = null;
        String notifMethod;

        public PlainNotifPanel(int n) {
            this.setLayout(new GridBagLayout());
            this.notifType = n;
            this.notifMethod = AlertNotifTypeSelectionPage.getNotifTypeAsString(n);
            this.regularCheckBox = new JCheckBox(MessageFormat.format(CteStringBank.cte_alert_AlertNotifTypeSelectionPage_selectregnotif.getI18n(), this.notifMethod));
            this.escalationCheckBox = new JCheckBox(MessageFormat.format(CteStringBank.cte_alert_AlertNotifTypeSelectionPage_selectregnotif.getI18n(), this.notifMethod));
            this.regularCheckBox.addActionListener(this);
            this.escalationCheckBox.addActionListener(this);
            Utilities.addRow((JPanel)this, null, (JComponent)this.regularCheckBox);
            if (AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected()) {
                Utilities.addRow((JPanel)this, null, (JComponent)this.escalationCheckBox);
            }
            Utilities.fillRemaining(this);
            this.regularCheckBox.setSelected((AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertDetails().getNotifType() & n) > 0);
            this.escalationCheckBox.setSelected((AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertDetails().getEscNotifType() & n) > 0);
            this.setInitialState();
        }

        public void setInitialState() {
            if (!AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected()) {
                this.escalationCheckBox.setEnabled(false);
            } else {
                this.escalationCheckBox.setEnabled(true);
            }
        }

        public boolean isRegularNotifSelected() {
            return this.regularCheckBox.isSelected();
        }

        public boolean isEscalatedNotifSelected() {
            return this.escalationCheckBox.isSelected();
        }

        public void fillRequestObject(Alert alert) {
            int n;
            if (this.regularCheckBox.isSelected()) {
                alert.setAlertNotifMsg(false, this.notifType, null, 0);
            }
            if (AlertNotifTypeSelectionPage.this.getAlertDetails().isEscalationSelected() && this.escalationCheckBox.isSelected()) {
                alert.setAlertNotifMsg(true, this.notifType, null, 0);
            }
            if (this.regularCheckBox.isSelected()) {
                n = alert.getAlertDetails().getNotifType() | this.notifType;
                alert.getAlertDetails().setNotifType(n);
            } else {
                n = alert.getAlertDetails().getNotifType() & (0xFFFF ^ this.notifType);
                alert.getAlertDetails().setNotifType(n);
                AlertNotifTypeSelectionPage.this.clearNotifMsgs(this.notifType, alert, false);
            }
            if (this.escalationCheckBox.isSelected()) {
                n = alert.getAlertDetails().getEscNotifType() | this.notifType;
                alert.getAlertDetails().setEscNotifType(n);
            } else {
                n = alert.getAlertDetails().getEscNotifType() & (0xFFFF ^ this.notifType);
                alert.getAlertDetails().setEscNotifType(n);
                AlertNotifTypeSelectionPage.this.clearNotifMsgs(this.notifType, alert, true);
            }
        }

        private boolean initialSelectionState(boolean bl) {
            boolean bl2 = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                return bl ? (AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertDetails().getNotifType() & this.notifType) > 0 : (AlertNotifTypeSelectionPage.this.getAlertDetails().getAlertDetails().getEscNotifType() & this.notifType) > 0;
            }
            return bl2;
        }

        public boolean hasRegularNotifMsgChanged() {
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(true)) {
                    if (!this.regularCheckBox.isSelected()) {
                        bl = true;
                    }
                } else if (this.regularCheckBox.isSelected()) {
                    bl = true;
                }
            }
            return bl;
        }

        public boolean hasEscalatedNotifMsgChanged() {
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(false)) {
                    if (!this.escalationCheckBox.isSelected()) {
                        bl = true;
                    }
                } else if (this.escalationCheckBox.isSelected()) {
                    bl = true;
                }
            }
            return bl;
        }

        public void setTabIcon() {
            int n = AlertNotifTypeSelectionPage.this.getTabIndex(this.notifType);
            if (this.regularCheckBox.isSelected() && this.escalationCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, DOWN_ICON12);
            } else if (this.regularCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, CHECK_ICON);
            } else if (this.escalationCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, DOWN_ICON);
            } else {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, null);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.regularCheckBox) {
                this.setTabIcon();
                AlertNotifTypeSelectionPage.this.fireStateChanged();
            } else if (actionEvent.getSource() == this.escalationCheckBox) {
                this.setTabIcon();
                AlertNotifTypeSelectionPage.this.fireStateChanged();
            }
        }
    }

    public class TextMsgNotifPanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        boolean regularNotifSelected;
        private final String USE_DEFAULT_MESSAGE1 = new String(CteStringBank.Use_default_message.getI18n());
        private final String USE_DEFAULT_MESSAGE = CteStringBank.Use_default_message.getI18n();
        private int notifType;
        JTextArea msgTextArea = new JTextArea(3, 30);
        JTextArea escMsgTextArea = new JTextArea(3, 30);
        JComboBox tokenComboBox = null;
        JButton addTokenButton = new JButton(CteStringBank.Add_Token.getI18n());
        JCheckBox regularCheckBox = null;
        JCheckBox escalationCheckBox = null;
        String notifMethod;
        JCheckBox sameAsRegularCheckBox = new JCheckBox(CteStringBank.Use_same_message_as_for_regular_notification.getI18n());
        TogglePanel regularPanel = null;
        TogglePanel escalationPanel = null;
        JTextArea focusComponent = this.msgTextArea;
        int caretPosition = 0;
        private int alertId;

        public TextMsgNotifPanel(int n) {
            this.setLayout(new GridBagLayout());
            this.notifType = n;
            this.notifMethod = AlertNotifTypeSelectionPage.getNotifTypeAsString(n);
            this.regularCheckBox = new JCheckBox(MessageFormat.format(CteStringBank.cte_alert_AlertNotifTypeSelectionPage_selectregnotif.getI18n(), this.notifMethod));
            this.escalationCheckBox = new JCheckBox(MessageFormat.format(CteStringBank.cte_alert_AlertNotifTypeSelectionPage_selectregnotif.getI18n(), this.notifMethod));
            this.regularCheckBox.addActionListener(this);
            this.escalationCheckBox.addActionListener(this);
            this.msgTextArea.addFocusListener(this);
            this.escMsgTextArea.addFocusListener(this);
            this.sameAsRegularCheckBox.addActionListener(this);
            JScrollPane jScrollPane = new JScrollPane(this.msgTextArea);
            Dimension dimension = new Dimension(300, 125);
            jScrollPane.setPreferredSize(dimension);
            jScrollPane.setMinimumSize(dimension);
            JScrollPane jScrollPane2 = new JScrollPane(this.escMsgTextArea);
            jScrollPane2.setPreferredSize(dimension);
            jScrollPane2.setMinimumSize(dimension);
            this.tokenComboBox = new SComboBox();
            this.createTokenComboBox(n);
            this.addTokenButton.setPreferredSize(this.addTokenButton.getPreferredSize());
            this.addTokenButton.setMaximumSize(this.addTokenButton.getPreferredSize());
            this.addTokenButton.addActionListener(this);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(this.tokenComboBox);
            jPanel.add(this.addTokenButton);
            Utilities.addRow((Container)this, null, (JComponent)jPanel, true);
            this.regularPanel = new TogglePanel(this.regularCheckBox);
            this.regularPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 10));
            jPanel2.add((Component)new JButton(new CTEAction(this.USE_DEFAULT_MESSAGE, this)), "East");
            this.regularPanel.add((Component)jPanel2, "North");
            this.regularPanel.add((Component)jScrollPane, "Center");
            Utilities.fillRemaining(this, this.regularPanel);
            this.escalationPanel = new TogglePanel(this.escalationCheckBox);
            this.escalationPanel.setLayout(new BorderLayout());
            jPanel2 = new JPanel(new BorderLayout(0, 10));
            jPanel2.add((Component)new JButton(new CTEAction(this.USE_DEFAULT_MESSAGE1, this)), "East");
            jPanel2.add(this.sameAsRegularCheckBox);
            this.escalationPanel.add((Component)jPanel2, "North");
            this.escalationPanel.add((Component)jScrollPane2, "Center");
            Utilities.fillRemaining(this, this.escalationPanel);
            this.escalationPanel.setVisible(this.getAlertDetails().isEscalationSelected());
            IWizardController iWizardController = AlertNotifTypeSelectionPage.this.getWizardController();
            int n2 = iWizardController.getMode();
            if (n2 == 2) {
                Alert alert = (Alert)iWizardController.getData();
                this.alertId = alert.getAlertDetails().getAlertType().getId();
                if (!this.setNotifMessage(alert.getNotifMsgs(), 1)) {
                    this.setDefaultMessage(1);
                }
                if (!this.setNotifMessage(alert.getNotifMsgs(), 2)) {
                    this.setDefaultMessage(2);
                }
                this.regularPanel.setEnable((alert.getAlertDetails().getNotifType() & n) > 0);
                this.regularCheckBox.setSelected((alert.getAlertDetails().getNotifType() & n) > 0);
                this.escalationCheckBox.setSelected((alert.getAlertDetails().getEscNotifType() & n) > 0);
                if (alert.isEscalationSelected() && this.setNotifMessage(alert.getNotifMsgs(), 2)) {
                    this.escalationPanel.setEnable(true);
                } else {
                    this.setDefaultMessage(2);
                    boolean bl = alert.isEscalationSelected();
                    this.escalationCheckBox.setEnabled(bl);
                    this.escalationPanel.setEnable(bl);
                }
            } else {
                this.setInitialState();
            }
        }

        private void setInitialState() {
            this.escalationPanel.setVisible(this.getAlertDetails().isEscalationSelected());
            if (this.getAlertDetails().getAlertDetails().getAlertType().getId() != this.alertId) {
                this.setDefaultMessage(1);
                this.setDefaultMessage(2);
                this.alertId = this.getAlertDetails().getAlertDetails().getAlertType().getId();
            }
            this.regularPanel.setEnable(this.regularCheckBox.isSelected());
            this.escalationPanel.setEnable(this.escalationCheckBox.isSelected());
            if (!this.getAlertDetails().isEscalationSelected()) {
                this.escalationCheckBox.setEnabled(false);
                this.escalationPanel.setEnable(false);
            } else {
                this.escalationCheckBox.setEnabled(true);
            }
            Vector vector = this.getAlertDetails().getTokensList(this.notifType);
            this.tokenComboBox.setModel(new SortedComboBoxModel(vector));
        }

        public boolean isRegularNotifSelected() {
            return this.regularCheckBox.isSelected();
        }

        public boolean isEscalatedNotifSelected() {
            return this.escalationCheckBox.isSelected();
        }

        private void fillRequestObject(Alert alert) {
            int n;
            if (this.regularCheckBox.isSelected()) {
                alert.setAlertNotifMsg(false, this.notifType, this.getNotifMsgText(true), 0);
            }
            if (this.getAlertDetails().isEscalationSelected() && this.escalationCheckBox.isSelected()) {
                alert.setAlertNotifMsg(true, this.notifType, this.sameAsRegularCheckBox.isSelected() ? this.getNotifMsgText(true) : this.getNotifMsgText(false), 0);
            }
            if (this.notifType == 1) {
                n = this.clearUser(alert.getUserList());
                n |= this.clearUserGroup(alert.getUserGroupList());
                n |= this.clearExternalGroup(alert.getExternalGroupList());
                n |= this.clearNonGalaxyUsers(alert.getNonGalaxyUserList());
                n |= this.clearNonGalaxyUsers(alert.getNonGalaxyUserListCc());
                if ((n |= this.clearNonGalaxyUsers(alert.getNonGalaxyUserListBcc())) != 0) {
                    alert.setModificationBit(alert.getModificationBit() | 2);
                }
            }
            if (this.regularCheckBox.isSelected()) {
                n = alert.getAlertDetails().getNotifType() | this.notifType;
                alert.getAlertDetails().setNotifType(n);
            } else {
                n = alert.getAlertDetails().getNotifType() & (0xFFFF ^ this.notifType);
                alert.getAlertDetails().setNotifType(n);
                AlertNotifTypeSelectionPage.this.clearNotifMsgs(this.notifType, alert, false);
            }
            if (this.escalationCheckBox.isSelected()) {
                n = alert.getAlertDetails().getEscNotifType() | this.notifType;
                alert.getAlertDetails().setEscNotifType(n);
            } else {
                n = alert.getAlertDetails().getEscNotifType() & (0xFFFF ^ this.notifType);
                alert.getAlertDetails().setEscNotifType(n);
                AlertNotifTypeSelectionPage.this.clearNotifMsgs(this.notifType, alert, true);
            }
        }

        private boolean clearUserGroup(List list) {
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IdIdNameItem idIdNameItem = (IdIdNameItem)iterator.next();
                if (idIdNameItem.getSecondId() == 1 && !this.regularCheckBox.isSelected()) {
                    iterator.remove();
                    bl = true;
                }
                if (idIdNameItem.getSecondId() != 2 || this.escalationCheckBox.isSelected()) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        private boolean clearExternalGroup(List list) {
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IdIdNameItem idIdNameItem = (IdIdNameItem)iterator.next();
                if (idIdNameItem.getSecondId() == 1 && !this.regularCheckBox.isSelected()) {
                    iterator.remove();
                    bl = true;
                }
                if (idIdNameItem.getSecondId() != 2 || this.escalationCheckBox.isSelected()) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        private boolean clearUser(List<Alert.AlertUser> list) {
            boolean bl = false;
            Iterator<Alert.AlertUser> iterator = list.iterator();
            while (iterator.hasNext()) {
                Alert.AlertUser alertUser = iterator.next();
                if (alertUser.matchesCriteria(1) && !this.regularCheckBox.isSelected()) {
                    iterator.remove();
                    bl = true;
                }
                if (!alertUser.matchesCriteria(2) || this.escalationCheckBox.isSelected()) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        private boolean clearNonGalaxyUsers(List list) {
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IdIdNameItem idIdNameItem = (IdIdNameItem)iterator.next();
                if (idIdNameItem.getSecondId() == 1 && !this.regularCheckBox.isSelected()) {
                    iterator.remove();
                    bl = true;
                }
                if (idIdNameItem.getSecondId() != 2 || this.escalationCheckBox.isSelected()) continue;
                iterator.remove();
                bl = true;
            }
            return bl;
        }

        private boolean initialSelectionState(boolean bl) {
            return bl ? (this.getAlertDetails().getAlertDetails().getNotifType() & this.notifType) > 0 : (this.getAlertDetails().getAlertDetails().getEscNotifType() & this.notifType) > 0;
        }

        private String initialNotifMsg(boolean bl) {
            Alert alert = this.getAlertDetails();
            AlertNotifMsg alertNotifMsg = alert.getNotifMsg(!bl, this.notifType);
            if (alertNotifMsg == null) {
                return null;
            }
            return alertNotifMsg.getNotifMessage();
        }

        public boolean hasRegularNotifMsgChanged() {
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(true)) {
                    if (this.regularCheckBox.isSelected()) {
                        if (!this.getNotifMsgText(true).equals(this.initialNotifMsg(true))) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                } else if (this.regularCheckBox.isSelected()) {
                    bl = true;
                }
            }
            return bl;
        }

        public boolean hasEscalatedNotifMsgChanged() {
            boolean bl = false;
            if (AlertNotifTypeSelectionPage.this.getWizardController().getMode() == 2) {
                if (this.initialSelectionState(false)) {
                    if (this.escalationCheckBox.isSelected()) {
                        if (!this.getNotifMsgText(false).equals(this.initialNotifMsg(false))) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                } else if (this.escalationCheckBox.isSelected()) {
                    bl = true;
                }
            }
            return bl;
        }

        private void setTabIcon() {
            int n = AlertNotifTypeSelectionPage.this.getTabIndex(this.notifType);
            if (this.regularCheckBox.isSelected() && this.escalationCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, DOWN_ICON12);
            } else if (this.regularCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, CHECK_ICON);
            } else if (this.escalationCheckBox.isSelected()) {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, DOWN_ICON);
            } else {
                AlertNotifTypeSelectionPage.this.tabbedPane.setIconAt(n, null);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.regularCheckBox) {
                this.setTabIcon();
                AlertNotifTypeSelectionPage.this.fireStateChanged();
            } else if (actionEvent.getSource() == this.escalationCheckBox) {
                this.setTabIcon();
                AlertNotifTypeSelectionPage.this.fireStateChanged();
            } else if (actionEvent.getSource() == this.addTokenButton) {
                IdIdNameItem idIdNameItem = (IdIdNameItem)this.tokenComboBox.getSelectedItem();
                String string = this.focusComponent.getText();
                String string2 = string.substring(0, this.caretPosition);
                String string3 = "";
                if (this.caretPosition < string.length()) {
                    string3 = string.substring(this.caretPosition, string.length());
                }
                String string4 = string2 + idIdNameItem.getName() + string3;
                this.focusComponent.setText(string4);
            } else if (actionEvent.getSource() == this.sameAsRegularCheckBox) {
                this.escMsgTextArea.setEnabled(!this.sameAsRegularCheckBox.isSelected());
                this.escMsgTextArea.setEditable(!this.sameAsRegularCheckBox.isSelected());
            } else if (actionEvent.getActionCommand() == this.USE_DEFAULT_MESSAGE) {
                this.setDefaultMessage(1);
            } else if (actionEvent.getActionCommand() == this.USE_DEFAULT_MESSAGE1) {
                this.setDefaultMessage(2);
            }
        }

        private Alert getAlertDetails() {
            return (Alert)AlertNotifTypeSelectionPage.this.getWizardController().getData();
        }

        private void createTokenComboBox(int n) {
            Vector vector = this.getAlertDetails().getTokensList(n);
            this.tokenComboBox = new SComboBox(vector);
        }

        private boolean setNotifMessage(List list, int n) {
            boolean bl = false;
            for (AlertNotifMsg alertNotifMsg : list) {
                if (alertNotifMsg.getEsclationLevel() != n || alertNotifMsg.getNotifType() != this.notifType) continue;
                String string = alertNotifMsg.getNotifMessage();
                string = string.replaceAll("MsgNewLine_", "\n");
                string = string.replaceAll("MsgHrzSep", "==============================================================================================================");
                string = string.replaceAll("MsgTab_", "\t");
                if (n == 1) {
                    this.msgTextArea.setText(string);
                } else {
                    this.escMsgTextArea.setText(string);
                }
                bl = true;
                break;
            }
            return bl;
        }

        private void setDefaultMessage(int n) {
            Iterator iterator = this.getAlertDetails().getAlertType().getStdNotifMsgList().iterator();
            Alert alert = this.getAlertDetails();
            while (iterator.hasNext()) {
                int n2;
                int n3;
                int n4;
                AlertNotifMsg alertNotifMsg = (AlertNotifMsg)iterator.next();
                if (alertNotifMsg.getNotifType() != this.notifType) continue;
                String string = alertNotifMsg.getNotifMessage();
                string = string.replaceAll("MsgNewLine_", "\n");
                string = string.replaceAll("MsgHrzSep", "==============================================================================================================");
                string = string.replaceAll("MsgTab_", "\t");
                while ((n4 = string.indexOf("<MsgTokSep")) >= 0 && (n3 = string.indexOf(32, n4 + 1)) >= 0 && (n2 = string.indexOf(32, n3 + 1)) >= 0) {
                    String[] stringArray = string.substring(n3 + 1, n2).split(",");
                    int n5 = string.indexOf("MsgTokSep>", n3);
                    if (n5 < 0) break;
                    boolean bl = false;
                    for (String string2 : stringArray) {
                        int n6 = Integer.parseInt(string2);
                        if (!alert.isCriteriaSelected(n6)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        string = string.substring(0, n4) + string.substring(n5 + "MsgTokSep>".length() + 1);
                        continue;
                    }
                    string = string.substring(0, n4) + string.substring(n2, n5) + string.substring(n5 + "MsgTokSep>".length() + 1);
                }
                if (n == 1) {
                    this.msgTextArea.setText(string);
                    continue;
                }
                this.escMsgTextArea.setText(string);
            }
        }

        private String getNotifMsgText(boolean bl) {
            String string = "";
            string = bl ? this.msgTextArea.getText() : this.escMsgTextArea.getText();
            String string2 = string.replaceAll("\n", "MsgNewLine_");
            string = string.replaceAll("==============================================================================================================", "MsgHrzSep");
            string2 = string2.replaceAll("\t", "MsgTab_");
            return string2;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.msgTextArea) {
                this.focusComponent = this.msgTextArea;
                this.caretPosition = this.msgTextArea.getCaretPosition();
            } else if (focusEvent.getSource() == this.escMsgTextArea) {
                this.focusComponent = this.escMsgTextArea;
                this.caretPosition = this.escMsgTextArea.getCaretPosition();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        public void setRegularNotifSelected(boolean bl) {
            this.regularNotifSelected = bl;
        }
    }
}

