/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.alert;

import commvault.cte.CteStringBank;
import commvault.cte.alert.model.ASO;
import commvault.cte.alert.model.Alert;
import commvault.cte.alert.model.AlertListItem;
import commvault.cte.alert.model.AlertType;
import commvault.cte.component.ControlledTextField;
import commvault.cte.component.DescriptionPanel;
import commvault.cte.component.LayoutUtils;
import commvault.cte.component.SList;
import commvault.cte.component.Utilities;
import commvault.cte.component.wizard.AbstractWizardPage;
import commvault.cte.component.wizard.IWizardController;
import commvault.cte.component.wizard.WizardDialog;
import commvault.cte.net.IdNameItem;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AlertGeneralPage
extends AbstractWizardPage
implements DocumentListener,
ListSelectionListener,
ActionListener {
    private static final String prefix = "cte.alert.AlertGeneralPage";
    protected boolean initialized = false;
    ControlledTextField alertNameTextField = null;
    DescriptionPanel alertTypeDescriptionTextArea = null;
    SList alertCatList = null;
    SList alertList = null;
    Integer category;
    private boolean forCloning;
    boolean isLogMonitoring;
    boolean isEventViewer;
    JCheckBox subscriptionBasedAlert = new JCheckBox(CteStringBank.subscription_based_alert.getI18n());
    boolean isWindowEventsLMPolicy;

    public AlertGeneralPage(WizardDialog wizardDialog) {
        this(wizardDialog, null);
    }

    public AlertGeneralPage(WizardDialog wizardDialog, Integer n) {
        this(wizardDialog, n, false, false, false);
    }

    public AlertGeneralPage(WizardDialog wizardDialog, Integer n, boolean bl, boolean bl2, boolean bl3) {
        super(wizardDialog);
        this.category = n;
        this.isLogMonitoring = bl;
        this.isEventViewer = bl2;
        this.isWindowEventsLMPolicy = bl3;
        this.setTitle(CteStringBank.General_Information.getI18n());
        this.createHelpLink();
    }

    public AlertGeneralPage(WizardDialog wizardDialog, Integer n, boolean bl, boolean bl2) {
        this(wizardDialog, n, bl, bl2, false);
    }

    private void initComponents() {
        this.componentPanel = new JPanel();
        this.componentPanel.setLayout(new GridBagLayout());
        this.alertNameTextField = new ControlledTextField("", "", 127);
        this.alertTypeDescriptionTextArea = new DescriptionPanel();
        this.alertCatList = new SList();
        this.alertList = new SList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IWizardController iWizardController = this.getWizardController();
        iWizardController.getMode();
        this.alertNameTextField.getDocument().addDocumentListener(this);
        JLabel jLabel = new JLabel(CteStringBank.Display_Name.getI18n());
        this.alertNameTextField.setMinimumSize(new Dimension(452, 24));
        this.alertNameTextField.setPreferredSize(new Dimension(452, 24));
        jLabel.setLabelFor(this.alertNameTextField);
        jLabel.setDisplayedMnemonic('D');
        Utilities.addRow(this.componentPanel, (JComponent)jLabel, (JComponent)this.alertNameTextField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel2 = new JLabel(CteStringBank.Category.getI18n());
        JLabel jLabel3 = new JLabel(CteStringBank.Type.getI18n());
        Utilities.addRow(jPanel, (JComponent)jLabel2, (JComponent)jLabel3);
        this.alertCatList.setSelectionMode(0);
        this.alertCatList.addListSelectionListener(this);
        Dimension dimension = new Dimension(220, 200);
        JScrollPane jScrollPane = new JScrollPane(this.alertCatList);
        jScrollPane.setMaximumSize(dimension);
        jScrollPane.setPreferredSize(dimension);
        jScrollPane.setMinimumSize(dimension);
        this.alertList.setSelectionMode(0);
        this.alertList.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.alertList);
        jScrollPane2.setMaximumSize(dimension);
        jScrollPane2.setPreferredSize(dimension);
        jScrollPane2.setMinimumSize(dimension);
        Utilities.addRow(jPanel, (JComponent)jScrollPane, (JComponent)jScrollPane2);
        LayoutUtils.addRow(this.componentPanel, jPanel);
        this.alertTypeDescriptionTextArea.setOpaque(false);
        this.alertTypeDescriptionTextArea.setPreferredSize(new Dimension(270, 120));
        this.alertTypeDescriptionTextArea.setFont(jLabel.getFont());
        JScrollPane jScrollPane3 = new JScrollPane(this.alertTypeDescriptionTextArea);
        jScrollPane3.setOpaque(false);
        jScrollPane3.setPreferredSize(new Dimension(250, 140));
        jScrollPane3.setMinimumSize(new Dimension(250, 140));
        LayoutUtils.addRow(this.componentPanel, this.subscriptionBasedAlert);
        this.subscriptionBasedAlert.addActionListener(this);
        LayoutUtils.fillRemaining(this.componentPanel);
    }

    private void fillData() {
        Object object;
        Object object2;
        IdNameItem[] idNameItemArray = null;
        Alert alert = (Alert)this.getWizardController().getData();
        this.subscriptionBasedAlert.setSelected((alert.getAlertDetails().getStatus() & 0x80) > 0);
        if (alert.getAlertDetails() != null && alert.getAlertDetails().getAlertName() != null && !alert.getAlertDetails().getAlertName().toString().equals("")) {
            idNameItemArray = new IdNameItem[]{alert.getAlertDetails().getAlertCategory()};
            this.alertCatList.setListData(idNameItemArray);
            this.alertCatList.setSelectedIndex(0);
            if (!this.forCloning) {
                this.alertNameTextField.setText(alert.getAlertDetails().getAlertName().getName());
            }
            object2 = new AlertType[]{alert.getAlertType()};
            this.alertList.setListData((E[])object2);
            this.alertList.setSelectedIndex(0);
            object = alert.getAlertDetails().getDescription();
            this.alertTypeDescriptionTextArea.setDescription((String)object);
            this.fireStateChanged();
        } else {
            idNameItemArray = alert.getAlertServerObject().getAlertCategories();
            object2 = new ArrayList();
            for (IdNameItem idNameItem : idNameItemArray) {
                if (idNameItem.getId() == 7) continue;
                object2.add(idNameItem);
            }
            if (object2.size() != idNameItemArray.length) {
                idNameItemArray = object2.toArray(new IdNameItem[0]);
            }
            if (this.isLogMonitoring) {
                object = new ArrayList();
                object.addAll(object2);
                for (IdNameItem idNameItem : idNameItemArray) {
                    if (idNameItem.getId() == 8) continue;
                    object.remove(idNameItem);
                }
                this.alertCatList.setListData(object.toArray(new IdNameItem[0]));
            } else if (this.isEventViewer) {
                object = new ArrayList();
                object.addAll(object2);
                for (IdNameItem idNameItem : idNameItemArray) {
                    if (idNameItem.getId() == 8) continue;
                    object.remove(idNameItem);
                }
                this.alertCatList.setListData(object.toArray(new IdNameItem[0]));
            } else {
                object = new ArrayList();
                for (IdNameItem idNameItem : idNameItemArray) {
                    object.add(idNameItem);
                }
                if (object.size() != idNameItemArray.length) {
                    idNameItemArray = object.toArray(new IdNameItem[0]);
                }
                if (this.category != null && this.category != 0) {
                    IdNameItem[] idNameItemArray2 = new IdNameItem[1];
                    for (IdNameItem idNameItem : idNameItemArray) {
                        if (idNameItem.getId() != this.category.intValue()) continue;
                        idNameItemArray2[0] = idNameItem;
                        break;
                    }
                    this.alertCatList.setListData(idNameItemArray2);
                } else {
                    this.alertCatList.setListData(idNameItemArray);
                }
            }
            this.alertCatList.setSelectedIndex(0);
        }
        object2 = (AlertType)this.alertList.getSelectedValue();
        if (object2 != null) {
            boolean bl;
            boolean bl2 = bl = (alert.getAlertDetails().getStatus() & 4) == 4;
            if ((((AlertType)object2).getActionsAllowed() & 0x80) != 0 && !bl) {
                this.subscriptionBasedAlert.setVisible(true);
            } else {
                this.subscriptionBasedAlert.setVisible(false);
                this.subscriptionBasedAlert.setSelected(false);
            }
        } else {
            this.subscriptionBasedAlert.setSelected(false);
            this.subscriptionBasedAlert.setVisible(false);
        }
        this.setTitle();
    }

    @Override
    public void activated() {
        if (!this.initialized) {
            this.initComponents();
            this.addComponents();
            this.fillData();
            this.initialized = true;
        }
    }

    @Override
    public void deactivated() {
        String string = this.alertNameTextField.getText();
        if (string.trim().length() == 0) {
            throw new IllegalStateException(CteStringBank.DisplayNameError.getI18n());
        }
        Alert alert = (Alert)this.getWizardController().getData();
        AlertListItem alertListItem = alert.getAlertDetails();
        alertListItem.getAlertName().setName(this.alertNameTextField.getText());
        alertListItem.setAlertCategory((IdNameItem)this.alertCatList.getSelectedValue());
        AlertType alertType = (AlertType)this.alertList.getSelectedValue();
        if (alertType.getAlertTypeId() == 58) {
            this.isEventViewer = true;
        }
        alertListItem.setAlertType(new IdNameItem(alertType.getAlertTypeId(), alertType.getAlertTypeName()));
        alertListItem.setPrimaryKey(alertType.getPrimaryKey());
        int n = alertListItem.getStatus();
        n |= 0x80;
        if (!this.subscriptionBasedAlert.isSelected()) {
            n ^= 0x80;
        }
        alertListItem.setStatus(n);
        alert.getAlertDetails().setDescription(this.alertTypeDescriptionTextArea.getPlainText());
    }

    @Override
    public boolean checkValid() {
        return this.alertNameTextField.getText().length() != 0 && this.alertNameTextField.getText().trim().length() != 0 && !this.alertList.isSelectionEmpty();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.alertNameTextField.getDocument()) {
            this.fireStateChanged();
        }
    }

    public void setTitle() {
        if (this.wizard != null) {
            String string;
            String string2 = string = this.wizard.getOriginalTitle();
            if (this.alertCatList.getSelectedValue() != null && this.alertList.getSelectedValue() != null) {
                string2 = string + " " + MessageFormat.format("[{0} - {1}]", this.alertCatList.getSelectedValue(), this.alertList.getSelectedValue());
            } else if (this.alertCatList.getSelectedValue() != null) {
                string2 = string + " [" + this.alertCatList.getSelectedValue() + "]";
            }
            this.wizard.setTitle(string2);
        }
    }

    public String getAlertDisplayName() {
        return this.alertNameTextField.getText();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        if (this.getWizardController().getMode() == 2) {
            return;
        }
        ASO aSO = ((Alert)this.getWizardController().getData()).getAlertServerObject();
        Alert alert = (Alert)this.getWizardController().getData();
        this.getWizardController().setData(new Alert(aSO, alert.getAlertDetails(), null, alert));
        if (listSelectionEvent.getSource() == this.alertCatList) {
            object = (IdNameItem)this.alertCatList.getSelectedValue();
            if (object == null) {
                return;
            }
            if (((IdNameItem)object).getId() == 9) {
                this.alertList.setListData(aSO.getCustomAlertTypes());
            } else {
                this.alertList.setListData(aSO.getAlertTypes(((IdNameItem)object).getId()));
            }
            if (((IdNameItem)object).getId() == 8) {
                if (this.isLogMonitoring) {
                    AlertType[] alertTypeArray = aSO.getAlertTypes(((IdNameItem)object).getId());
                    ArrayList<AlertType> arrayList = new ArrayList<AlertType>();
                    for (AlertType alertType : alertTypeArray) {
                        if (this.isWindowEventsLMPolicy) {
                            if (alertType.getAlertTypeId() != 62) continue;
                            arrayList.add(alertType);
                            continue;
                        }
                        if (alertType.getAlertTypeId() != 57) continue;
                        arrayList.add(alertType);
                    }
                    this.alertList.setListData(arrayList.toArray());
                } else if (!this.isLogMonitoring) {
                    if (this.isEventViewer) {
                        for (AlertType alertType : aSO.getAlertTypes(((IdNameItem)object).getId())) {
                            if (alertType.getAlertTypeId() != 58) continue;
                            this.alertList.setListData(new AlertType[]{alertType});
                            break;
                        }
                    } else {
                        this.alertList.setListData(aSO.getAlertTypes(((IdNameItem)object).getId()));
                    }
                }
                this.alertList.setSelectedIndex(0);
            }
            this.alertTypeDescriptionTextArea.setDescription("");
            this.setTitle();
            this.fireStateChanged();
        } else if (listSelectionEvent.getSource() == this.alertList) {
            object = (AlertType)this.alertList.getSelectedValue();
            if (object == null) {
                return;
            }
            String string = ((AlertType)object).getDescription();
            this.alertTypeDescriptionTextArea.setDescription(string);
            this.setTitle();
            this.wizard.enableDisableComponent(CteStringBank.User3s4_and_User_Group3s4__Selection.getI18n(), !aSO.isCustomRecipientSelected(((AlertType)object).getAlertTypeName()));
            this.fireStateChanged();
        }
        object = (AlertType)this.alertList.getSelectedValue();
        if (object != null) {
            if ((((AlertType)object).getActionsAllowed() & 0x80) != 0) {
                this.subscriptionBasedAlert.setVisible(true);
            } else {
                this.subscriptionBasedAlert.setVisible(false);
                this.subscriptionBasedAlert.setSelected(false);
            }
        } else {
            this.subscriptionBasedAlert.setSelected(false);
            this.subscriptionBasedAlert.setVisible(false);
        }
    }

    private void createHelpLink() {
        String string = "main-nt";
        String string2 = "english-en-us-" + string + "-NO_TOCHEADINGS.txt-AlertWizard(GeneralInformation)";
        this.setHelpLink(string2);
    }

    public void setForCloning(boolean bl) {
        this.forCloning = bl;
        if (bl && this.alertNameTextField != null) {
            this.alertNameTextField.setText("");
        }
    }

    public void setAlertName(String string) {
        this.alertNameTextField.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.subscriptionBasedAlert) {
            ASO aSO = ((Alert)this.getWizardController().getData()).getAlertServerObject();
            this.wizard.enableDisableComponent(CteStringBank.User3s4_and_User_Group3s4__Selection.getI18n(), !this.subscriptionBasedAlert.isSelected());
        }
    }
}

