/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.logger;

import commvault.cte.logger.ILogger;
import commvault.cte.logger.configuration.LogConfig;
import commvault.cte.logger.format.CVLogFormat;
import commvault.cte.logger.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerImpl
implements ILogger {
    private java.util.logging.Logger logger;
    private CVLogFormat formatter;
    private Logger newLogger;
    private Level defaultLevel;
    private boolean useLegacyLogger;
    private static Integer LastSize = 0;
    private static String PID;
    public static Hashtable<ILogger.LoggerLevel, Level> logLevelMapping;

    protected LoggerImpl(LogConfig logConfig) {
        this.defaultLevel = logConfig.getLogLevel();
        if (!logConfig.isUseLegacyLogger()) {
            this.newLogger = LoggerFactory.getLogger((String)logConfig.getApplicationName());
        } else {
            this.useLegacyLogger = true;
            this.logger = java.util.logging.Logger.getLogger(logConfig.getApplicationName());
            this.logger.setUseParentHandlers(false);
            if (this.logger.getHandlers().length == 0) {
                this.createHandler(logConfig);
            } else {
                this.ResetLogLevel(logConfig);
            }
        }
    }

    private void createHandler(LogConfig logConfig) {
        FileHandler fileHandler = null;
        String string = null;
        try {
            string = logConfig.getLogFileLoc() != null && !logConfig.getLogFileLoc().equals("") && this.isValidLogFileLoc(logConfig.getLogFileLoc()) ? logConfig.getLogFileLoc() + File.separator + logConfig.getApplicationName() : logConfig.getApplicationName();
            if (!string.endsWith(".log")) {
                string = string + ".log";
            }
            string = string.replace(".log", "%g.log");
            fileHandler = new FileHandler(string, logConfig.getLogFileSizeLimit(), logConfig.getNumberOfLogFiles(), true);
            LastSize = logConfig.getLogFileSizeLimit();
            this.logger.addHandler(fileHandler);
            if (logConfig != null && logConfig.getLogLevel() != null) {
                this.logger.setLevel(logConfig.getLogLevel());
            } else {
                this.logger.setLevel(logLevelMapping.get((Object)ILogger.LoggerLevel.LOG_INFO));
            }
            this.formatter = new CVLogFormat();
            fileHandler.setFormatter(this.formatter);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ResetLogLevel(LogConfig logConfig) {
        Level level;
        String string = "LoggerImpl::setOrResetLogLevel";
        Level level2 = this.logger.getLevel();
        if (level2 != (level = logConfig != null && logConfig.getLogLevel() != null ? logConfig.getLogLevel() : logLevelMapping.get((Object)ILogger.LoggerLevel.LOG_INFO))) {
            this.logMessage(string, "Debug level changing from [%s] to [%s] for [%s] app.", 0.0, ILogger.LoggerLevel.LOG_ERROR, level2.toString(), level.toString(), logConfig.getApplicationName());
            this.logger.setLevel(level);
        }
        if (LastSize > 0 && LastSize.intValue() != logConfig.getLogFileSizeLimit()) {
            this.logMessage(string, "Log Size changing from %s MB to %s MB for [%s] app.", 0.0, ILogger.LoggerLevel.LOG_ERROR, LastSize / 1000000, logConfig.getLogFileSizeLimit() / 1000000, logConfig.getApplicationName());
            java.util.logging.Logger logger = this.logger;
            synchronized (logger) {
                if (LastSize.intValue() != logConfig.getLogFileSizeLimit()) {
                    Handler handler = this.logger.getHandlers()[0];
                    handler.close();
                    this.logger.removeHandler(handler);
                    this.createHandler(logConfig);
                }
            }
        }
    }

    private boolean isValidLogFileLoc(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return file.canWrite();
        }
        return file.mkdir();
    }

    protected void setLogLevel(Level level) {
        this.defaultLevel = level;
        if (this.logger != null) {
            this.logger.setLevel(level);
        }
    }

    @Override
    public void Debug(String string, String string2, Object ... objectArray) {
        try {
            this.logMessage(string, string2, 0.0, this.getDefaultLevel(), objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function Debug. Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void DebugJob(String string, double d, String string2, Object ... objectArray) {
        try {
            this.logMessage(string, string2, d, this.getDefaultLevel(), objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function DebugJob(1). Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void DebugJob(ILogger.LoggerLevel loggerLevel, String string, double d, String string2, Object ... objectArray) {
        try {
            this.logMessage(string, string2, d, loggerLevel, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function DebugJob(2). Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void DebugLvl(String string, ILogger.LoggerLevel loggerLevel, String string2, Object ... objectArray) {
        try {
            this.logMessage(string, string2, 0.0, loggerLevel, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function DebugLvl(1). Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void DebugLvl(String string, ILogger.LoggerLevel loggerLevel, double d, String string2, Object ... objectArray) {
        try {
            this.logMessage(string, string2, d, loggerLevel, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function DebugLvl(2). Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void Error(String string, String string2, Object ... objectArray) {
        try {
            this.logMessage(string, string2, 0.0, ILogger.LoggerLevel.LOG_ERROR, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function Error. Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void debug(String string, Object ... objectArray) {
        try {
            this.logMessage(null, string, 0.0, this.getDefaultLevel(), objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function debug. Calling function not known. Message is:[" + string + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void debugLvl(ILogger.LoggerLevel loggerLevel, String string, Object ... objectArray) {
        try {
            this.logMessage(null, string, 0.0, loggerLevel, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function debugLvl(1). Calling function not known. Message is:[" + string + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void debugLvl(ILogger.LoggerLevel loggerLevel, double d, String string, Object ... objectArray) {
        try {
            this.logMessage(null, string, d, loggerLevel, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function debugLvl(2). Calling function not known. Message is:[" + string + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void error(String string, Object ... objectArray) {
        try {
            this.logMessage(null, string, 0.0, ILogger.LoggerLevel.LOG_ERROR, objectArray);
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function error. Calling function not known. Message is:[" + string + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public void logCustomException(Level level, String string, Exception exception) {
        try {
            ILogger.LoggerLevel loggerLevel = this.getCVLogLevel(level);
            this.logMessage("####", string, 0.0, loggerLevel, new Object[0]);
            this.logException("####", exception);
        }
        catch (Exception exception2) {
            try {
                System.err.println("Exception when logging statement in logging function logCustomException.");
                exception2.printStackTrace(System.err);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    @Override
    public void logException(String string, Exception exception) {
        try {
            String string2 = LoggerImpl.GetStackTrace(exception);
            this.logMessage(string, "Exception Message [%s]", 0.0, ILogger.LoggerLevel.LOG_ERROR, string2);
        }
        catch (Exception exception2) {
            try {
                System.err.println("Exception when logging statement in logging function logException. Calling function:[" + string + "]");
                System.err.println(exception2.toString());
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
    }

    private static String getPid() {
        if (PID == null) {
            String string = ManagementFactory.getRuntimeMXBean().getName();
            int n = string.indexOf("@");
            PID = string = n > 0 ? string.substring(0, n) : "#####";
        }
        return PID;
    }

    public static String padRight(String string, int n) {
        return String.format("%1$-" + n + "s", string);
    }

    public static String padLeft(String string, int n) {
        return String.format("%1$" + n + "s", string);
    }

    private void logMessage(String string, String string2, double d, ILogger.LoggerLevel loggerLevel, Object ... objectArray) {
        try {
            boolean bl;
            if (string == null || string.equals("")) {
                string = "###";
            }
            Level level = this.convertCVLogLevel(loggerLevel);
            boolean bl2 = this.useLegacyLogger ? level.intValue() >= this.defaultLevel.intValue() : (bl = this.newLogger.isTraceEnabled() && level.intValue() >= Level.FINEST.intValue() || this.newLogger.isDebugEnabled() && level.intValue() >= Level.FINER.intValue() || this.newLogger.isInfoEnabled() && level.intValue() >= Level.FINE.intValue() || this.newLogger.isWarnEnabled() && level.intValue() >= Level.INFO.intValue() || this.newLogger.isErrorEnabled() && level.intValue() >= Level.SEVERE.intValue());
            if (bl) {
                String string3 = String.format("%s%s %s %s %s -> %s", LoggerImpl.padRight(LoggerImpl.getPid(), 5), LoggerImpl.padLeft(String.valueOf(Thread.currentThread().getId()), 3), Utils.now(null), level.toString(), string, String.format(string2, objectArray));
                if (this.useLegacyLogger) {
                    this.logger.log(level, string3);
                } else if (loggerLevel == ILogger.LoggerLevel.LOG_VERBOSE) {
                    this.newLogger.trace(string3);
                } else if (loggerLevel == ILogger.LoggerLevel.LOG_DETAILS) {
                    this.newLogger.debug(string3);
                } else if (loggerLevel == ILogger.LoggerLevel.LOG_TRACING) {
                    this.newLogger.info(string3);
                } else if (loggerLevel == ILogger.LoggerLevel.LOG_INFO) {
                    this.newLogger.warn(string3);
                } else if (loggerLevel == ILogger.LoggerLevel.LOG_ERROR) {
                    this.newLogger.error(string3);
                }
            }
        }
        catch (Exception exception) {
            try {
                System.err.println("Exception when logging statement in logging function logMessage. Calling function:[" + string + "]. Message is:[" + string2 + "]");
                System.err.println(exception.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private ILogger.LoggerLevel getDefaultLevel() {
        return this.getCVLogLevel(this.defaultLevel);
    }

    public Level convertCVLogLevel(ILogger.LoggerLevel loggerLevel) {
        Iterator<Map.Entry<ILogger.LoggerLevel, Level>> iterator = logLevelMapping.entrySet().iterator();
        int n = loggerLevel.getEnumValue();
        Level level = Level.INFO;
        while (iterator.hasNext()) {
            Map.Entry<ILogger.LoggerLevel, Level> entry = iterator.next();
            ILogger.LoggerLevel loggerLevel2 = entry.getKey();
            if (n != loggerLevel2.getEnumValue()) continue;
            level = entry.getValue();
            break;
        }
        return level;
    }

    public ILogger.LoggerLevel getCVLogLevel(Level level) {
        Iterator<Map.Entry<ILogger.LoggerLevel, Level>> iterator = logLevelMapping.entrySet().iterator();
        ILogger.LoggerLevel loggerLevel = ILogger.LoggerLevel.LOG_INFO;
        while (iterator.hasNext()) {
            Map.Entry<ILogger.LoggerLevel, Level> entry = iterator.next();
            if (entry.getValue() != level) continue;
            loggerLevel = entry.getKey();
            break;
        }
        return loggerLevel;
    }

    @Override
    public <T extends Exception> T log(String string, T t) {
        this.logException(string, t);
        return t;
    }

    @Override
    public <T extends Exception> T log(T t) {
        this.logException("", t);
        return t;
    }

    @Override
    public void finest(String string) {
        this.debugLvl(ILogger.LoggerLevel.LOG_VERBOSE, string, new Object[0]);
    }

    @Override
    public void finer(String string) {
        this.debugLvl(ILogger.LoggerLevel.LOG_DETAILS, string, new Object[0]);
    }

    @Override
    public void fine(String string) {
        this.debugLvl(ILogger.LoggerLevel.LOG_DETAILS, string, new Object[0]);
    }

    @Override
    public void info(String string) {
        this.debugLvl(ILogger.LoggerLevel.LOG_TRACING, string, new Object[0]);
    }

    @Override
    public void warning(String string) {
        this.debugLvl(ILogger.LoggerLevel.LOG_INFO, string, new Object[0]);
    }

    @Override
    public void severe(String string) {
        this.debugLvl(ILogger.LoggerLevel.LOG_ERROR, string, new Object[0]);
    }

    public static String GetStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        if (throwable.getMessage() != null && throwable.getMessage() != "") {
            printWriter.write("Error Message: " + throwable.getMessage());
        }
        printWriter.write("Error Stack: ");
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    static {
        logLevelMapping = new Hashtable();
        logLevelMapping.put(ILogger.LoggerLevel.LOG_DETAILS, Level.FINER);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_DISABLE, Level.OFF);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_ERROR, Level.SEVERE);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_INFO, Level.INFO);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_VERBOSE, Level.FINEST);
        logLevelMapping.put(ILogger.LoggerLevel.LOG_TRACING, Level.FINE);
    }
}

