-- stop an Oracle Data Pump job, either immediately, or more gracefully for possible future restart
DECLARE
  jobName    VARCHAR2(200) := ?;      -- Oracle job name
  userName  VARCHAR2(200) := ?;       -- user name, or use current user if either NULL or empty
  forRestart VARCHAR2(20) := ?;       -- later restart is possible when this is a non-empty string.
                                      -- when this option is selected, the stop may take more time.
 
  handle   NUMBER;
  tmpUser  VARCHAR2(200);
  immediate NUMBER := 1;
  keep_master NUMBER := 0;
BEGIN
 
  IF userName IS NOT NULL THEN
    handle := DBMS_DATAPUMP.ATTACH(jobName, userName);
  ELSE
    SELECT USER INTO tmpUser FROM DUAL;
    handle := DBMS_DATAPUMP.ATTACH(jobName, tmpUser);
  END IF;

  if forRestart IS NOT NULL THEN
    immediate := 0;
    keep_master := 1;
  END IF;

  DBMS_DATAPUMP.STOP_JOB(handle => handle, immediate => immediate, keep_master => keep_master);

END;
