-- transfer a file from remote to local
DECLARE
  sourceDirectory VARCHAR2(200) := ?;          -- source Oracle directory object name
  sourceFileName VARCHAR2(200) := ?;           -- source file basename
  destDirectory VARCHAR2(200) := ?;            -- destination Oracle directory object name
  destFileName VARCHAR2(200) := ?;             -- destination file basename
  remoteLink VARCHAR2(200) := ?;               -- database link to source database
BEGIN
 
  DBMS_FILE_TRANSFER.GET_FILE(
    source_directory_object       => sourceDirectory,
    source_file_name              => sourceFileName,
    source_database               => remoteLink,
    destination_directory_object  => destDirectory,
    destination_file_name         => destFileName
  );

END;
