

--  ------------  Generated from [../../../Source/CommServer/WFDB/Sp/cvsp_drop_fkeys.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/WFDB/Sp/cvsp_drop_fkeys.sp,v $ $Id: cvsp_drop_fkeys.sp,v 1.2 2015/02/11 17:56:12 chandru Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  cvsp_drop_fkeys()
--  |
--  | Description:  Stored procedure to drop table foreign key
--  |
--  |       Input:  fromTable, fromColumn, ToTable
--	|
--  |      Output:  error code
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: cvsp_drop_fkeys <<<'

IF EXISTS (select * from sysobjects where name='cvsp_drop_fkeys')
	drop procedure cvsp_drop_fkeys
IF EXISTS (select * from GxQscripts where name='cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO
print '... Creating Procedure: cvsp_drop_fkeys'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure cvsp_drop_fkeys
  @fromTable varchar(40),
  @fromColumn varChar(40),
  @ToTable varchar(40)
AS
declare @fkName     varchar (255)
declare @execString nvarchar (255)
declare @errCode    int
set	@errCode = 0
IF object_id('tempdb.dbo.#ffk') is not null DROP TABLE #ffk
CREATE TABLE #ffk
(
	PKTABLE_QUALIFIER		varchar(255),
	PKTABLE_OWNER	varchar(255),
	PKTABLE_NAME	varchar(255),
	PKCOLUMN_NAME	varchar(255),
	FKTABLE_QUALIFIER	varchar(255),
	FKTABLE_OWNER	varchar(255),
	FKTABLE_NAME	varchar(255),
	FKCOLUMN_NAME	varchar(255),
	KEY_SEQ		int,
	UPDATE_RULE	int,
	DELETE_RULE	int,
	FK_NAME	varchar(255),
	PK_NAME	varchar(255),
	DEFERRABILITY	varchar(255)
)
INSERT INTO  #ffk
EXEC  sp_fkeys @fktable_name=@fromTable
DECLARE fkCursor CURSOR FOR
	select distinct  FK_NAME from #ffk
	where PKTABLE_NAME = @ToTable
	AND FKCOLUMN_NAME = @fromColumn
OPEN fkCursor
FETCH	NEXT FROM fkCursor INTO @fkName
WHILE	@@FETCH_STATUS = 0
BEGIN
		--print 'Dropping constraint [' + @fkName + '] from table [' + @fromTable + '] to table [' + @ToTable + '].'
		set @execString = 'alter table ' + @fromTable +' drop ' + @fkName
		exec sp_executesql @execString
		set @errCode = @@error
		IF @errCode <> 0
			break;
		FETCH	NEXT FROM fkCursor INTO @fkName
END
CLOSE fkCursor
DEALLOCATE fkCursor
drop table #ffk
IF @errCode <> 0
	return @errCode
ELSE
	return 0
GO

IF EXISTS (select * from GxQscripts where name = 'cvsp_drop_fkeys')
	delete from GxQscripts where name = 'cvsp_drop_fkeys'
GO

IF EXISTS (select * from GXDBVersions where aliasname='cvsp_drop_fkeys')
	delete from GXDBVersions where aliasname = 'cvsp_drop_fkeys'
GO

insert into GXDBVersions values(2, 'cvsp_drop_fkeys',  '00010002000000000000', 'cvsp_drop_fkeys', '00010002000000000000')
GO

