-- This script checks whether DB is on 8.0 or 9.0 release
DECLARE @DBVersionId INTEGER
SET 		@DBVersionId = 0

DECLARE @DBVersion VARCHAR(128)
SET 		@DBVersion = 0

DECLARE @errorCode INTEGER 
SET			@errorCode = 0

DECLARE @ErrorTag NVARCHAR(20) 
SET			@ErrorTag = '###ERROR###'

DECLARE @WarningTag NVARCHAR(20) 
SET			@WarningTag = '###WARNING###'

DECLARE @AdviceTag NVARCHAR(20) 
SET			@AdviceTag = '###ADVICE###'

DECLARE @HeaderTag NVARCHAR(20) 
SET			@HeaderTag = '###HEADER###'

DECLARE @DataTag NVARCHAR(20) 
SET			@DataTag = '###DATA###'

DECLARE @DescTag NVARCHAR(20) 
SET	@DescTag = '###DESCRIPTION###'

DECLARE @colSeperator NVARCHAR(20) 
SET			@colSeperator = ':,:'

PRINT @DescTag + ' Check for supported release on WFEngine'

IF EXISTS (SELECT * FROM SYSOBJECTS WHERE id = OBJECT_ID(N'[dbo].[SimAllGalaxyRel]') and OBJECTPROPERTY(id, N'IsTable') = 1)
BEGIN
	SELECT TOP 1 @DBVersionId = id, @DBVersion = release FROM SimAllGalaxyRel ORDER BY id DESC
END
ELSE
BEGIN
	SET @errorCode = -1
	GOTO CX_EXIT
END

SET	@errorCode	=	@@ERROR 
IF	@errorCode != 0 GOTO CX_EXIT 

CX_EXIT: 
	IF @errorCode != 0 
	BEGIN
		IF @errorCode = -1
			PRINT @errorCode + ' Failed to check the software release. SimAllGalaxyRel table missing.'
		ELSE
			PRINT @errorCode + ' Failed to check the software release.'
		
		SELECT 2
	END
	ELSE IF @DBVersionId <> 15 AND @DBVersionId <> 16
	BEGIN
		PRINT @errorCode + ' Current Release ' + @DBVersion + ' is not supported for upgrade to version 11.'
		SELECT 2
	END
	ELSE
		SELECT 0
			
	RETURN
