SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	DECLARE @ViewNameCursorFlag 	INTEGER
	SET 		@ViewNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 		@errorCode	= 0
	
	DECLARE	@ViewName		NVARCHAR(256)

	DECLARE @ViewIdentifier		INTEGER
	SET 	@ViewIdentifier = 4 -- (View type in sysobjects)
	
	DECLARE	ViewNameListCursor CURSOR STATIC FOR
	SELECT	distinct aliasname
	FROM		GXDBVersions
	WHERE		type = @ViewIdentifier 

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@ViewNameCursorFlag = 1
	OPEN	ViewNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM ViewNameListCursor
	INTO @ViewName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all views
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		print '>>> Drop View: ' + @ViewName + ' <<<'
		
		IF EXISTS (select * from sysobjects where name = @ViewName and OBJECTPROPERTY(id, N'IsView') = 1) 
			EXEC ('DROP VIEW [' + @ViewName + ']')
			
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		IF EXISTS (select * from GXDBVersions where aliasname = @ViewName AND type = @ViewIdentifier)
			DELETE FROM GXDBVersions WHERE aliasname = @ViewName AND type = @ViewIdentifier 

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM ViewNameListCursor
		INTO @ViewName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @ViewNameCursorFlag = 1
	BEGIN
			CLOSE				ViewNameListCursor
			DEALLOCATE	ViewNameListCursor
	END
END	

RETURN
GO

