SET QUOTED_IDENTIFIER OFF
SET NOCOUNT ON
GO

BEGIN
	DECLARE @TriggerNameCursorFlag 	INTEGER
	SET 	@TriggerNameCursorFlag 	= 0
	
	DECLARE	@errorCode	INTEGER
	SET 	@errorCode	= 0
	
	DECLARE	@TriggerName			NVARCHAR(256)
	DECLARE @TriggerIdentifier		INTEGER
	SET 	@TriggerIdentifier = 6 -- (Trigger type in sysobjects)
	
	DECLARE	TriggerNameListCursor CURSOR STATIC FOR
	SELECT	distinct aliasname
	FROM		GXDBVersions
	WHERE		type = @TriggerIdentifier 

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
		
	SET		@TriggerNameCursorFlag = 1
	OPEN	TriggerNameListCursor

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT

	FETCH	NEXT 
	FROM TriggerNameListCursor
	INTO @TriggerName

	SET	@errorCode	=	@@ERROR
	IF	@errorCode != 0 GOTO CX_EXIT
	
	--Drop all triggers
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		print '>>> Drop Trigger: ' + @TriggerName + ' <<<'
	
		IF EXISTS (select * from sysobjects where name = @TriggerName and OBJECTPROPERTY(id, N'IsTrigger') = 1) 
			EXEC ('DROP TRIGGER [' + @TriggerName + ']')
			
		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		IF EXISTS (select * from GXDBVersions where aliasname = @TriggerName AND type = @TriggerIdentifier)
			DELETE FROM GXDBVersions WHERE aliasname = @TriggerName AND type = @TriggerIdentifier 

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT

		FETCH	NEXT 
		FROM TriggerNameListCursor
		INTO @TriggerName

		SET	@errorCode	=	@@ERROR
		IF	@errorCode != 0 GOTO CX_EXIT		
	END

CX_EXIT:	
	IF @TriggerNameCursorFlag = 1
	BEGIN
			CLOSE		TriggerNameListCursor
			DEALLOCATE	TriggerNameListCursor
	END
END	

RETURN
GO

